/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.Transform;

import FCSalyzer.Transform.ChannelTransform;
import FCSalyzer.Transform.FCStransformer;
import java.util.ArrayList;

public class ChannelTransformCached
extends ChannelTransform {
    private Double[] valuesFromChannels;
    private static final ArrayList<ChannelTransformCached> availableTransformers = new ArrayList();

    private ChannelTransformCached(float offset, float logDecades, long channelCount) {
        super(offset, logDecades, channelCount);
        this.valuesFromChannels = new Double[(int)channelCount];
        for (int i = 0; i < this.valuesFromChannels.length; ++i) {
            this.valuesFromChannels[i] = Math.pow(10.0, (double)i / this.logFactor) * this.scaleStart;
        }
    }

    public static FCStransformer getTransformer(float offset, float logDecades, long channelCount) {
        for (ChannelTransformCached currentTransform : availableTransformers) {
            boolean isEqual = true;
            if (currentTransform.scaleStart != (double)offset) {
                isEqual = false;
            }
            if (currentTransform.decades != logDecades) {
                isEqual = false;
            }
            if (currentTransform.channelCount != channelCount) {
                isEqual = false;
            }
            if (!isEqual) continue;
            return currentTransform;
        }
        if (channelCount > 2000L) {
            return null;
        }
        ChannelTransformCached newT = new ChannelTransformCached(offset, logDecades, channelCount);
        availableTransformers.add(newT);
        return newT;
    }

    @Override
    public double inverse(double channel) {
        return this.valuesFromChannels[(int)channel];
    }
}

