/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FACS_objects.FACS_annotation;
import FCSalyzer.FACS_objects.FACS_canvas;
import FCSalyzer.FACS_objects.FACS_comment;
import FCSalyzer.FACS_objects.FACS_panel;
import FCSalyzer.FACS_objects.FACS_plot;
import FCSalyzer.FACS_objects.FACS_statistics;
import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_data;
import FCSalyzer.FCS.FCS_gate;
import FCSalyzer.FCS.FCS_marker;
import FCSalyzer.FCS.FCS_quadrant;
import FCSalyzer.FCS.FCS_region;
import FCSalyzer.FCS.rawData.FCS_data_factory;
import FCSalyzer.FCS.rawData.FCS_datafile;
import FCSalyzer.GUI.FACS_documentMouseListener;
import FCSalyzer.GUI.colorGradient;
import FCSalyzer.GUI.documentFormatDialog;
import FCSalyzer.GUI.exportDialog;
import FCSalyzer.GUI.mainFrame;
import FCSalyzer.GUI.plotFormatDialog;
import FCSalyzer.GUI.regionGateDialog;
import FCSalyzer.GUI.selectionBorder;
import FCSalyzer.GUI.statisticsDialog;
import FCSalyzer.Transform.Compensation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.DataFormatException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import staticStuff.Fileservice;
import staticStuff.ImageExporter;
import staticStuff.SVG_Exporter;
import staticStuff.customCursors;
import staticStuff.privateClipboard;
import staticStuff.staticMethods;

public class FACS_document
implements Printable,
Pageable {
    public static final String DocumentVersion = "1.0";
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_TOP = 3;
    public static final int ALIGN_BOTTOM = 4;
    private String name = "New Document";
    private File docFile = null;
    private JScrollPane documentScroller;
    private FACS_canvas holder;
    private JPanel mouseDragArea = new JPanel();
    private Border selBorder = new selectionBorder();
    private Border fullBorder = BorderFactory.createLineBorder(Color.BLACK);
    private PageFormat currentPage;
    private mainFrame theApp;
    private boolean drawQuadrant = false;
    private boolean drawMarker = false;
    private boolean drawRegion = false;
    private FCS_RegionGatesHolder theRaG = new FCS_RegionGatesHolder();
    private int lastStatistics = Integer.MIN_VALUE;
    private int stepSize = 1;
    private boolean noAttachedDataLoaded = true;
    private FACS_documentMouseListener mL;
    private ArrayList<FCS_data> documentDataFiles = new ArrayList();
    private ArrayList<Compensation> documentCompensations = new ArrayList();
    private ArrayList<colorGradient> gradients = new ArrayList();
    private static final String XML_name = "FCSalyzer_document";
    private static final String XML_version = "Version";
    private static final String XML_creator = "Creator";
    private static final String XML_creator_name = "Name";
    private static final String XML_creator_ver = "Version";
    private static final String XML_path = "Path";
    private static final String XML_fileSep = "FileSeparator";
    private static final String XML_docu = "Document";
    private static final String XML_docu_width = "DocumentWidth";
    private static final String XML_docu_height = "DocumentHeight";
    private static final String XML_paper = "Paper";
    private static final String XML_paper_width = "Width";
    private static final String XML_paper_height = "Height";
    private static final String XML_paper_img_width = "ImageableWidth";
    private static final String XML_paper_img_height = "ImageableHeight";
    private static final String XML_paper_img_X = "ImageableX";
    private static final String XML_paper_img_Y = "ImageableY";
    private static final String XML_compensations = "Compensations";
    private static final String XML_gradients = "Gradients";
    private static final String XML_attachedData = "AttachedData";
    private static final String XML_stepSize = "StepSize";

    private FACS_document() {
    }

    public int getComponentCount() {
        return this.holder.getFACSComponentCount();
    }

    public Integer getStepSize() {
        return this.stepSize;
    }

    void setStepSize(Integer in) {
        this.stepSize = in;
    }

    private void prepare(mainFrame paramFrame) {
        this.holder = new FACS_canvas(this.currentPage);
        this.holder.setCanvasSize(1, 1);
        this.theApp = paramFrame;
        this.holder.setBackground(Color.WHITE);
        this.mL = new FACS_documentMouseListener(this);
        this.holder.addMouseListener(this.mL);
        this.holder.addMouseMotionListener(this.mL);
        this.holder.setLayout(null);
        this.mouseDragArea = new JPanel();
        this.mouseDragArea.setBorder(this.selBorder);
        this.mouseDragArea.setOpaque(false);
        this.mouseDragArea.setVisible(false);
        this.mouseDragArea.setBounds(0, 0, 1, 1);
        this.holder.add(this.mouseDragArea);
        FlowLayout fL = new FlowLayout(3);
        JPanel inter = new JPanel(fL);
        inter.add(this.holder);
        inter.add(Box.createGlue());
        this.documentScroller = new JScrollPane(inter);
        this.documentScroller.setAutoscrolls(true);
        this.documentScroller.getVerticalScrollBar().setUnitIncrement(20);
        this.documentScroller.getHorizontalScrollBar().setUnitIncrement(20);
        this.theApp.setTitle(this.name);
    }

    public FACS_document(mainFrame paramFrame, PageFormat newPage) {
        this.currentPage = newPage;
        this.gradients.add(new colorGradient("Rainbow", colorGradient.rainbowInt, colorGradient.gradientSteps));
        this.prepare(paramFrame);
    }

    public FACS_document(mainFrame paramFrame, PageFormat newPage, File toOpen) throws FileNotFoundException, IOException, IllegalArgumentException, ParserConfigurationException, SAXException {
        Node current;
        int i;
        Node current2;
        String attachedFile;
        this.currentPage = newPage;
        this.prepare(paramFrame);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document XML_doc = dBuilder.parse(toOpen);
        Node rootNode = XML_doc.getDocumentElement();
        if (!rootNode.getNodeName().equals(XML_name)) {
            NodeList nL = rootNode.getChildNodes();
            for (int i2 = 0; i2 < nL.getLength(); ++i2) {
                Node current3 = nL.item(i2);
                if (!current3.getNodeName().equals(XML_name)) continue;
                rootNode = current3;
            }
        }
        Node creator_node = null;
        Node path_node = null;
        Node separator_node = null;
        Node doc_node = null;
        Node rg_node = null;
        Node comp_node = null;
        Node gradient_node = null;
        Node attached_node = null;
        Node stepSize_node = null;
        ArrayList<Node> data_nodes = new ArrayList<Node>();
        ArrayList<Node> comment_nodes = new ArrayList<Node>();
        ArrayList<Node> plot_nodes = new ArrayList<Node>();
        NodeList nL = rootNode.getChildNodes();
        for (int i3 = 0; i3 < nL.getLength(); ++i3) {
            Node current4 = nL.item(i3);
            if (current4.getNodeName().equals(XML_creator)) {
                creator_node = current4;
                continue;
            }
            if (current4.getNodeName().equals(XML_path)) {
                path_node = current4;
                continue;
            }
            if (current4.getNodeName().equals(XML_attachedData)) {
                attached_node = current4;
                continue;
            }
            if (current4.getNodeName().equals(XML_fileSep)) {
                separator_node = current4;
                continue;
            }
            if (current4.getNodeName().equals(XML_docu)) {
                doc_node = current4;
                continue;
            }
            if (current4.getNodeName().equals("Regions_and_Gates")) {
                rg_node = current4;
                continue;
            }
            if (current4.getNodeName().equals(XML_compensations)) {
                comp_node = current4;
                continue;
            }
            if (current4.getNodeName().equals(XML_gradients)) {
                gradient_node = current4;
                continue;
            }
            if (current4.getNodeName().equals("FCS_data")) {
                data_nodes.add(current4);
                continue;
            }
            if (current4.getNodeName().equals("FACS_comment")) {
                comment_nodes.add(current4);
                continue;
            }
            if (current4.getNodeName().equals("FACS_plot")) {
                plot_nodes.add(current4);
                continue;
            }
            if (!current4.getNodeName().equals(XML_stepSize)) continue;
            stepSize_node = current4;
        }
        ArrayList<attachedDataHolder> attachedFiles = new ArrayList<attachedDataHolder>();
        if (attached_node != null && !(attachedFile = staticMethods.getNodeText(attached_node)).isEmpty()) {
            File attachedData = new File(toOpen.getParentFile(), attachedFile);
            if (attachedData.exists()) {
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(attachedData));
                    int savedFiles = staticMethods.bytesAsInt(in.read(), in.read(), in.read(), in.read());
                    for (int i4 = 0; i4 < savedFiles; ++i4) {
                        int count = staticMethods.bytesAsInt(in.read(), in.read(), in.read(), in.read());
                        for (int j = 0; j < count; ++j) {
                            int index = in.read();
                            int length = staticMethods.bytesAsInt(in.read(), in.read(), in.read(), in.read());
                            if (in.available() >= length) {
                                File current5 = File.createTempFile("FCSalyzer", ".fcs");
                                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(current5));
                                for (int k = 0; k < length; ++k) {
                                    out.write(in.read());
                                }
                                out.close();
                                try {
                                    FCS_datafile currDat = FCS_data_factory.getFCS_data(current5);
                                    attachedFiles.add(new attachedDataHolder(i4, index, currDat));
                                    continue;
                                }
                                catch (DataFormatException d) {
                                    throw new IOException();
                                }
                            }
                            throw new IOException();
                        }
                    }
                    in.close();
                    this.noAttachedDataLoaded = false;
                }
                catch (IOException i5) {
                    JOptionPane.showMessageDialog(null, "The attached data in " + attachedData.getName() + " could not be loaded!", "Error loading attached data", 0);
                    attachedFiles.clear();
                }
            }
            attachedData = null;
        }
        boolean ver0915 = false;
        boolean ver0918 = false;
        String oldPath = "";
        String currentPath = toOpen.getPath();
        String oldFileSeparator = "";
        if (creator_node == null) {
            throw new IllegalArgumentException("FCX file does not contain Creator section");
        }
        nL = creator_node.getChildNodes();
        for (int i6 = 0; i6 < nL.getLength(); ++i6) {
            Node current6 = nL.item(i6);
            if (!current6.getNodeName().equals("Version")) continue;
            String ver = staticMethods.getNodeText(current6);
            if (ver.equals("0.9.15-alpha") || ver.equals("0.9.14-alpha") || ver.equals("0.9.13-alpha") || ver.equals("0.9.12-alpha") || ver.equals("0.9.11-alpha") || ver.equals("0.9.10-alpha") || ver.equals("0.9.9-alpha") || ver.equals("0.9.8-alpha") || ver.equals("0.9.7-alpha") || ver.equals("0.9.6-alpha") || ver.equals("0.9.5-alpha")) {
                ver0915 = true;
            }
            if (!ver.equals("0.9.18-alpha") && !ver.equals("0.9.17-alpha") && !ver.equals("0.9.16-alpha")) continue;
            ver0918 = true;
        }
        if (path_node == null) {
            throw new IllegalArgumentException("FCX file does not contain Path section");
        }
        oldPath = staticMethods.getNodeText(path_node);
        if (separator_node == null) {
            throw new IllegalArgumentException("FCX file does not contain File Separator section");
        }
        oldFileSeparator = staticMethods.getNodeText(separator_node);
        if (stepSize_node != null) {
            this.stepSize = staticMethods.getNodeInteger(stepSize_node, this.stepSize);
        }
        Paper newPaper = new Paper();
        double width = 0.0;
        double height = 0.0;
        double imagewidth = 0.0;
        double imageheight = 0.0;
        double x = 0.0;
        double y = 0.0;
        Integer docWidth = null;
        Integer docHeight = null;
        if (doc_node == null) {
            throw new IllegalArgumentException("FCX file does not contain Document section");
        }
        nL = doc_node.getChildNodes();
        for (int i7 = 0; i7 < nL.getLength(); ++i7) {
            Node curr2 = nL.item(i7);
            if (curr2.getNodeName().equals(XML_docu_width)) {
                docWidth = staticMethods.getNodeInteger(curr2, null);
                continue;
            }
            if (curr2.getNodeName().equals(XML_docu_height)) {
                docHeight = staticMethods.getNodeInteger(curr2, null);
                continue;
            }
            if (!curr2.getNodeName().equals(XML_paper)) continue;
            NodeList nL3 = curr2.getChildNodes();
            for (int k = 0; k < nL3.getLength(); ++k) {
                Node curr3 = nL3.item(k);
                if (curr3.getNodeName().equals(XML_paper_width)) {
                    width = staticMethods.getNodeDouble(curr3, 0.0);
                    continue;
                }
                if (curr3.getNodeName().equals(XML_paper_height)) {
                    height = staticMethods.getNodeDouble(curr3, 0.0);
                    continue;
                }
                if (curr3.getNodeName().equals(XML_paper_img_width)) {
                    imagewidth = staticMethods.getNodeDouble(curr3, 0.0);
                    continue;
                }
                if (curr3.getNodeName().equals(XML_paper_img_height)) {
                    imageheight = staticMethods.getNodeDouble(curr3, 0.0);
                    continue;
                }
                if (curr3.getNodeName().equals(XML_paper_img_X)) {
                    x = staticMethods.getNodeDouble(curr3, 0.0);
                    continue;
                }
                if (!curr3.getNodeName().equals(XML_paper_img_Y)) continue;
                y = staticMethods.getNodeDouble(curr3, 0.0);
            }
        }
        if (docWidth != null && docHeight != null) {
            this.holder.setCanvasSize(docWidth, docHeight);
        }
        newPaper.setImageableArea(x, y, imagewidth, imageheight);
        newPaper.setSize(width, height);
        this.currentPage.setPaper(newPaper);
        this.holder.setPage(this.currentPage, false);
        FCS_RegionGatesHolder newR = FCS_RegionGatesHolder.fromXML(rg_node);
        if (newR != null) {
            this.theRaG = newR;
        }
        if (comp_node != null) {
            nL = comp_node.getChildNodes();
            for (int i8 = 0; i8 < nL.getLength(); ++i8) {
                current2 = nL.item(i8);
                if (!current2.getNodeName().equals("Compensation")) continue;
                this.documentCompensations.add(Compensation.fromXML(current2, this.documentCompensations));
            }
            if (!this.documentCompensations.isEmpty() && ver0918) {
                JOptionPane.showMessageDialog(null, "This FCX file is from version 0.9.18-alpha or earlier.\nDue to internal chances from FCSalyzer version 0.9.19-alpha, some compensations might not be correct any longer.\nPlease check your compensations!", "Please check compensation", 1);
            }
        }
        if (gradient_node != null) {
            nL = gradient_node.getChildNodes();
            for (int i9 = 0; i9 < nL.getLength(); ++i9) {
                current2 = nL.item(i9);
                if (!current2.getNodeName().equals("Gradient")) continue;
                this.gradients.add(colorGradient.fromXML(current2));
            }
        }
        for (int i10 = 0; i10 < data_nodes.size(); ++i10) {
            current2 = (Node)data_nodes.get(i10);
            if (!current2.getNodeName().equals("FCS_data")) continue;
            FCS_data.fromXML(current2, oldPath, oldFileSeparator, currentPath, this.documentCompensations, this.documentDataFiles, attachedFiles);
        }
        boolean hasSavedOrder = true;
        for (FCS_data current7 : this.documentDataFiles) {
            if (current7.saveOrder != -1) continue;
            hasSavedOrder = false;
        }
        if (hasSavedOrder) {
            int i11;
            FCS_data[] datArray = new FCS_data[this.documentDataFiles.size()];
            for (i11 = 0; i11 < datArray.length; ++i11) {
                datArray[this.documentDataFiles.get((int)i11).saveOrder] = this.documentDataFiles.get(i11);
            }
            this.documentDataFiles.clear();
            for (i11 = 0; i11 < datArray.length; ++i11) {
                this.documentDataFiles.add(datArray[i11]);
            }
        }
        ArrayList<FACS_panel> componentList = new ArrayList<FACS_panel>();
        ArrayList<Integer> componentZORder = new ArrayList<Integer>();
        for (i = 0; i < plot_nodes.size(); ++i) {
            current = (Node)plot_nodes.get(i);
            ArrayList<FACS_panel> newPlot = FACS_plot.fromXML(this, current, oldPath, oldFileSeparator, currentPath, this.documentCompensations, this.documentDataFiles, ver0915);
            if (newPlot == null) continue;
            for (FACS_panel currentPanel : newPlot) {
                componentList.add(currentPanel);
                componentZORder.add(currentPanel.recallZOrder());
            }
        }
        for (i = 0; i < comment_nodes.size(); ++i) {
            current = (Node)comment_nodes.get(i);
            FACS_comment newComment = FACS_comment.loadComment(this, current);
            if (newComment == null) continue;
            componentList.add(newComment);
            componentZORder.add(newComment.recallZOrder());
        }
        while (!componentList.isEmpty()) {
            int index = -1;
            int highestZ = -1;
            int currentTotal = componentZORder.size();
            for (int current8 = 0; current8 < currentTotal; ++current8) {
                int currentZ = (Integer)componentZORder.get(current8);
                if (highestZ >= currentZ) continue;
                highestZ = currentZ;
                index = current8;
            }
            this.holder.add((Component)componentList.get(index));
            componentList.remove(index);
            componentZORder.remove(index);
        }
        this.setName(toOpen.getName());
        for (Component comp : this.holder.getComponents()) {
            if (!(comp instanceof FACS_panel)) continue;
            int order = ((FACS_panel)comp).recallZOrder();
            try {
                this.holder.setComponentZOrder(comp, order);
            }
            catch (Exception n) {
                // empty catch block
            }
        }
        if (ver0915) {
            ArrayList<FCS_region> theRegs = this.theRaG.getRegions();
            boolean[] adjusted = new boolean[theRegs.size()];
            for (int i12 = 0; i12 < adjusted.length; ++i12) {
                adjusted[i12] = false;
            }
            for (Component currC : this.holder.getComponents()) {
                if (!(currC instanceof FACS_plot)) continue;
                FACS_plot currP = (FACS_plot)currC;
                ArrayList index = currP.getRegionToDraw();
                for (Object currIndex : index) {
                    int ind;
                    if (!(currIndex instanceof Integer) || adjusted[ind = ((Integer)currIndex).intValue()]) continue;
                    double rX = currP.getData(0).getChannels(currP.getParamX(0));
                    double factor_x = 4096.0 / rX;
                    double rY = currP.getData(0).getChannels(currP.getParamY(0));
                    double factor_y = 4096.0 / rY;
                    Polygon p = this.theRaG.getRegion(ind).getShape();
                    for (int i13 = 0; i13 < p.xpoints.length; ++i13) {
                        p.xpoints[i13] = (int)((double)p.xpoints[i13] * factor_x);
                        p.ypoints[i13] = (int)((double)p.ypoints[i13] * factor_y);
                    }
                    this.theRaG.getRegion(ind).setShape(p);
                    adjusted[ind] = true;
                }
            }
            boolean informUserRegion = false;
            for (int i14 = 0; i14 < adjusted.length; ++i14) {
                if (adjusted[i14]) continue;
                informUserRegion = true;
                FCS_region currR = this.theRaG.getRegion(i14);
                double factor_x = 4096.0 / (double)this.documentDataFiles.get(0).getChannels(currR.getParamX());
                double factor_y = 4096.0 / (double)this.documentDataFiles.get(0).getChannels(currR.getParamY());
                Polygon p = currR.getShape();
                for (int k = 0; k < p.xpoints.length; ++k) {
                    p.xpoints[k] = (int)((double)p.xpoints[k] * factor_x);
                    p.ypoints[k] = (int)((double)p.ypoints[k] * factor_y);
                }
                currR.setShape(p);
            }
            this.refreshView(true);
            if (informUserRegion) {
                JOptionPane.showMessageDialog(null, "This FCX file is from version 0.9.15-alpha or earlier.\nDue to internal chances, some regions might not be correct any longer.\nPlease check your regions!", "Please check regions", 1);
            }
        }
        this.docFile = toOpen;
    }

    public void setName(String newname) {
        this.name = newname;
        this.theApp.setTitle(this.name);
    }

    public JScrollPane getFrame() {
        return this.documentScroller;
    }

    public void newObject(Point start, Point end) {
        int h;
        this.documentScroller.grabFocus();
        int w = start.x - end.x;
        if (w < 0) {
            w = -w;
        }
        if ((h = start.y - end.y) < 0) {
            h = -h;
        }
        if (w < 5 || h < 5) {
            return;
        }
        if (this.theApp.getObjectType() == 0) {
            this.clearSelections();
            this.newPlot(start, end, 0);
            return;
        }
        if (this.theApp.getObjectType() == 7) {
            this.clearSelections();
            this.newPlot(start, end, 7);
            return;
        }
        if (this.theApp.getObjectType() == 5) {
            this.clearSelections();
            this.newPlot(start, end, 5);
            return;
        }
        if (this.theApp.getObjectType() == 1) {
            this.clearSelections();
            this.newTextArea(start, end);
            return;
        }
    }

    public void newPlot(Point start, Point end, int type) {
        int start_y;
        int start_x;
        FACS_plot newPanel = null;
        ArrayList<FCS_data> correctFiles = new ArrayList<FCS_data>();
        File[] toOpen = Fileservice.getFiles();
        if (toOpen != null) {
            newPanel = new FACS_plot(this);
            if (type == 5) {
                newPanel.setType((short)2);
            } else if (type == 7) {
                newPanel.setType((short)1);
            }
            boolean couldntOpen = false;
            boolean notFCS = false;
            for (File current : toOpen) {
                if (!current.isFile()) continue;
                FCS_data theData = null;
                try {
                    theData = FCS_data.openFCS_data(current, this.documentDataFiles, this.documentCompensations, true);
                }
                catch (IOException io) {
                    theData = null;
                    couldntOpen = true;
                }
                catch (DataFormatException de) {
                    theData = null;
                    notFCS = true;
                }
                if (theData == null) continue;
                correctFiles.add(theData);
            }
            if (couldntOpen || notFCS) {
                String message = "";
                if (couldntOpen) {
                    message = "One or more file(s) could not be opened!";
                }
                if (notFCS) {
                    message = "Fileformat of one or more file(s) not supported!";
                }
                if (couldntOpen && notFCS) {
                    message = "One or more file(s) could not be opened!\nFileformat of one or more file(s) not supported!";
                }
                JOptionPane.showMessageDialog(this.documentScroller, message, "File Error", 0);
            }
        }
        if (end.x < (start_x = start.x)) {
            start_x = end.x;
        }
        if (end.y < (start_y = start.y)) {
            start_y = end.y;
        }
        if (newPanel != null && correctFiles.size() > 0) {
            this.holder.add((Component)newPanel, 0);
            int x_axis = 0;
            FCS_data currentData = (FCS_data)correctFiles.get(0);
            String[] params = currentData.getParameterLabels();
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].trim().toLowerCase().startsWith("fsc")) continue;
                x_axis = i;
                i = params.length;
            }
            int y_axis = 1;
            if (params[x_axis].trim().toLowerCase().startsWith("fsc")) {
                String fsc_label = params[x_axis].trim().toLowerCase();
                String ssc_label = "s".concat(fsc_label.substring(1));
                for (int i = 0; i < params.length; ++i) {
                    if (!params[i].trim().toLowerCase().startsWith(ssc_label)) continue;
                    y_axis = i;
                    i = params.length;
                }
            }
            if (x_axis == y_axis && ++y_axis >= params.length) {
                y_axis = 0;
            }
            newPanel.addOverlay(currentData, x_axis, y_axis);
            newPanel.setBounds(start_x, start_y, Math.abs(end.x - start.x), Math.abs(end.y - start.y));
            for (int i = 1; i < correctFiles.size(); ++i) {
                newPanel.addOverlay((FCS_data)correctFiles.get(i));
            }
            newPanel.setSelected(true);
        }
    }

    public void newTextArea(Point start, Point end) {
        int start_y;
        FACS_comment newArea = new FACS_comment(this);
        int start_x = start.x;
        if (end.x < start_x) {
            start_x = end.x;
        }
        if (end.y < (start_y = start.y)) {
            start_y = end.y;
        }
        this.holder.add((Component)newArea, 0);
        newArea.setBounds(start_x, start_y, Math.abs(end.x - start.x), Math.abs(end.y - start.y));
        this.holder.repaint();
    }

    public void setSelectionVisible(boolean visibility) {
        this.holder.setComponentZOrder(this.mouseDragArea, 0);
        this.mouseDragArea.setVisible(visibility);
    }

    public void setSelectionBounds(Point start, Point end, boolean SHIFT) {
        int start_y;
        int start_x = start.x;
        if (end.x < start_x) {
            start_x = end.x;
        }
        if (end.y < (start_y = start.y)) {
            start_y = end.y;
        }
        this.mouseDragArea.setBounds(start_x, start_y, Math.abs(end.x - start.x), Math.abs(end.y - start.y));
        if (this.mouseDragArea.getBorder() == this.selBorder) {
            Component[] comps = this.holder.getComponents();
            Rectangle recSelection = this.mouseDragArea.getBounds();
            for (Component currentComp : comps) {
                if (!(currentComp instanceof FACS_panel)) continue;
                FACS_panel currentOb = (FACS_panel)currentComp;
                Rectangle recOb = currentComp.getBounds();
                if (recOb.intersects(recSelection)) {
                    if (!SHIFT) {
                        currentOb.setSelected(true);
                        continue;
                    }
                    currentOb.setSelected(!currentOb.getRememberedSelection());
                    continue;
                }
                if (!SHIFT) {
                    currentOb.setSelected(false);
                    continue;
                }
                currentOb.setSelected(currentOb.getRememberedSelection());
            }
        }
    }

    public void putInFront(Component aThis) {
        this.holder.setComponentZOrder(aThis, 0);
        aThis.repaint();
    }

    public void addScrollBox(JScrollPane toAdd) {
        this.holder.add(toAdd);
    }

    public boolean save() throws IOException {
        if (this.docFile != null) {
            return this.saveTo(this.docFile);
        }
        return this.saveAs();
    }

    public boolean saveAs() throws IOException {
        File save = Fileservice.getFileForSave(this.getName(), true);
        if (save != null) {
            if (save.getName().indexOf(".") == -1) {
                save = new File(save.getParent(), save.getName() + ".FCX");
            }
            if (save.isFile()) {
                if (JOptionPane.showConfirmDialog(this.documentScroller, "Overwrite file?", "Confirm file overwrite", 2, 2) == 0) {
                    return this.saveTo(save);
                }
                return false;
            }
            if (save.createNewFile()) {
                return this.saveTo(save);
            }
        }
        return false;
    }

    public boolean exportStatistics() throws IOException {
        File save;
        String name = this.getName();
        if (name.endsWith(".FCX")) {
            name = name.substring(0, name.length() - 4);
        }
        if ((save = Fileservice.getFileForSave(name, false)) != null) {
            if (save.isDirectory()) {
                return false;
            }
            if (save.isFile() ? JOptionPane.showConfirmDialog(this.documentScroller, "Overwrite file?", "Confirm file overwrite", 2, 2) != 0 : !save.createNewFile()) {
                return false;
            }
            FileOutputStream outStream = new FileOutputStream(save);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
            Component[] comps = this.holder.getComponents();
            ArrayList<FACS_statistics> stats = new ArrayList<FACS_statistics>();
            for (int i = comps.length - 1; i > -1; --i) {
                if (!(comps[i] instanceof FACS_statistics)) continue;
                stats.add((FACS_statistics)comps[i]);
            }
            for (FACS_statistics currentStats : stats) {
                out.write(currentStats.toString());
            }
            out.close();
            outStream.close();
            return true;
        }
        return false;
    }

    private synchronized boolean saveTo(File saveFile) throws IOException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document XML_doc = dBuilder.newDocument();
            XML_doc.setXmlStandalone(true);
            XML_doc.appendChild(XML_doc.createComment("FCSalyzer document. Modify at your own risk."));
            Element rootNode = XML_doc.createElement(XML_name);
            XML_doc.appendChild(rootNode);
            staticMethods.addNode(rootNode, "Version", DocumentVersion);
            Node creatorNode = staticMethods.addNode(rootNode, XML_creator, null);
            staticMethods.addNode(creatorNode, XML_creator_name, "FCSalyzer");
            staticMethods.addNode(creatorNode, "Version", "0.9.22-alpha");
            staticMethods.addNode(rootNode, XML_path, saveFile.getParent());
            staticMethods.addNode(rootNode, XML_fileSep, File.separator);
            staticMethods.addNode(rootNode, XML_stepSize, this.stepSize);
            Node documentNode = staticMethods.addNode(rootNode, XML_docu, null);
            staticMethods.addNode(documentNode, XML_docu_width, this.holder.getPagesWidth());
            staticMethods.addNode(documentNode, XML_docu_height, this.holder.getPagesHeight());
            Node paperNode = staticMethods.addNode(documentNode, XML_paper, null);
            Paper currentPaper = this.currentPage.getPaper();
            staticMethods.addNode(paperNode, XML_paper_width, currentPaper.getWidth());
            staticMethods.addNode(paperNode, XML_paper_height, currentPaper.getHeight());
            staticMethods.addNode(paperNode, XML_paper_img_width, currentPaper.getImageableWidth());
            staticMethods.addNode(paperNode, XML_paper_img_height, currentPaper.getImageableHeight());
            staticMethods.addNode(paperNode, XML_paper_img_X, currentPaper.getImageableX());
            staticMethods.addNode(paperNode, XML_paper_img_Y, currentPaper.getImageableY());
            this.theRaG.toXML(rootNode);
            Node compNode = staticMethods.addNode(rootNode, XML_compensations, null);
            for (int i = 0; i < this.documentCompensations.size(); ++i) {
                this.documentCompensations.get(i).toXML(compNode, i);
            }
            Node gradientNode = staticMethods.addNode(rootNode, XML_gradients, null);
            for (colorGradient currentGrad : this.gradients) {
                currentGrad.toXML(gradientNode);
            }
            Component[] comps = this.holder.getComponents();
            ArrayList<FACS_plot> plots = new ArrayList<FACS_plot>();
            ArrayList<FACS_comment> textAreas = new ArrayList<FACS_comment>();
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof FACS_plot) {
                    plots.add((FACS_plot)comps[i]);
                    continue;
                }
                if (!(comps[i] instanceof FACS_comment)) continue;
                textAreas.add((FACS_comment)comps[i]);
            }
            ArrayList<FCS_data> usedData = new ArrayList<FCS_data>();
            for (FACS_plot currentPlot : plots) {
                for (int overlay = 0; overlay < currentPlot.getOverlayCount(); ++overlay) {
                    FCS_data currentData = currentPlot.getData(overlay);
                    if (usedData.contains(currentData)) continue;
                    usedData.add(currentData);
                }
            }
            ArrayList<FCS_data> savedData = new ArrayList<FCS_data>();
            for (int i = 0; i < this.documentDataFiles.size(); ++i) {
                FCS_data currentData = this.documentDataFiles.get(i);
                if (!usedData.contains(currentData)) continue;
                savedData.add(currentData);
                currentData.toXML(rootNode, savedData.size() - 1, this.documentCompensations);
            }
            for (FACS_plot currentPlot : plots) {
                currentPlot.toXML(rootNode, this.documentCompensations, savedData);
            }
            usedData.clear();
            usedData = null;
            boolean dataToSave = false;
            String attachedData = "";
            for (FCS_data currentData : savedData) {
                if (currentData.getAttachedParameterCount() <= 0) continue;
                dataToSave = true;
            }
            if (dataToSave) {
                int confirmation;
                attachedData = saveFile.getName() + "A";
                File storage = new File(saveFile.getParentFile(), attachedData);
                if (storage.exists() && (saveFile != this.docFile || this.noAttachedDataLoaded) && (confirmation = JOptionPane.showConfirmDialog(null, "The storage file for attached data ('" + storage.getName() + "') already exists! Overwrite?", "Overwrite file '" + storage.getName() + "'?", 2, 3)) == 2) {
                    return false;
                }
                this.noAttachedDataLoaded = false;
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(storage));
                out.write(staticMethods.intAsBytes(savedData.size()));
                for (int i = 0; i < savedData.size(); ++i) {
                    savedData.get(i).saveAttachedData(out);
                }
                out.close();
            }
            staticMethods.addNode(rootNode, XML_attachedData, attachedData);
            savedData.clear();
            savedData = null;
            for (FACS_comment currentArea : textAreas) {
                currentArea.toXML(rootNode);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            transformer.setOutputProperty("standalone", "yes");
            DOMSource source = new DOMSource(XML_doc);
            FileOutputStream outStream = new FileOutputStream(saveFile);
            transformer.transform(source, new StreamResult(outStream));
            outStream.close();
            this.setName(saveFile.getName());
            this.docFile = saveFile;
        }
        catch (ParserConfigurationException ex) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return true;
    }

    public void hideAxisScrollers() {
        Component[] comps = this.holder.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JScrollPane)) continue;
            ((JScrollPane)comps[i]).setVisible(false);
        }
    }

    public void setObjectType(int objectType) {
        this.documentScroller.setCursor(customCursors.getCursor(objectType));
        if (objectType == 2) {
            this.mouseDragArea.setBorder(this.selBorder);
        } else {
            this.mouseDragArea.setBorder(this.fullBorder);
        }
        this.drawQuadrant = objectType == 3;
        this.drawMarker = objectType == 6;
        this.drawRegion = objectType == 4;
    }

    public boolean drawQuadrant() {
        return this.drawQuadrant;
    }

    public boolean drawMarker() {
        return this.drawMarker;
    }

    public boolean drawRegion() {
        return this.drawRegion;
    }

    public void rememberSelections() {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            if (!(component instanceof FACS_panel)) continue;
            ((FACS_panel)component).rememberSelection();
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        if (pageIndex > this.getNumberOfPages()) {
            return 1;
        }
        this.holder.print(g, pageIndex);
        return 0;
    }

    public void moveSelectedObjects(int move_x, int move_y) {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_panel currentOb;
            if (!(component instanceof FACS_panel) || !(currentOb = (FACS_panel)component).isSelected()) continue;
            currentOb.moveObject(move_x, move_y);
        }
    }

    public void alignSelectedObjects(int align) {
        Component[] comps = this.holder.getComponents();
        ArrayList<FACS_panel> selectedPanels = new ArrayList<FACS_panel>();
        for (Component component : comps) {
            FACS_panel currentOb;
            if (!(component instanceof FACS_panel) || !(currentOb = (FACS_panel)component).isSelected()) continue;
            selectedPanels.add(currentOb);
        }
        switch (align) {
            case 1: {
                Integer pixel = null;
                for (FACS_panel currentPanel : selectedPanels) {
                    int x = currentPanel.getBounds().x;
                    if (pixel == null) {
                        pixel = x;
                    }
                    if (pixel <= x) continue;
                    pixel = x;
                }
                for (FACS_panel currentPanel : selectedPanels) {
                    Rectangle r = currentPanel.getBounds();
                    r.x = pixel;
                    currentPanel.setBounds(r);
                }
                break;
            }
            case 3: {
                Integer pixel = null;
                for (FACS_panel currentPanel : selectedPanels) {
                    int y = currentPanel.getBounds().y;
                    if (pixel == null) {
                        pixel = y;
                    }
                    if (pixel <= y) continue;
                    pixel = y;
                }
                for (FACS_panel currentPanel : selectedPanels) {
                    Rectangle r = currentPanel.getBounds();
                    r.y = pixel;
                    currentPanel.setBounds(r);
                }
                break;
            }
            case 2: {
                Integer pixel = null;
                for (FACS_panel currentPanel : selectedPanels) {
                    int x = currentPanel.getBounds().x + currentPanel.getBounds().width;
                    if (pixel == null) {
                        pixel = x;
                    }
                    if (pixel >= x) continue;
                    pixel = x;
                }
                for (FACS_panel currentPanel : selectedPanels) {
                    Rectangle r = currentPanel.getBounds();
                    r.x = pixel - r.width;
                    currentPanel.setBounds(r);
                }
                break;
            }
            case 4: {
                Integer pixel = null;
                for (FACS_panel currentPanel : selectedPanels) {
                    int y = currentPanel.getBounds().y + currentPanel.getBounds().height;
                    if (pixel == null) {
                        pixel = y;
                    }
                    if (pixel >= y) continue;
                    pixel = y;
                }
                for (FACS_panel currentPanel : selectedPanels) {
                    Rectangle r = currentPanel.getBounds();
                    r.y = pixel - r.height;
                    currentPanel.setBounds(r);
                }
                break;
            }
        }
    }

    public void setSelectedObjectDragType(int dragType) {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_panel currentOb;
            if (!(component instanceof FACS_panel) || !(currentOb = (FACS_panel)component).isSelected()) continue;
            currentOb.setDragType(dragType);
        }
    }

    public void setSelectedObjectSize(int w, int h) {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_panel currentOb;
            if (!(component instanceof FACS_panel) || !(currentOb = (FACS_panel)component).isSelected()) continue;
            currentOb.setSize(w, h);
        }
    }

    public void clearSelections() {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            if (!(component instanceof FACS_panel)) continue;
            ((FACS_panel)component).setSelected(false);
        }
    }

    public void clearSelections(FACS_panel aThis) {
        this.clearSelections();
        aThis.setSelected(true);
    }

    public void duplicateSelectedObjects() {
        Component[] comps;
        ArrayList<? extends FACS_panel> duplicatedObjects = new ArrayList<FACS_panel>();
        for (Component currentComp : comps = this.holder.getComponents()) {
            FACS_panel currentObject;
            if (!(currentComp instanceof FACS_comment) && !(currentComp instanceof FACS_plot) || !(currentObject = (FACS_panel)currentComp).isSelected()) continue;
            FACS_panel duplicate = currentObject.duplicate();
            duplicatedObjects.add(duplicate);
            if (!(currentObject instanceof FACS_plot)) continue;
            duplicatedObjects.addAll(((FACS_plot)duplicate).getChildren());
        }
        for (Component currentComp : comps) {
            if (!(currentComp instanceof FACS_panel)) continue;
            ((FACS_panel)currentComp).setSelected(false);
        }
        for (FACS_panel fACS_panel : duplicatedObjects) {
            this.holder.add((Component)fACS_panel, 0);
            fACS_panel.setSelected(true);
            fACS_panel.moveObject(5, 5);
        }
    }

    public void annotateSelectedPlots() {
        Component[] comps;
        String annoKey = null;
        boolean showsLegend = false;
        ArrayList<FACS_annotation> annotateObjects = new ArrayList<FACS_annotation>();
        ArrayList<FACS_plot> selectedObjects = new ArrayList<FACS_plot>();
        for (Component component : comps = this.holder.getComponents()) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            selectedObjects.add(currentPlot);
            FACS_annotation currentAnno = annoKey == null ? currentPlot.createAnnotation() : currentPlot.createAnnotation(annoKey, showsLegend);
            if (currentAnno != null) {
                annotateObjects.add(currentAnno);
                annoKey = currentAnno.getAnnotationKeyword();
                showsLegend = currentAnno.showsLegend();
                continue;
            }
            if (annoKey != null) continue;
            return;
        }
        for (FACS_panel fACS_panel : selectedObjects) {
            fACS_panel.setSelected(false);
        }
        for (FACS_panel fACS_panel : annotateObjects) {
            fACS_panel.setSelected(true);
            this.holder.add((Component)fACS_panel, 0);
        }
        this.holder.validate();
    }

    public void statisticSelectedPlots() {
        Component[] comps;
        ArrayList<FACS_statistics> statisticObjects = new ArrayList<FACS_statistics>();
        ArrayList<FACS_plot> selectedObjects = new ArrayList<FACS_plot>();
        for (Component component : comps = this.holder.getComponents()) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            selectedObjects.add(currentPlot);
            FACS_statistics currentStat = this.lastStatistics == Integer.MIN_VALUE ? currentPlot.createStatistics() : currentPlot.createStatistics(this.lastStatistics);
            if (currentStat != null) {
                statisticObjects.add(currentStat);
                this.lastStatistics = currentStat.getStatisticsDescriptor();
                continue;
            }
            if (this.lastStatistics != Integer.MIN_VALUE) continue;
            return;
        }
        for (FACS_panel fACS_panel : selectedObjects) {
            fACS_panel.setSelected(false);
        }
        for (FACS_panel fACS_panel : statisticObjects) {
            fACS_panel.setSelected(true);
            this.holder.add((Component)fACS_panel, 0);
            fACS_panel.repaint();
        }
        this.holder.validate();
    }

    public int getComponentZOrder(Component c) {
        return this.holder.getComponentZOrder(c);
    }

    public FCS_RegionGatesHolder getRegionsAndGates() {
        return this.theRaG;
    }

    public void setApplicationObjectType(int objectType) {
        this.theApp.action(objectType);
    }

    public void deleteSelectedObjects() {
        Component[] comps;
        boolean deletedSomething = false;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_panel currentPanel;
            if (!(component instanceof FACS_panel) || !(currentPanel = (FACS_panel)component).isSelected()) continue;
            this.holder.remove(currentPanel);
            currentPanel.delete();
            deletedSomething = true;
        }
        for (FCS_region currRegion : this.theRaG.getRegions()) {
            if (!currRegion.isSelected()) continue;
            for (Component component : comps) {
                if (!(component instanceof FACS_plot)) continue;
                ((FACS_plot)component).displayRegion(currRegion, false);
            }
            this.theRaG.deleteRegion(currRegion);
            this.adjustGateMenu();
            this.refreshView(true);
            deletedSomething = true;
        }
        if (!deletedSomething) {
            for (Component component : comps) {
                if (!(component instanceof FACS_plot)) continue;
                FACS_plot currentPlot = (FACS_plot)component;
                currentPlot.deleteSelectedQuadrantMarker();
            }
        }
        this.holder.validate();
        this.holder.repaint();
    }

    public void removeComponent(Component toRemove) {
        this.holder.remove(toRemove);
    }

    @Override
    public int getNumberOfPages() {
        return this.holder.getPageCount();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.currentPage;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPage(PageFormat newPage) {
        this.currentPage = newPage;
        this.holder.setPage(newPage, true);
        this.holder.repaint();
    }

    public String getName() {
        return this.name;
    }

    public void setDataFile() {
        Component[] comps = this.holder.getComponents();
        boolean somethingSelected = false;
        for (Component component : comps) {
            if (!(component instanceof FACS_plot) || !((FACS_plot)component).isSelected()) continue;
            somethingSelected = true;
        }
        if (!somethingSelected) {
            return;
        }
        File newFile = Fileservice.getFileForLoad(false);
        if (newFile != null && newFile.isFile()) {
            FCS_data newData = null;
            try {
                newData = FCS_data.openFCS_data(newFile, this.documentDataFiles, this.documentCompensations, true);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.holder, "Data file could not be opened!", "Data error", 0);
            }
            catch (DataFormatException ex) {
                JOptionPane.showMessageDialog(this.holder, "Data file could not be opened! Wrong format?", "Data error", 0);
            }
            if (newData != null) {
                for (Component component : comps) {
                    FACS_plot toChange;
                    if (!(component instanceof FACS_plot) || !(toChange = (FACS_plot)component).isSelected()) continue;
                    ((FACS_plot)component).setData(0, newData);
                }
            }
        }
    }

    public void setNextDataFile() {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            FCS_data currentData = currentPlot.getData(0);
            FCS_data nextData = currentData.getNextData(this.documentCompensations, this.stepSize);
            if (nextData != null) {
                currentPlot.setData(0, nextData);
                continue;
            }
            JOptionPane.showMessageDialog(null, "Next Datafile could not be opened!", "Data switch error", 0);
        }
    }

    public void setPreviousDataFile() {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            FCS_data currentData = currentPlot.getData(0);
            FCS_data nextData = currentData.getPreviousDatafile(this.documentCompensations, this.stepSize);
            if (nextData != currentData) {
                currentPlot.setData(0, nextData);
                continue;
            }
            JOptionPane.showMessageDialog(null, "Previous Datafile could not be found!", "Data switch error", 0);
        }
    }

    public void editSelectedStatistics() {
        Component[] comps = this.holder.getComponents();
        ArrayList<FACS_statistics> stats = new ArrayList<FACS_statistics>();
        for (Component component : comps) {
            if (!(component instanceof FACS_statistics) || !((FACS_statistics)component).isSelected()) continue;
            stats.add((FACS_statistics)component);
        }
        if (!stats.isEmpty()) {
            int commonStats = Integer.MAX_VALUE;
            int ambiguousStats = 0;
            for (FACS_statistics currentStat : stats) {
                commonStats &= currentStat.getStatisticsDescriptor();
                ambiguousStats |= currentStat.getStatisticsDescriptor();
            }
            statisticsDialog currentInstance = statisticsDialog.getInstance();
            this.lastStatistics = currentInstance.editStats(commonStats, ambiguousStats ^= commonStats);
            if (currentInstance.isOK()) {
                ArrayList<FACS_statistics> toRemove = new ArrayList<FACS_statistics>();
                for (FACS_statistics currentStat : stats) {
                    try {
                        currentStat.setStatisticsDescriptor(this.lastStatistics);
                    }
                    catch (IOException io) {
                        toRemove.add(currentStat);
                        JOptionPane.showMessageDialog(null, "A file error occured during statistics calculations.\n\nFCSalyzer creates temporary files when calculating the statistics. This process failed. Please check if FCSalyzer can create temporary on your device. Maybe disk space is low?", "File Error", 0);
                    }
                }
                for (FACS_statistics currentStat : toRemove) {
                    this.removeComponent(currentStat);
                    for (Component currC : comps) {
                        if (!(currC instanceof FACS_plot)) continue;
                        ((FACS_plot)currC).removeChild(currentStat);
                    }
                }
            }
        }
    }

    public void editMarkers() {
        Component[] comps = this.holder.getComponents();
        ArrayList<FACS_plot> plots = new ArrayList<FACS_plot>();
        for (Component component : comps) {
            if (!(component instanceof FACS_plot) || !((FACS_plot)component).isSelected() || !((FACS_plot)component).isHistogram()) continue;
            plots.add((FACS_plot)component);
        }
        if (!plots.isEmpty()) {
            ((FACS_plot)plots.get(0)).showMarkerDialog();
        }
    }

    public void copy() {
        Component[] comps;
        boolean copySomething = false;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_panel currentPanel;
            if (!(component instanceof FACS_panel) || !(currentPanel = (FACS_panel)component).isSelected()) continue;
            currentPanel.duplicate();
            copySomething = true;
        }
        if (!copySomething) {
            for (Component component : comps) {
                if (!(component instanceof FACS_plot)) continue;
                FACS_plot currentPlot = (FACS_plot)component;
                currentPlot.copySelectedQuadrantMarkerRegion();
            }
        }
    }

    public void paste() {
        FACS_plot currentPanel;
        Component[] comps;
        Object content = privateClipboard.getInstance().getContent();
        if (content instanceof FCS_marker) {
            for (Component component : comps = this.holder.getComponents()) {
                if (!(component instanceof FACS_plot) || !(currentPanel = (FACS_plot)component).isSelected() || !currentPanel.isHistogram()) continue;
                currentPanel.paste(content);
            }
        }
        if (content instanceof FCS_quadrant || content instanceof Integer) {
            for (Component component : comps = this.holder.getComponents()) {
                if (!(component instanceof FACS_plot) || !(currentPanel = (FACS_plot)component).isSelected() || currentPanel.isHistogram()) continue;
                currentPanel.paste(content);
            }
        }
    }

    public void changeFontSize(int fontSize) {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_panel currentPanel;
            if (!(component instanceof FACS_panel) || !(currentPanel = (FACS_panel)component).isSelected()) continue;
            currentPanel.setFontSize(Float.valueOf(fontSize));
        }
    }

    public void formatDocument(Frame owner) {
        documentFormatDialog theDialog = new documentFormatDialog(owner);
        theDialog.showDialog(this.holder.getPagesWidth(), this.holder.getPagesHeight());
        this.holder.setCanvasSize(theDialog.getPagesX(), theDialog.getPagesY());
        this.documentScroller.repaint();
    }

    public void editRegionsAndGates() {
        regionGateDialog rDialog = new regionGateDialog(this.theRaG, this);
        rDialog.showDialog();
        rDialog.dispose();
        this.theApp.setGateMenu(this.theRaG.getGateDescription());
    }

    public void gateDeleted(FCS_gate delGate) {
        for (Component object : this.holder.getComponents()) {
            if (!(object instanceof FACS_plot)) continue;
            ((FACS_plot)object).gateDeleted(delGate);
        }
    }

    public void refreshView(boolean recalculateGates) {
        for (Component object : this.holder.getComponents()) {
            if (!(object instanceof FACS_plot)) continue;
            if (recalculateGates) {
                ((FACS_plot)object).updateViewAndStatistics(true);
                continue;
            }
            ((FACS_plot)object).regionNamesChanged();
        }
        this.holder.repaint();
    }

    public void refreshView(FCS_data changedFile) {
        for (Component object : this.holder.getComponents()) {
            if (!(object instanceof FACS_plot)) continue;
            FACS_plot thePlot = (FACS_plot)object;
            int m = thePlot.getOverlayCount();
            for (int i = 0; i < m; ++i) {
                if (thePlot.getData(i) != changedFile) continue;
                thePlot.updateViewAndStatistics(true);
                i = m;
            }
        }
        this.holder.repaint();
    }

    public void refreshView(Compensation changedCompensation) {
        for (Component object : this.holder.getComponents()) {
            if (!(object instanceof FACS_plot)) continue;
            FACS_plot thePlot = (FACS_plot)object;
            int m = thePlot.getOverlayCount();
            for (int i = 0; i < m; ++i) {
                if (thePlot.getData(i).getCompensation() != changedCompensation) continue;
                thePlot.updateViewAndStatistics(true);
                i = m;
            }
        }
        this.holder.repaint();
    }

    public void refreshLabels(FCS_data changedFile) {
        for (Component object : this.holder.getComponents()) {
            if (!(object instanceof FACS_plot)) continue;
            FACS_plot thePlot = (FACS_plot)object;
            int m = thePlot.getOverlayCount();
            for (int i = 0; i < m; ++i) {
                if (thePlot.getData(i) != changedFile) continue;
                thePlot.updateViewAndStatistics(false);
                i = m;
            }
        }
        this.holder.repaint();
    }

    public void refreshView(colorGradient changedGradient) {
        for (Component object : this.holder.getComponents()) {
            if (!(object instanceof FACS_plot)) continue;
            int index = this.gradients.indexOf(changedGradient);
            if (index == -1) {
                return;
            }
            index += 3;
            FACS_plot thePlot = (FACS_plot)object;
            int m = thePlot.getOverlayCount();
            for (int i = 0; i < m; ++i) {
                if (thePlot.getColorType(i) != index) continue;
                thePlot.updateViewAndStatistics(true);
                i = m;
            }
        }
        this.holder.repaint();
    }

    public void changeGate(int selectedIndex) {
        for (Component object : this.holder.getComponents()) {
            FACS_plot fP;
            if (!(object instanceof FACS_plot) || !(fP = (FACS_plot)object).isSelected()) continue;
            fP.setGate(0, selectedIndex);
        }
    }

    public void changeStep(int newStep) {
        for (Component object : this.holder.getComponents()) {
            FACS_plot fP;
            if (!(object instanceof FACS_plot) || !(fP = (FACS_plot)object).isSelected()) continue;
            fP.setStepToShow(0, newStep);
        }
    }

    public boolean closeDocument() {
        if (!this.documentDataFiles.isEmpty() || this.getComponentCount() != 0) {
            String save = "Save";
            String saveas = "Save as ...";
            String dont = "Don't save";
            String cancel = "Cancel";
            Object[] options = new String[]{save, saveas, dont, cancel};
            int returnIndex = JOptionPane.showOptionDialog(null, "Do you want to save the document before closing?", "Close Document", 1, 3, null, options, save);
            if (returnIndex == -1) {
                return false;
            }
            Object returnString = options[returnIndex];
            if (((String)returnString).equals(cancel)) {
                return false;
            }
            try {
                if (((String)returnString).equals(save) && !this.save()) {
                    return false;
                }
                if (((String)returnString).equals(saveas) && !this.saveAs()) {
                    return false;
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Error when saving the file!", "File save error", 0);
                return false;
            }
        }
        this.holder.removeMouseListener(this.mL);
        this.holder.removeMouseMotionListener(this.mL);
        this.theApp.removeDocument(this);
        for (Component currentComp : this.holder.getComponents()) {
            if (!(currentComp instanceof FACS_panel)) continue;
            ((FACS_panel)currentComp).removeListeners();
            ((FACS_panel)currentComp).removeFCS_Document();
        }
        this.holder.removeAll();
        return true;
    }

    public void adjustGateMenu() {
        this.theApp.setGateMenu(this.theRaG.getGateDescription());
    }

    public void setDisplayedFontGatePercentage() {
        Integer fontSize = null;
        Integer percentage = null;
        Integer gate = null;
        for (Component currComp : this.holder.getComponents()) {
            FACS_panel currPanel;
            FACS_plot currPlot;
            if (currComp instanceof FACS_plot && (currPlot = (FACS_plot)currComp).isSelected()) {
                if (!currPlot.isHistogram()) {
                    int currStep = currPlot.getStep(0);
                    if (percentage == null) {
                        percentage = currStep;
                    } else if (percentage != currStep) {
                        percentage = -1;
                    }
                }
                int currGate = currPlot.getGateIndex(0) + 1;
                if (gate == null) {
                    gate = currGate;
                } else if (gate != currGate) {
                    gate = -1;
                }
            }
            if (!(currComp instanceof FACS_panel) || !(currPanel = (FACS_panel)currComp).isSelected()) continue;
            int currFont = Math.round(currPanel.getFontSize().floatValue());
            if (fontSize == null) {
                fontSize = currFont;
                continue;
            }
            if (fontSize == currFont) continue;
            fontSize = -1;
        }
        Integer indexForPercentage = null;
        if (percentage != null && percentage != -1) {
            int[] steps = mainFrame.step;
            for (int i = 0; i < steps.length; ++i) {
                if (percentage != steps[i]) continue;
                indexForPercentage = i;
            }
        }
        this.theApp.setDisplayedFontGatePercentage(fontSize, gate, indexForPercentage);
    }

    public void setXParameter(int newX) {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            currentPlot.setXParameter(newX);
        }
    }

    public void setYParameter(int newY) {
        Component[] comps;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            currentPlot.setYParameter(newY);
        }
    }

    public void formatPlot() {
        Component[] comps;
        FACS_plot selected = null;
        for (Component component : comps = this.holder.getComponents()) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            selected = currentPlot;
            break;
        }
        if (selected != null) {
            String[] g = new String[this.gradients.size()];
            for (int i = 0; i < g.length; ++i) {
                g[i] = this.gradients.get((int)i).description;
            }
            plotFormatDialog theDialog = new plotFormatDialog(selected, this.documentDataFiles, this.documentCompensations, g);
            theDialog.showDialog();
        }
    }

    public void exportSelectedPlots() {
        Component[] comps = this.holder.getComponents();
        ArrayList<FACS_plot> selPlots = new ArrayList<FACS_plot>();
        for (Component component : comps) {
            FACS_plot currentPlot;
            if (!(component instanceof FACS_plot) || !(currentPlot = (FACS_plot)component).isSelected()) continue;
            selPlots.add(currentPlot);
        }
        if (selPlots.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Please select plots for exporting.", "No plots selected.", 0);
            return;
        }
        exportDialog newDialog = this.docFile == null ? new exportDialog(0, null) : new exportDialog(0, this.docFile.getParentFile());
        newDialog.setVisible(true);
        if (newDialog.shallExport()) {
            ArrayList<File> theFiles = newDialog.getFileList();
            Double PNG = newDialog.getPNGOption();
            int CSV = newDialog.getCSVOption();
            boolean stats = newDialog.getStatisticsOption();
            boolean combine = newDialog.getCombineData();
            boolean svgOption = newDialog.getSVGOption();
            File theDirectory = newDialog.getPath();
            if (theDirectory.exists() && !theDirectory.isDirectory()) {
                return;
            }
            if (!theDirectory.exists()) {
                theDirectory.mkdirs();
            }
            newDialog = null;
            exportProgress expProg = new exportProgress();
            exportThread exporter = new exportThread(selPlots, PNG, theDirectory, expProg, theFiles, CSV, combine, stats, null, false, svgOption);
            expProg.setThread(exporter);
            exporter.execute();
            expProg.setVisible(true);
        }
    }

    public void exportDocument() {
        exportDialog newDialog = this.docFile == null ? new exportDialog(1, null) : new exportDialog(1, this.docFile.getParentFile());
        newDialog.setVisible(true);
        if (newDialog.shallExport()) {
            Component[] comps = this.holder.getComponents();
            ArrayList<FACS_plot> selPlots = new ArrayList<FACS_plot>();
            ArrayList<FACS_plot> allPlots = new ArrayList<FACS_plot>();
            for (Component component : comps) {
                if (!(component instanceof FACS_plot)) continue;
                FACS_plot currentPlot = (FACS_plot)component;
                allPlots.add(currentPlot);
                if (!currentPlot.isSelected()) continue;
                selPlots.add(currentPlot);
            }
            if (selPlots.isEmpty()) {
                selPlots = allPlots;
            }
            ArrayList<File> theFiles = newDialog.getFileList();
            Double PNG = newDialog.getPNGOption();
            int CSV = newDialog.getCSVOption();
            boolean stats = newDialog.getStatisticsOption();
            boolean print = newDialog.getPrintOption();
            boolean combine = newDialog.getCombineData();
            boolean svgOption = newDialog.getSVGOption();
            File theDirectory = newDialog.getPath();
            if (theDirectory.exists() && !theDirectory.isDirectory()) {
                return;
            }
            if (!theDirectory.exists()) {
                theDirectory.mkdirs();
            }
            newDialog = null;
            exportProgress expProg = new exportProgress();
            exportThread exporter = new exportThread(selPlots, PNG, theDirectory, expProg, theFiles, CSV, combine, stats, this, print, svgOption);
            expProg.setThread(exporter);
            exporter.execute();
            expProg.setVisible(true);
        }
    }

    public Cursor setCursor(Cursor newCursor) {
        Cursor oldCursor = this.holder.getCursor();
        this.documentScroller.setCursor(newCursor);
        return oldCursor;
    }

    public List<FCS_data> getDatafiles() {
        return this.documentDataFiles;
    }

    public List<Compensation> getCompensations() {
        return this.documentCompensations;
    }

    public int getColorGradientCount() {
        return this.gradients.size();
    }

    public colorGradient getColorGradient(int i) {
        return this.gradients.get(i);
    }

    public void addColorGradient(colorGradient newGrad) {
        this.gradients.add(newGrad);
    }

    public void removeColorGradient(int toRemove) {
        for (Component currC : this.holder.getComponents()) {
            if (!(currC instanceof FACS_plot)) continue;
            FACS_plot currPlot = (FACS_plot)currC;
            for (int i = 0; i < currPlot.getOverlayCount(); ++i) {
                if (currPlot.getColorType(i) - 3 != toRemove) continue;
                currPlot.setColorType(i, currPlot.getColorType(i) - 1);
            }
        }
        this.gradients.remove(toRemove);
    }

    public int[] getGradient(int i) {
        return this.gradients.get((int)i).gradient;
    }

    private class exportThread
    extends SwingWorker<ArrayList<String>, Integer> {
        private String plotLabel;
        private String fileLabel = "<as in plots>";
        private int fileProgress;
        private ArrayList<FACS_plot> plots;
        private double PNG;
        private File theDirectory;
        private exportProgress theProgress;
        private ArrayList<File> theFiles;
        private int CSV;
        private ArrayList<String> errors = new ArrayList();
        private boolean combineData = true;
        private boolean exportStats = false;
        private FACS_document toExport;
        private boolean printDocument;
        private boolean exportSVG;
        private int pageWidth;
        private int pageHeight;
        PageFormat pF;

        public exportThread(ArrayList<FACS_plot> theComponents, double PNGfactor, File thePath, exportProgress paramProgress, ArrayList<File> paramFiles, int csvOption, boolean combine, boolean statistics, FACS_document paramDoc, boolean print, boolean SVGoption) {
            this.plots = theComponents;
            this.PNG = PNGfactor;
            this.theDirectory = thePath;
            this.theProgress = paramProgress;
            this.theFiles = paramFiles;
            this.CSV = csvOption;
            this.combineData = combine;
            this.exportStats = statistics;
            this.toExport = paramDoc;
            this.printDocument = print;
            if (this.toExport != null) {
                this.pF = this.toExport.getPageFormat(0);
                this.pageWidth = (int)(this.pF.getWidth() * this.PNG);
                this.pageHeight = (int)(this.pF.getHeight() * this.PNG);
            }
            this.exportSVG = SVGoption;
        }

        private void exportSVG(FACS_plot currentPlot, String fileName) {
            if (this.isCancelled()) {
                return;
            }
            try {
                File out = new File(this.theDirectory, fileName + ".svg");
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document XML_doc = dBuilder.newDocument();
                XML_doc.setXmlStandalone(true);
                XML_doc.appendChild(XML_doc.createComment("SVG created by FCSalyzer."));
                Node rootNode = SVG_Exporter.addSVG(XML_doc, currentPlot.getWidth(), currentPlot.getHeight());
                XML_doc.appendChild(rootNode);
                SVG_Exporter svg = new SVG_Exporter(rootNode);
                currentPlot.setPaintingForExport(true);
                currentPlot.paint(svg);
                currentPlot.setPaintingForExport(false);
                svg.dispose();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
                transformer.setOutputProperty("standalone", "yes");
                DOMSource source = new DOMSource(XML_doc);
                FileOutputStream outStream = new FileOutputStream(out);
                transformer.transform(source, new StreamResult(outStream));
                outStream.close();
            }
            catch (Exception e) {
                this.errors.add("Couldn't create '" + fileName + ".svg'.");
            }
        }

        private void exportSVG(String fileName) {
            if (this.isCancelled()) {
                return;
            }
            try {
                File out = new File(this.theDirectory, fileName + ".svg");
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document XML_doc = dBuilder.newDocument();
                XML_doc.setXmlStandalone(true);
                XML_doc.appendChild(XML_doc.createComment("SVG created by FCSalyzer."));
                Node rootNode = SVG_Exporter.addSVG(XML_doc, this.toExport.holder.getWidth(), this.toExport.holder.getHeight());
                XML_doc.appendChild(rootNode);
                SVG_Exporter svg = new SVG_Exporter(rootNode);
                Component[] theComps = this.toExport.holder.getComponents();
                for (int i = theComps.length - 1; i > -1; --i) {
                    Component comp = theComps[i];
                    if (comp instanceof FACS_plot) {
                        FACS_plot current = (FACS_plot)comp;
                        svg.newSVG(current.getX(), current.getY(), current.getWidth(), current.getHeight());
                        current.setPaintingForExport(true);
                        current.paint(svg);
                        current.setPaintingForExport(false);
                        svg.returnToParentNode();
                    }
                    if (comp instanceof FACS_statistics) {
                        FACS_statistics stat = (FACS_statistics)comp;
                        String stats = stat.getHTML();
                        float fontSize = stat.getFontSize().floatValue();
                        int width = stat.getWidth();
                        int height = stat.getHeight();
                        stats = stats.substring(6, stats.length() - 7);
                        String[] subs = stats.split("<br>");
                        ArrayList<Object> parts = new ArrayList<Object>();
                        int totalRows = 0;
                        for (int part = 0; part < subs.length; ++part) {
                            if (subs[part].startsWith("<table")) {
                                String[] rows = subs[part].split("<tr");
                                rows[1] = rows[1].substring(21, rows[1].length() - 10);
                                for (int row = 2; row < rows.length - 1; ++row) {
                                    rows[row] = rows[row].substring(35, rows[row].length() - 10);
                                }
                                rows[rows.length - 1] = rows[rows.length - 1].substring(35, rows[rows.length - 1].length() - 18);
                                String[][] table = new String[rows.length - 1][];
                                String[] header = rows[1].split("</th><th bgcolor=\"white\">");
                                table[0] = header;
                                for (int row = 2; row < rows.length; ++row) {
                                    table[row - 1] = rows[row].split("</td><td bgcolor=\"white\">");
                                }
                                parts.add(table);
                                totalRows = totalRows + table.length + 1;
                                continue;
                            }
                            parts.add(subs[part]);
                            ++totalRows;
                        }
                        float rowSize = (float)height / (float)totalRows;
                        Node statSVG = SVG_Exporter.addSVG(rootNode, stat.getX(), stat.getY(), width, height);
                        float currentY = 0.0f;
                        for (int part = 0; part < parts.size(); ++part) {
                            Object currentObject = parts.get(part);
                            if (currentObject instanceof String) {
                                String currentString = (String)currentObject;
                                SVG_Exporter.addText(statSVG, 0.0f, currentY += rowSize, fontSize, true, currentString);
                                continue;
                            }
                            String[][] table = (String[][])currentObject;
                            float tableWidth = width;
                            float tableHeight = (float)table.length * rowSize;
                            SVG_Exporter.addTable(statSVG, 0.0f, currentY += 3.0f, tableWidth, tableHeight, table, fontSize);
                            currentY += tableHeight;
                        }
                    }
                    if (comp instanceof FACS_comment) {
                        FACS_comment comm = (FACS_comment)comp;
                        Rectangle textArea = comm.getTextAreaBounds();
                        textArea.x = comm.getX() + textArea.x;
                        textArea.y = comm.getY() + textArea.y;
                        svg.newSVG(textArea.x, textArea.y, textArea.width, textArea.height);
                        String[] theText = comm.getTextLines();
                        float rowHeight = (float)textArea.height / (float)theText.length;
                        svg.setFont(comm.getFont());
                        float yAdjust = (rowHeight - comm.getFontSize().floatValue()) / 2.0f;
                        for (int j = 0; j < theText.length; ++j) {
                            svg.drawString(theText[j], 0.0f, rowHeight * (float)(j + 1) - yAdjust);
                        }
                        svg.returnToParentNode();
                    }
                    if (!(comp instanceof FACS_annotation)) continue;
                    FACS_annotation anno = (FACS_annotation)comp;
                    Object[][] theText = anno.getAnnotations();
                    Rectangle textArea = anno.getTextAreaBounds();
                    textArea.x = anno.getX() + textArea.x;
                    textArea.y = anno.getY() + textArea.y;
                    float rowHeight = (float)textArea.height / (float)theText.length;
                    float yAdjust = (rowHeight - anno.getFontSize().floatValue()) / 2.0f;
                    svg.newSVG(textArea.x, textArea.y, textArea.width, textArea.height);
                    svg.setFont(anno.getFont());
                    for (int j = 0; j < theText.length; ++j) {
                        int imageWidth = 0;
                        Float imagePos = null;
                        if (theText[j][0] != null && theText[j][0] instanceof BufferedImage) {
                            BufferedImage currentIm = (BufferedImage)theText[j][0];
                            svg.drawImage((Image)currentIm, 2, (int)(2.0f + (float)j * rowHeight), FACS_document.this.holder);
                            imageWidth = currentIm.getWidth();
                            imagePos = Float.valueOf((float)currentIm.getHeight() + (2.0f + (float)j * rowHeight));
                        }
                        if (theText[j][1] == null || !(theText[j][1] instanceof String)) continue;
                        String currentSt = (String)theText[j][1];
                        float pos = (float)(j + 1) * rowHeight - yAdjust;
                        if (imagePos != null) {
                            pos = imagePos.floatValue();
                        }
                        svg.drawString(currentSt, (float)(2 + imageWidth), pos);
                    }
                    svg.returnToParentNode();
                }
                svg.dispose();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
                transformer.setOutputProperty("standalone", "yes");
                DOMSource source = new DOMSource(XML_doc);
                FileOutputStream outStream = new FileOutputStream(out);
                transformer.transform(source, new StreamResult(outStream));
                outStream.close();
            }
            catch (Exception e) {
                this.errors.add("Couldn't create '" + fileName + ".svg'.");
            }
        }

        private void exportPNG(FACS_plot currentPlot, String fileName) {
            if (this.isCancelled()) {
                return;
            }
            int plotWidth = (int)((double)currentPlot.getWidth() * this.PNG);
            int plotHeight = (int)((double)currentPlot.getHeight() * this.PNG);
            File out = new File(this.theDirectory, fileName + ".png");
            ImageExporter ex = null;
            try {
                ex = new ImageExporter(out, plotWidth, plotHeight, 1);
            }
            catch (IOException io) {
                this.errors.add("Couldn't create '" + fileName + ".png'.");
                return;
            }
            currentPlot.setPaintingForExport(true);
            int slicesHeight = 200;
            int[] slices = new int[plotHeight / slicesHeight + 1];
            for (int i = 0; i < slices.length - 1; ++i) {
                slices[i] = slicesHeight;
            }
            slices[slices.length - 1] = plotHeight % 200;
            int progressBarStep = 10000 / slices.length;
            try {
                for (int i = 0; i < slices.length; ++i) {
                    if (this.isCancelled() || slices[i] <= 0) continue;
                    BufferedImage bI = new BufferedImage(plotWidth, slices[i], 1);
                    Graphics2D g = (Graphics2D)bI.getGraphics();
                    g.translate(0, -i * slicesHeight);
                    g.scale(this.PNG, this.PNG);
                    currentPlot.paint(g);
                    g.dispose();
                    ex.write(bI);
                    this.publish(progressBarStep * (i + 1));
                }
            }
            catch (IOException io) {
                // empty catch block
            }
            ex.close();
            currentPlot.setPaintingForExport(false);
        }

        private void exportPNG(String fileName) {
            if (this.isCancelled()) {
                return;
            }
            int m = this.toExport.getNumberOfPages();
            for (int page = 0; page < m; ++page) {
                if (this.isCancelled()) continue;
                this.plotLabel = "Page (" + page + "/" + m + "): " + fileName + " (PNG)";
                File out = new File(this.theDirectory, fileName + "_page " + (page + 1) + ".png");
                ImageExporter ex = null;
                try {
                    ex = new ImageExporter(out, this.pageWidth, this.pageHeight, 1);
                }
                catch (IOException io) {
                    this.errors.add("Couldn't create '" + fileName + ".png'.");
                    return;
                }
                int slicesHeight = 200;
                int[] slices = new int[this.pageHeight / slicesHeight + 1];
                for (int i = 0; i < slices.length - 1; ++i) {
                    slices[i] = slicesHeight;
                }
                slices[slices.length - 1] = this.pageHeight % 200;
                int progressBarStep = 10000 / slices.length;
                try {
                    for (int i = 0; i < slices.length; ++i) {
                        if (this.isCancelled() || slices[i] <= 0) continue;
                        BufferedImage bI = new BufferedImage(this.pageWidth, 200, 1);
                        Graphics2D g = (Graphics2D)bI.getGraphics();
                        g.translate(0, -i * slicesHeight);
                        g.scale(this.PNG, this.PNG);
                        try {
                            this.toExport.print(g, this.pF, page);
                        }
                        catch (PrinterException pE) {
                            // empty catch block
                        }
                        g.dispose();
                        ex.write(bI);
                        this.publish(progressBarStep * (i + 1));
                    }
                }
                catch (IOException io) {
                    // empty catch block
                }
                ex.close();
            }
        }

        private void exportData(FACS_plot currentPlot, String fileName, boolean rawData, BufferedWriter combinedData) {
            if (this.isCancelled()) {
                return;
            }
            for (int i = 0; i < currentPlot.getOverlayCount(); ++i) {
                if (this.isCancelled()) continue;
                try {
                    if (combinedData == null) {
                        File out = new File(this.theDirectory, fileName + "_overlay_" + (i + 1) + ".csv");
                        FileOutputStream out1 = new FileOutputStream(out);
                        OutputStreamWriter out2 = new OutputStreamWriter((OutputStream)out1, "UTF-8");
                        BufferedWriter outWriter = new BufferedWriter(out2);
                        currentPlot.writeEvents(i, outWriter, rawData);
                        outWriter.close();
                        continue;
                    }
                    combinedData.write(fileName + "_overlay_" + (i + 1));
                    combinedData.write("\n");
                    currentPlot.writeEvents(i, combinedData, rawData);
                    combinedData.write("\n\n");
                    continue;
                }
                catch (IOException io) {
                    this.errors.add("Couldn't create '" + fileName + "_overlay_" + (i + 1) + ".csv' for data output.");
                }
            }
        }

        private void exportStatistics(FACS_plot currentPlot, String fileName, BufferedWriter combinedStats) {
            if (this.isCancelled()) {
                return;
            }
            ArrayList<FACS_statistics> theStats = new ArrayList<FACS_statistics>();
            for (FACS_panel fACS_panel : currentPlot.getChildren()) {
                if (!(fACS_panel instanceof FACS_statistics)) continue;
                theStats.add((FACS_statistics)fACS_panel);
            }
            for (int i = 0; i < theStats.size(); ++i) {
                if (this.isCancelled()) continue;
                try {
                    if (combinedStats == null) {
                        File file = new File(this.theDirectory, fileName + "_statistics_" + (i + 1) + ".txt");
                        FileOutputStream out1 = new FileOutputStream(file);
                        OutputStreamWriter out2 = new OutputStreamWriter((OutputStream)out1, "UTF-8");
                        BufferedWriter outWriter = new BufferedWriter(out2);
                        outWriter.write(((FACS_statistics)theStats.get(i)).toString());
                        outWriter.close();
                        continue;
                    }
                    combinedStats.write(fileName + "_statistics_" + (i + 1));
                    combinedStats.write("\n");
                    combinedStats.write(((FACS_statistics)theStats.get(i)).toString());
                    combinedStats.write("\n\n");
                    continue;
                }
                catch (IOException iOException) {
                    this.errors.add("Couldn't create '" + fileName + "_statistics_" + (i + 1) + ".txt' for data output.");
                }
            }
        }

        @Override
        protected ArrayList<String> doInBackground() throws Exception {
            OutputStreamWriter out2;
            FileOutputStream out1;
            BufferedWriter combinedData = null;
            BufferedWriter combinedStats = null;
            if (this.combineData && this.CSV != 0) {
                File exportData = new File(this.theDirectory, FACS_document.this.getName() + "_export.csv");
                try {
                    out1 = new FileOutputStream(exportData);
                    out2 = new OutputStreamWriter((OutputStream)out1, "UTF-8");
                    combinedData = new BufferedWriter(out2);
                }
                catch (IOException io) {
                    this.errors.add("Couldn't create file for combined data output. Switched to single files.");
                }
            }
            if (this.combineData && this.exportStats) {
                File exportStat = new File(this.theDirectory, FACS_document.this.getName() + "_statistics.txt");
                try {
                    out1 = new FileOutputStream(exportStat);
                    out2 = new OutputStreamWriter((OutputStream)out1, "UTF-8");
                    combinedStats = new BufferedWriter(out2);
                }
                catch (IOException io) {
                    this.errors.add("Couldn't create file for combined statistics output. Switched to single files.");
                }
            }
            PrinterJob printJob = null;
            if (!this.isCancelled() && this.printDocument && this.toExport != null && (printJob = PrinterJob.getPrinterJob()) != null) {
                printJob.setPageable(this.toExport);
                printJob.setJobName(this.toExport.getName() + " - FCSalyzer");
                boolean doPrint = printJob.printDialog();
                if (!doPrint) {
                    printJob = null;
                }
            }
            if (this.theFiles.isEmpty()) {
                if (!this.isCancelled() && this.PNG != exportDialog.factorNo && this.toExport != null) {
                    this.exportPNG(FACS_document.this.name);
                }
                if (!this.isCancelled() && this.exportSVG && this.toExport != null) {
                    this.exportSVG(FACS_document.this.name);
                }
                if (!this.isCancelled() && printJob != null) {
                    try {
                        printJob.print();
                    }
                    catch (PrinterException e) {
                        this.errors.add("Document could not be printed!");
                    }
                }
                for (int i = 0; i < this.plots.size(); ++i) {
                    FACS_plot currentPlot = this.plots.get(i);
                    String name = FACS_document.this.getName() + "_plot_" + i;
                    if (!this.isCancelled() && this.exportSVG && this.toExport == null) {
                        this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (PNG)";
                        this.exportSVG(currentPlot, name);
                    }
                    if (!this.isCancelled() && this.PNG != exportDialog.factorNo && this.toExport == null) {
                        this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (PNG)";
                        this.exportPNG(currentPlot, name);
                    }
                    if (!this.isCancelled() && this.CSV != 0) {
                        this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (CSV)";
                        this.publish(0);
                        this.exportData(currentPlot, name, this.CSV == 2, combinedData);
                    }
                    if (this.isCancelled() || !this.exportStats) continue;
                    this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (CSV)";
                    this.publish(0);
                    this.exportStatistics(currentPlot, name, combinedStats);
                }
            } else {
                ArrayList<FCS_data> originalFCS = new ArrayList<FCS_data>();
                for (int i = 0; i < this.plots.size(); ++i) {
                    originalFCS.add(this.plots.get(i).getData(0));
                }
                int fileProgressStep = 10000 / this.theFiles.size();
                for (File currentF : this.theFiles) {
                    if (this.isCancelled()) continue;
                    if (currentF.exists()) {
                        FCS_data currentFCS = null;
                        try {
                            currentFCS = FCS_data.openFCS_data(currentF, null, null, false);
                        }
                        catch (IOException io) {
                        }
                        catch (DataFormatException df) {
                            // empty catch block
                        }
                        if (currentFCS != null) {
                            this.fileLabel = currentFCS.getDataFileName();
                            for (int i = 0; i < this.plots.size(); ++i) {
                                FACS_plot currentPlot = this.plots.get(i);
                                int maxParam = currentFCS.getRawParameterCount();
                                int paramX = currentPlot.getParamX(0);
                                int paramY = currentPlot.getParamY(0);
                                if (paramX >= maxParam || paramY >= maxParam) {
                                    this.errors.add("FCS file " + currentFCS.getDataFileName() + " does not have enough parameters for plot#" + i + ".");
                                    continue;
                                }
                                String name = FACS_document.this.getName() + "_plot_" + i + "_" + currentFCS.getDataFileName();
                                FCS_data plotData = (FCS_data)originalFCS.get(i);
                                if (!currentFCS.setCompensation(plotData.getCompensation())) {
                                    this.errors.add("Compensation could not be set for plot#" + i + "/FCS file " + currentFCS.getDataFileName() + ".");
                                }
                                if (plotData.getRawParameterCount() < maxParam) {
                                    maxParam = plotData.getRawParameterCount();
                                }
                                for (int j = 0; j < maxParam; ++j) {
                                    currentFCS.setParameterTransformationByValue(j, plotData.getParameterTransformationValue(j));
                                }
                                this.plots.get(i).setData(0, currentFCS);
                                if (!this.isCancelled() && this.exportSVG && this.toExport == null) {
                                    this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (SVG)";
                                    this.publish(0);
                                    this.exportSVG(currentPlot, name);
                                }
                                if (!this.isCancelled() && this.PNG != exportDialog.factorNo && this.toExport == null) {
                                    this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (PNG)";
                                    this.exportPNG(currentPlot, name);
                                }
                                if (!this.isCancelled() && this.CSV != 0) {
                                    this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (CSV)";
                                    this.publish(0);
                                    this.exportData(currentPlot, name, this.CSV == 2, combinedData);
                                }
                                if (this.isCancelled() || !this.exportStats) continue;
                                this.plotLabel = "(" + i + "/" + this.plots.size() + "): " + name + " (stats)";
                                this.publish(0);
                                this.exportStatistics(currentPlot, name, combinedStats);
                            }
                            if (!this.isCancelled() && this.PNG != exportDialog.factorNo && this.toExport != null) {
                                this.exportPNG(FACS_document.this.name + "_" + currentFCS.getDataFileName());
                            }
                            if (!this.isCancelled() && this.exportSVG && this.toExport != null) {
                                this.exportSVG(FACS_document.this.name + "_" + currentFCS.getDataFileName());
                                this.publish(0);
                            }
                            if (!this.isCancelled() && printJob != null) {
                                try {
                                    printJob.print();
                                }
                                catch (PrinterException e) {
                                    this.errors.add(currentFCS.getDataFileName() + " Document could not be printed!");
                                }
                            }
                        } else {
                            this.errors.add("'" + currentF.getName() + "' could not be opened as an FCS file.");
                        }
                    }
                    this.fileProgress += fileProgressStep;
                }
                for (int i = 0; i < this.plots.size(); ++i) {
                    this.plots.get(i).setData(0, (FCS_data)originalFCS.get(i));
                }
            }
            if (combinedData != null) {
                combinedData.close();
            }
            if (combinedStats != null) {
                combinedStats.close();
            }
            return this.errors;
        }

        @Override
        protected void done() {
            super.done();
            this.theProgress.setVisible(false);
            if (!this.isCancelled()) {
                ArrayList results = new ArrayList();
                try {
                    results = (ArrayList)this.get();
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException ex) {
                    // empty catch block
                }
                if (!results.isEmpty()) {
                    if (results.size() > 30) {
                        Object[] newRes = Arrays.copyOf(results.toArray(), 30);
                        newRes[29] = "... and " + (results.size() - 29) + " more";
                        JOptionPane.showMessageDialog(FACS_document.this.documentScroller, newRes, "Export errors", 0);
                    } else {
                        JOptionPane.showMessageDialog(FACS_document.this.documentScroller, results.toArray(), "Export errors", 0);
                    }
                }
            }
        }

        @Override
        protected void process(List<Integer> chunks) {
            Collections.sort(chunks);
            this.theProgress.setPlotValue(chunks.get(chunks.size() - 1));
            this.theProgress.setPlotText(this.plotLabel);
            this.theProgress.setFileValue(this.fileProgress);
            this.theProgress.setFileText(this.fileLabel);
        }
    }

    private class exportProgress
    extends JDialog
    implements WindowListener,
    ActionListener {
        private JProgressBar plotProgress;
        private JProgressBar fileProgress;
        private SwingWorker theThread;
        public static final int maxValues = 10000;

        public exportProgress() {
            this.setDefaultCloseOperation(0);
            this.setTitle("Exporting ...");
            this.setSize(400, 150);
            this.setLayout(new GridLayout(3, 1, 0, 0));
            this.fileProgress = new JProgressBar();
            Border b1 = this.fileProgress.getBorder();
            Border empty1 = BorderFactory.createEmptyBorder(5, 20, 5, 20);
            this.fileProgress.setBorder(BorderFactory.createCompoundBorder(empty1, b1));
            this.fileProgress.setMaximum(10000);
            this.fileProgress.setString("");
            this.fileProgress.setStringPainted(true);
            this.add(this.fileProgress);
            this.plotProgress = new JProgressBar();
            Border b = this.plotProgress.getBorder();
            Border empty = BorderFactory.createEmptyBorder(5, 20, 5, 20);
            this.plotProgress.setBorder(BorderFactory.createCompoundBorder(empty, b));
            this.plotProgress.setMaximum(10000);
            this.plotProgress.setBorderPainted(true);
            this.plotProgress.setString("");
            this.plotProgress.setStringPainted(true);
            this.add(this.plotProgress);
            JPanel buttonPanel = new JPanel();
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(this);
            buttonPanel.add(cancelButton);
            this.add(buttonPanel);
            this.setLocationRelativeTo(null);
            this.setModal(true);
            this.addWindowListener(this);
        }

        private void setThread(SwingWorker paramThread) {
            this.theThread = paramThread;
        }

        private void cancel() {
            this.theThread.cancel(false);
            this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancel();
        }

        @Override
        public void setVisible(boolean vis) {
            super.setVisible(vis);
            if (!vis) {
                this.dispose();
            }
        }

        public void setPlotValue(int plot) {
            this.plotProgress.setValue(plot);
        }

        public void setPlotText(String plot) {
            this.plotProgress.setString(plot);
        }

        public void setFileValue(int text) {
            this.fileProgress.setValue(text);
        }

        public void setFileText(String text) {
            this.fileProgress.setString(text);
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.cancel();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    public class attachedDataHolder {
        int indexDataFile;
        int indexAttachedData;
        FCS_datafile data;

        public attachedDataHolder(int datIndex, int attachedIndex, FCS_datafile fcsData) {
            this.indexDataFile = datIndex;
            this.indexAttachedData = attachedIndex;
            this.data = fcsData;
        }

        public FCS_datafile getData() {
            return this.data;
        }

        public boolean indicesCorrect(int indexDat, int indexAtt) {
            if (indexDat != this.indexDataFile) {
                return false;
            }
            return indexAtt == this.indexAttachedData;
        }
    }
}

