/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS.rawData;

import FCSalyzer.FCS.rawData.FCS_parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;

public class FCS_data_metainfo {
    protected ArrayList<String> KeywordsDescription = new ArrayList();
    protected static HashMap<String, String> keywordsDescriptionsSet;
    protected ArrayList<String> KeywordsTEXT = new ArrayList();
    protected ArrayList<String> ValuesTEXT = new ArrayList();
    protected ArrayList<String> KeywordsANALYSIS = new ArrayList();
    protected ArrayList<String> ValuesANALYSIS = new ArrayList();
    protected FCS_parameter[] parameters = null;
    protected String[] parameterLabels = null;
    protected MappedByteBuffer bytes = null;
    protected String FileName = null;
    protected String FilePath = null;
    protected int eventCount;
    protected String version;
    protected long fileSize;
    protected int startDATA;
    protected int byteCount;
    protected int byteCountParameter;
    protected boolean sameByteCountForParams;
    protected int[] byteOrder;
    private final String TopDownOrder = "4321";
    private final String BottomUpOrder = "1234";
    private final String mixedOrder = "mix";
    private String byteOrderType = "4321";
    protected boolean isFloat = false;
    protected int[][] spilloverValues = null;
    protected boolean isMQD = false;

    protected FCS_data_metainfo() {
    }

    protected FCS_data_metainfo(File toOpen) throws IOException, DataFormatException, IllegalFormatException {
        if (toOpen == null) {
            throw new DataFormatException();
        }
        if (!toOpen.isFile()) {
            throw new DataFormatException();
        }
        this.FileName = toOpen.getName();
        this.FilePath = toOpen.getParent();
        FileInputStream inStream = new FileInputStream(toOpen);
        FileChannel theChannel = inStream.getChannel();
        this.fileSize = theChannel.size();
        if (this.fileSize < 58L) {
            theChannel.close();
            inStream.close();
            throw new DataFormatException();
        }
        this.bytes = theChannel.map(FileChannel.MapMode.READ_ONLY, 0L, theChannel.size());
        theChannel.close();
        inStream.close();
        int toGet = 100;
        if (this.fileSize < (long)toGet) {
            toGet = (int)this.fileSize;
        }
        byte[] temp = new byte[toGet];
        this.bytes.get(temp);
        String HEADER = new String(temp, 0, 10).trim();
        if (HEADER.toLowerCase().startsWith("fcs") || HEADER.toLowerCase().startsWith("mqd")) {
            this.KeywordsTEXT.add("Local Filename");
            this.ValuesTEXT.add(toOpen.getName());
            this.KeywordsTEXT.add("Local Path");
            this.ValuesTEXT.add(toOpen.getParent());
            this.version = HEADER;
            this.KeywordsTEXT.add("FCS Version");
            this.ValuesTEXT.add(this.version);
            int startTEXT = this.decodeBytes(temp, 10, 8);
            int endTEXT = this.decodeBytes(temp, 18, 8);
            this.startDATA = this.decodeBytes(temp, 26, 8);
            int startANALYSIS = this.decodeBytes(temp, 42, 8);
            int endANALYSIS = this.decodeBytes(temp, 50, 8);
            if (HEADER.toLowerCase().startsWith("mqd")) {
                this.isMQD = true;
                String mqdHEADER = new String(temp);
                String[] mqdSEGMENTS = mqdHEADER.split(" ");
                try {
                    startTEXT = Integer.parseInt(mqdSEGMENTS[4].trim());
                }
                catch (NumberFormatException n) {
                    startTEXT = 0;
                }
                try {
                    endTEXT = Integer.parseInt(mqdSEGMENTS[5].trim());
                }
                catch (NumberFormatException n) {
                    endTEXT = 0;
                }
                try {
                    this.startDATA = Integer.parseInt(mqdSEGMENTS[6].trim());
                }
                catch (NumberFormatException n) {
                    this.startDATA = 0;
                }
                try {
                    startANALYSIS = Integer.parseInt(mqdSEGMENTS[8].trim());
                }
                catch (NumberFormatException n) {
                    startANALYSIS = 0;
                }
                try {
                    endANALYSIS = Integer.parseInt(mqdSEGMENTS[9].trim());
                }
                catch (NumberFormatException n) {
                    endANALYSIS = 0;
                }
            }
            try {
                this.analyseTEXT_ANALYSIS(this.bytes, startTEXT, endTEXT, this.KeywordsTEXT, this.ValuesTEXT);
                this.analyseDATA(this.startDATA, this.fileSize);
                this.analyseTEXT_ANALYSIS(this.bytes, startANALYSIS, endANALYSIS, this.KeywordsANALYSIS, this.ValuesANALYSIS);
                this.generateKeywordsDescription();
            }
            catch (Exception e) {
                throw new DataFormatException();
            }
            if (this.startDATA == 0) {
                String start = this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$BEGINDATA"));
                try {
                    this.startDATA = Integer.parseInt(start);
                }
                catch (NumberFormatException in) {
                    this.startDATA = 0;
                }
                if (this.startDATA == 0) {
                    this.startDATA = endTEXT + 1;
                }
            }
        } else {
            throw new DataFormatException();
        }
        String spillover = this.getValueTEXT("$SPILLOVER");
        if (spillover.isEmpty()) {
            spillover = this.getValueTEXT("SPILL");
        }
        if (!spillover.isEmpty()) {
            String[] spill = spillover.split(",");
            int count = 0;
            try {
                count = Integer.parseInt(spill[0]);
            }
            catch (NumberFormatException n) {
                count = 0;
            }
            if (count > 0) {
                String[] params = new String[count];
                String[][] paramSpills = new String[count][count];
                for (int i = 0; i < count; ++i) {
                    params[i] = spill[i + 1];
                    for (int j = 0; j < count; ++j) {
                        int index = 1 + count + i * count + j;
                        paramSpills[i][j] = spill[index];
                    }
                }
                int[] paramIndex = new int[count];
                ArrayList<String> thePxN = new ArrayList<String>();
                int paramCount = this.parameters.length;
                for (int i = 0; i < paramCount; ++i) {
                    thePxN.add(this.getParameterName(i));
                }
                boolean paramNotIdentified = false;
                for (int i = 0; i < count; ++i) {
                    paramIndex[i] = thePxN.indexOf(params[i]);
                    if (paramIndex[i] != -1) continue;
                    try {
                        paramIndex[i] = Integer.valueOf(params[i]);
                        continue;
                    }
                    catch (NumberFormatException n) {
                        paramNotIdentified = true;
                    }
                }
                if (!paramNotIdentified) {
                    int[][] newComp = new int[paramCount][paramCount];
                    for (int i = 0; i < count; ++i) {
                        for (int j = 0; j < count; ++j) {
                            String currentValue = paramSpills[i][j];
                            int comp = 0;
                            try {
                                Float currV = Float.valueOf(Float.parseFloat(currentValue));
                                currV = Float.valueOf(currV.floatValue() * 10000.0f);
                                comp = Math.round(currV.floatValue());
                            }
                            catch (NumberFormatException n) {
                                comp = 0;
                            }
                            if (i == j) continue;
                            newComp[paramIndex[j]][paramIndex[i]] = comp;
                        }
                    }
                    boolean largerThanZero = false;
                    for (int i = 0; i < newComp.length; ++i) {
                        for (int j = 0; j < newComp[0].length; ++j) {
                            if (largerThanZero) continue;
                            largerThanZero = newComp[i][j] > 0;
                        }
                    }
                    if (largerThanZero) {
                        this.spilloverValues = newComp;
                    }
                }
            }
        }
        this.sameByteCountForParams = true;
        for (int i = 0; i < this.parameters.length - 1; ++i) {
            if (this.parameters[i].getBytesForBits() == this.parameters[i + 1].getBytesForBits()) continue;
            this.sameByteCountForParams = false;
        }
        if (this.sameByteCountForParams) {
            this.byteCountParameter = this.parameters[0].getBytesForBits();
        }
    }

    public static FCS_data_metainfo getDummyData(String name, String path, int params) {
        FCS_data_metainfo toReturn = new FCS_data_metainfo();
        toReturn.FileName = "Not found: " + name;
        toReturn.FilePath = path;
        toReturn.eventCount = 0;
        toReturn.parameters = new FCS_parameter[params];
        toReturn.parameterLabels = new String[params];
        for (int i = 0; i < params; ++i) {
            toReturn.parameterLabels[i] = "Parameter " + i;
            FCS_parameter newParam = null;
            try {
                newParam = new FCS_parameter(false, "16", "1024", "P" + i, "Parameter " + i, "0", "0", "0", "0", "0", "0", "0", null, null, null, null);
            }
            catch (DataFormatException ex) {
                // empty catch block
            }
            toReturn.parameters[i] = newParam;
        }
        return toReturn;
    }

    protected int decodeBytes(byte[] toDecode, int offset, int len) {
        int result;
        try {
            result = Integer.parseInt(new String(toDecode, offset, len).trim());
        }
        catch (NumberFormatException n) {
            result = 0;
        }
        return result;
    }

    protected boolean analyseTEXT_ANALYSIS(ByteBuffer bytes, int startSEGMENT, int endSEGMENT, ArrayList keywords, ArrayList values) {
        if (startSEGMENT == 0 || endSEGMENT == 0) {
            return false;
        }
        Charset theCharSet = Charset.defaultCharset();
        try {
            theCharSet = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        byte separator = bytes.get(startSEGMENT);
        bytes.position(startSEGMENT + 1);
        char sepChar = (char)separator;
        byte[] theBytes = new byte[endSEGMENT - startSEGMENT - 1];
        bytes.get(theBytes);
        String temp = new String(theBytes, theCharSet);
        String[] singlePart = temp.split(Pattern.quote(String.valueOf(sepChar)));
        int i = 0;
        do {
            String key = "";
            do {
                String tempString;
                if ((tempString = singlePart[i]).isEmpty()) {
                    tempString = sepChar + singlePart[++i];
                }
                key = key + tempString;
            } while (++i < singlePart.length && singlePart[i].isEmpty());
            String value = "";
            if (i < singlePart.length) {
                do {
                    String tempString;
                    if ((tempString = singlePart[i]).isEmpty()) {
                        tempString = sepChar + singlePart[++i];
                    }
                    value = value + tempString;
                } while (++i < singlePart.length && singlePart[i].isEmpty());
            }
            keywords.add(key.trim());
            values.add(value.trim());
        } while (i < singlePart.length);
        return true;
    }

    protected void analyseDATA(int startDATA, long fileSize) throws DataFormatException {
        int i;
        if (!this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$DATATYPE")).equals("F") && !this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$DATATYPE")).equals("I")) {
            throw new DataFormatException("Datafile Format not supported!");
        }
        if (this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$DATATYPE")).equals("F")) {
            this.isFloat = true;
        }
        if (!this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$MODE")).equals("L")) {
            throw new DataFormatException("Datafile Format not supported!");
        }
        int paramCount = Byte.parseByte(this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$PAR")));
        this.parameters = new FCS_parameter[paramCount];
        this.parameterLabels = new String[paramCount];
        for (int i2 = 0; i2 < paramCount; ++i2) {
            String prefix = "$P" + (i2 + 1);
            String paramBits = null;
            String paramRange = null;
            String paramName = null;
            String paramDesc = null;
            String paramFilter = null;
            String paramLaser = null;
            String paramVoltage = null;
            String paramExc = null;
            String paramCollected = null;
            String paramDetector = null;
            String paramDecadesOffset = null;
            String prefix2 = "P" + (i2 + 1);
            String paramDisplay = null;
            String paramPnD = null;
            String paramBS = null;
            String paramMS = null;
            int index = this.KeywordsTEXT.indexOf(prefix + "B");
            if (index != -1) {
                paramBits = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "R")) != -1) {
                paramRange = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "N")) != -1) {
                paramName = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "S")) != -1) {
                paramDesc = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "F")) != -1) {
                paramFilter = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "L")) != -1) {
                paramLaser = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "V")) != -1) {
                paramVoltage = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "O")) != -1) {
                paramExc = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "P")) != -1) {
                paramCollected = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "T")) != -1) {
                paramDetector = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "E")) != -1) {
                paramDecadesOffset = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix + "D")) != -1) {
                paramPnD = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix2 + "DISPLAY")) != -1) {
                paramDisplay = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix2 + "BS")) != -1) {
                paramBS = this.ValuesTEXT.get(index);
            }
            if ((index = this.KeywordsTEXT.indexOf(prefix2 + "MS")) != -1) {
                paramMS = this.ValuesTEXT.get(index);
            }
            this.parameters[i2] = new FCS_parameter(this.isFloat, paramBits, paramRange, paramName, paramDesc, paramFilter, paramLaser, paramVoltage, paramExc, paramCollected, paramDetector, paramDecadesOffset, paramDisplay, paramPnD, paramBS, paramMS);
            if (paramDesc != null && !paramDesc.trim().isEmpty()) {
                this.parameterLabels[i2] = paramDesc;
            }
            if (this.parameterLabels[i2] != null) continue;
            this.parameterLabels[i2] = paramName;
        }
        int bitsPerEvent = 0;
        for (int i3 = 0; i3 < paramCount; ++i3) {
            bitsPerEvent += this.parameters[i3].get$PnB_bits();
        }
        this.byteCount = bitsPerEvent / 8;
        if (bitsPerEvent % 8 != 0) {
            ++this.byteCount;
        }
        String totalEvents = this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$TOT"));
        this.eventCount = -1;
        try {
            this.eventCount = Integer.parseInt(totalEvents.trim());
        }
        catch (NumberFormatException n) {
            // empty catch block
        }
        if (this.eventCount == -1) {
            this.eventCount = (int)((fileSize - (long)startDATA) * 8L / (long)bitsPerEvent);
        }
        String[] bytOrd = this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$BYTEORD")).split(",");
        this.byteOrder = new int[bytOrd.length];
        for (i = 0; i < this.byteOrder.length; i = (int)((byte)(i + 1))) {
            this.byteOrder[i] = Integer.parseInt(bytOrd[i]);
        }
        this.byteOrderType = "4321";
        for (i = 0; i < this.byteOrder.length - 1; ++i) {
            if (this.byteOrder[i] >= this.byteOrder[i + 1]) continue;
            this.byteOrderType = "mix";
        }
        if (!this.byteOrderType.equals("4321")) {
            this.byteOrderType = "1234";
            for (i = 0; i < this.byteOrder.length - 1; ++i) {
                if (this.byteOrder[i] <= this.byteOrder[i + 1]) continue;
                this.byteOrderType = "mix";
            }
        }
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public long getRange(int parameter) {
        return this.parameters[parameter].get$PnR_range();
    }

    public int getBytes(int parameter) {
        return this.parameters[parameter].getBytesForBits();
    }

    public String getFileName() {
        String returnText;
        int index = this.KeywordsTEXT.indexOf("$FIL");
        if (index > -1 && (returnText = this.ValuesTEXT.get(this.KeywordsTEXT.indexOf("$FIL"))) != null) {
            return returnText;
        }
        return this.getDataFileName();
    }

    public String getParameterName(int index) {
        return this.parameters[index].get$PnN_name();
    }

    public String getParameterDesc(int index) {
        return this.parameters[index].get$PnS_description();
    }

    public String[] getParameterLabels() {
        return this.parameterLabels;
    }

    public String getParameterLabel(int index) {
        return this.parameterLabels[index];
    }

    public float getLogDecades(int index) {
        return this.parameters[index].getDecades();
    }

    public float getOffset(int index) {
        return this.parameters[index].getOffset();
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public String getDataFileName() {
        return this.FileName;
    }

    public String getDataFilePath() {
        return this.FilePath;
    }

    public ArrayList<String> getKeywordsDescription() {
        return this.KeywordsDescription;
    }

    public ArrayList<String> getKeywordsTEXT() {
        return this.KeywordsTEXT;
    }

    public ArrayList<String> getValuesTEXT() {
        return this.ValuesTEXT;
    }

    public String getValueTEXT(int index) {
        if (index < 0 || index >= this.ValuesTEXT.size()) {
            return "";
        }
        return this.ValuesTEXT.get(index);
    }

    public String getValueTEXT(String annotationKeyword) {
        int index = this.KeywordsTEXT.indexOf(annotationKeyword);
        if (index == -1) {
            index = this.KeywordsTEXT.indexOf(annotationKeyword.toLowerCase());
        }
        if (index > -1 && index < this.KeywordsTEXT.size()) {
            return this.ValuesTEXT.get(index);
        }
        return "";
    }

    protected void generateKeywordsDescription() {
        if (keywordsDescriptionsSet == null) {
            keywordsDescriptionsSet = this.generateKeywordsDescriptionSet();
        }
        for (int i = 0; i < this.KeywordsTEXT.size(); ++i) {
            String result = keywordsDescriptionsSet.get(this.KeywordsTEXT.get(i));
            if (result != null) {
                this.KeywordsDescription.add(result);
                continue;
            }
            this.KeywordsDescription.add("");
        }
    }

    protected synchronized HashMap<String, String> generateKeywordsDescriptionSet() {
        int i;
        HashMap<String, String> returnData = new HashMap<String, String>();
        returnData.put("$DATATYPE", "Datatype");
        returnData.put("$PAR", "Parameter Count");
        returnData.put("$MODE", "Data modus");
        returnData.put("$BYTEORD", "Byte order");
        returnData.put("$NEXTDATA", "<for data analysis>");
        returnData.put("$DATE", "Date");
        returnData.put("$EXP", "Experimenter");
        returnData.put("$PROJ", "Project");
        returnData.put("$OP", "Operator");
        returnData.put("$INST", "Institution");
        returnData.put("$FIL", "File Name");
        returnData.put("$CYT", "Cytometer");
        returnData.put("$SMNO", "Sample Number");
        returnData.put("$SRC", "Sample Source");
        returnData.put("$SYS", "Computer System");
        returnData.put("$CELLS", "Cell Type");
        returnData.put("$BTIM", "Start Time");
        returnData.put("$ETIM", "End Time");
        returnData.put("$TOT", "Total Event Count");
        returnData.put("$LOST", "Lost Event Count");
        returnData.put("$ABRT", "Aborted Event Count");
        returnData.put("$TR", "Trigger Signal");
        returnData.put("$COM", "Comment");
        for (i = 1; i < 300; ++i) {
            returnData.put("$P" + i + "N", "Parameter " + i + " - Name");
            returnData.put("BD$P" + i + "N", "Parameter " + i + " - Name");
            returnData.put("$P" + i + "S", "Parameter " + i + " - Description");
            returnData.put("$P" + i + "B", "Parameter " + i + " - Bits");
            returnData.put("$P" + i + "R", "Parameter " + i + " - Range");
            returnData.put("$P" + i + "F", "Parameter " + i + " - Filter");
            returnData.put("$P" + i + "E", "Parameter " + i + " - Amplifier parameters");
            returnData.put("$P" + i + "L", "Parameter " + i + " - Laser wavelength");
            returnData.put("$P" + i + "O", "Parameter " + i + " - Laser power");
            returnData.put("$P" + i + "T", "Parameter " + i + " - Photomultiplier");
            returnData.put("$P" + i + "V", "Parameter " + i + " - Detector voltage");
            returnData.put("$P" + i + "D", "Parameter " + i + " - Preferred display");
            returnData.put("P" + i + "DISPLAY", "Parameter " + i + " - Preferred display");
            returnData.put("P" + i + "BS", "Parameter " + i + " - <unknown to FCSalyzer>");
            returnData.put("P" + i + "MS", "Parameter " + i + " - <unknown to FCSalyzer>");
            returnData.put("P" + i + "THRESVOL", "Parameter " + i + " - <unknown to FCSalyzer>");
        }
        returnData.put("$GATE", "Gate count");
        for (i = 1; i < 300; ++i) {
            returnData.put("$G" + i + "N", "Gate " + i + " - Name");
            returnData.put("$G" + i + "S", "Gate " + i + " - Description");
            returnData.put("$G" + i + "B", "Gate " + i + " - Bits");
            returnData.put("$G" + i + "R", "Gate " + i + " - Range");
            returnData.put("$G" + i + "F", "Gate " + i + " - Filter");
            returnData.put("$G" + i + "E", "Gate " + i + " - Amplifier Gates");
            returnData.put("$G" + i + "L", "Gate " + i + " - Laser wavelength");
            returnData.put("$G" + i + "O", "Gate " + i + " - Laser power");
            returnData.put("$G" + i + "T", "Gate " + i + " - Photomultiplier");
            returnData.put("$G" + i + "V", "Gate " + i + " - Detector voltage");
        }
        for (i = 1; i < 300; ++i) {
            returnData.put("$R" + i + "I", "Gating Region " + i + " - parameters");
            returnData.put("$R" + i + "W", "Gating Region " + i + " - coordinates");
        }
        returnData.put("$GATING", "Gating strategy");
        returnData.put("CREATOR", "Created on");
        returnData.put("TUBE NAME", "Tube Name");
        returnData.put("EXPERIMENT NAME", "Experiment");
        returnData.put("GUID", "Unique ID");
        returnData.put("CYTNUM", "Cytometer Number");
        returnData.put("WINDOW EXTENSION", "Window Extension");
        returnData.put("EXPORT USER NAME", "Export User Name");
        returnData.put("EXPORT TIME", "Export Time");
        returnData.put("FSC ASF", "FSC Area Scaling");
        returnData.put("AUTOBS", "");
        returnData.put("LASER1NAME", "Laser 1 - Name");
        returnData.put("LASER1DELAY", "Laser 1 - Delay");
        returnData.put("LASER1ASF", "Laser 1 - Area Scaling");
        returnData.put("LASER2NAME", "Laser 2 - Name");
        returnData.put("LASER2DELAY", "Laser 2 - Delay");
        returnData.put("LASER2ASF", "Laser 2 - Area Scaling");
        returnData.put("LASER3NAME", "Laser 3 - Name");
        returnData.put("LASER3DELAY", "Laser 3 - Delay");
        returnData.put("LASER3ASF", "Laser 3 - Area Scaling");
        returnData.put("LASER4NAME", "Laser 4 - Name");
        returnData.put("LASER4DELAY", "Laser 4 - Delay");
        returnData.put("LASER4ASF", "Laser 4 - Area Scaling");
        returnData.put("LASER5NAME", "Laser 5 - Name");
        returnData.put("LASER5DELAY", "Laser 5 - Delay");
        returnData.put("LASER5ASF", "Laser 5 - Area Scaling");
        returnData.put("LASER6NAME", "Laser 6 - Name");
        returnData.put("LASER6DELAY", "Laser 6 - Delay");
        returnData.put("LASER6ASF", "Laser 6 - Area Scaling");
        returnData.put("LASER7NAME", "Laser 7 - Name");
        returnData.put("LASER7DELAY", "Laser 7 - Delay");
        returnData.put("LASER7ASF", "Laser 7 - Area Scaling");
        returnData.put("LOGIN NAME", "Login Name");
        returnData.put("WORKSTATION", "Workstation");
        returnData.put("SAMPLE ID", "Sample ID");
        returnData.put("PANEL NAME", "Panel Name");
        returnData.put("START BATCH", "");
        returnData.put("END BATCH", "");
        returnData.put("BD$AcqLibVersion", "");
        returnData.put("FILE GUID", "File Unique ID");
        returnData.put("CREATOR", "Created on");
        returnData.put("CalibFile", "");
        returnData.put("BD$LASERMODE", "");
        returnData.put("BD$NPAR", "");
        for (i = 0; i < 300; ++i) {
            returnData.put("BD$WORD" + i + "N", "");
        }
        return returnData;
    }

    public String getSampleDescription() {
        String toReturn = this.getValueTEXT("SAMPLE ID");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("TUBE NAME");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("$SRC");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("$SMNO");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        return this.getFileName();
    }

    public boolean isFloatData() {
        return this.isFloat;
    }

    public boolean parameterIsStoredAsLog(int param) {
        if (this.isFloat) {
            return false;
        }
        return this.parameters[param].hasLogScale();
    }

    public boolean displayParamAsLog(int param) {
        return this.parameters[param].displayOnLog();
    }

    public long parameterRange(int parameter) {
        return this.parameters[parameter].get$PnR_range();
    }

    public boolean hasCompensation() {
        return this.spilloverValues != null;
    }

    public int[][] getCompensation() {
        int[][] toReturn = new int[this.spilloverValues.length][this.spilloverValues[0].length];
        for (int i = 0; i < toReturn.length; ++i) {
            for (int j = 0; j < toReturn[0].length; ++j) {
                toReturn[i][j] = this.spilloverValues[i][j];
            }
        }
        return toReturn;
    }

    public boolean isMQD() {
        return this.isMQD;
    }

    public boolean isTopDownOrder() {
        return this.byteOrderType.equals("4321");
    }

    public boolean isBottomUpOrder() {
        return this.byteOrderType.equals("1234");
    }
}

