/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.Py;
import org.python.core.PySystemState;
import org.python.core.ThreadState;

class ThreadStateMapping {
    private static boolean checkedJava2 = false;
    private static Hashtable threads;
    private static ThreadState cachedThreadState;
    private static int additionCounter;
    private static final int MAX_ADDITIONS = 25;

    ThreadStateMapping() {
    }

    public static ThreadStateMapping makeMapping() {
        if (!checkedJava2) {
            checkedJava2 = true;
            String string2 = System.getProperty("java.version");
            if (string2.compareTo("1.2") >= 0) {
                try {
                    Class<?> clazz = Class.forName("org.python.core.ThreadStateMapping2");
                    return (ThreadStateMapping)clazz.newInstance();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return new ThreadStateMapping();
    }

    public ThreadState getThreadState(PySystemState pySystemState) {
        Thread thread2 = Thread.currentThread();
        ThreadState threadState = cachedThreadState;
        if (threadState != null && threadState.thread == thread2) {
            return threadState;
        }
        if (threads == null) {
            threads = new Hashtable();
        }
        if ((threadState = (ThreadState)threads.get(thread2)) == null) {
            if (pySystemState == null) {
                Py.writeDebug("threadstate", "no current system state");
                pySystemState = Py.defaultSystemState;
            }
            threadState = new ThreadState(thread2, pySystemState);
            threads.put(thread2, threadState);
            if (++additionCounter > 25) {
                this.cleanupThreadTable();
                additionCounter = 0;
            }
        }
        cachedThreadState = threadState;
        return threadState;
    }

    private void cleanupThreadTable() {
        Enumeration enumeration = threads.keys();
        while (enumeration.hasMoreElements()) {
            try {
                Object k = enumeration.nextElement();
                ThreadState threadState = (ThreadState)threads.get(k);
                if (threadState == null || threadState.thread == null || threadState.thread.isAlive()) continue;
                threads.remove(k);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    static {
        additionCounter = 0;
    }
}

