/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.pnn;

import org.encog.neural.networks.training.pnn.CalculationCriteria;
import org.encog.neural.networks.training.pnn.GlobalMinimumSearch;
import org.encog.util.EngineArray;
import org.encog.util.logging.EncogLogging;

public class DeriveMinimum {
    public double calculate(int maxIterations, double maxError, double eps, double tol, CalculationCriteria network, int n, double[] x, double ystart, double[] base, double[] direc, double[] g, double[] h, double[] deriv2) {
        GlobalMinimumSearch globalMinimum = new GlobalMinimumSearch();
        double fbest = network.calcErrorWithMultipleSigma(x, direc, deriv2, true);
        double prevBest = 1.0E30;
        for (int i = 0; i < n; ++i) {
            direc[i] = -direc[i];
        }
        EngineArray.arrayCopy(direc, g);
        EngineArray.arrayCopy(direc, h);
        int convergenceCounter = 0;
        int poorCJ = 0;
        for (int iteration = 0; iteration < maxIterations && !(fbest < maxError); ++iteration) {
            int i;
            EncogLogging.log(1, "Beginning internal Iteration #" + iteration + ", currentError=" + fbest + ",target=" + maxError);
            double toler = prevBest <= 1.0 ? tol : tol * prevBest;
            if (prevBest - fbest <= toler) {
                if (++convergenceCounter >= 3) {
                    break;
                }
            } else {
                convergenceCounter = 0;
            }
            double dot1 = 0.0;
            double dot2 = 0.0;
            double dlen = 0.0;
            dlen = 0.0;
            dot2 = 0.0;
            dot1 = 0.0;
            double high = 1.0E-4;
            for (int i2 = 0; i2 < n; ++i2) {
                base[i2] = x[i2];
                if (deriv2[i2] > high) {
                    high = deriv2[i2];
                }
                dot1 += direc[i2] * g[i2];
                dot2 += direc[i2] * direc[i2] * deriv2[i2];
                dlen += direc[i2] * direc[i2];
            }
            dlen = Math.sqrt(dlen);
            double scale = Math.abs(dot2) < 1.0E-13 ? 0.0 : dot1 / dot2;
            if ((high = 1.5 / high) < 1.0E-4) {
                high = 1.0E-4;
            }
            if (scale < 0.0) {
                scale = high;
            } else if (scale < 0.1 * high) {
                scale = 0.1 * high;
            } else if (scale > 10.0 * high) {
                scale = 10.0 * high;
            }
            prevBest = fbest;
            globalMinimum.setY2(fbest);
            globalMinimum.findBestRange(0.0, 2.0 * scale, -3, false, maxError, network);
            if (globalMinimum.getY2() < maxError) {
                if (globalMinimum.getY2() < fbest) {
                    for (i = 0; i < n; ++i) {
                        x[i] = base[i] + globalMinimum.getY2() * direc[i];
                        if (!(x[i] < 1.0E-10)) continue;
                        x[i] = 1.0E-10;
                    }
                    fbest = globalMinimum.getY2();
                    break;
                }
                System.arraycopy(base, 0, x, 0, n);
                break;
            }
            fbest = convergenceCounter > 0 ? globalMinimum.brentmin(20, maxError, eps, 1.0E-7, network, globalMinimum.getY2()) : globalMinimum.brentmin(10, maxError, 1.0E-6, 1.0E-5, network, globalMinimum.getY2());
            for (i = 0; i < n; ++i) {
                x[i] = base[i] + globalMinimum.getX2() * direc[i];
                if (!(x[i] < 1.0E-10)) continue;
                x[i] = 1.0E-10;
            }
            double improvement = (prevBest - fbest) / prevBest;
            if (fbest < maxError) break;
            for (i = 0; i < n; ++i) {
                direc[i] = -direc[i];
            }
            double gam = this.gamma(n, g, direc);
            if (gam < 0.0) {
                gam = 0.0;
            }
            if (gam > 10.0) {
                gam = 10.0;
            }
            poorCJ = improvement < 0.001 ? ++poorCJ : 0;
            if (poorCJ >= 2 && gam > 1.0) {
                gam = 1.0;
            }
            if (poorCJ >= 6) {
                poorCJ = 0;
                gam = 0.0;
            }
            this.findNewDir(n, gam, g, h, direc);
        }
        return fbest;
    }

    private void findNewDir(int n, double gam, double[] g, double[] h, double[] grad) {
        System.arraycopy(grad, 0, g, 0, n);
        for (int i = 0; i < n; ++i) {
            grad[i] = h[i] = g[i] + gam * h[i];
        }
    }

    private double gamma(int n, double[] g, double[] grad) {
        double denom = 0.0;
        double numer = 0.0;
        for (int i = 0; i < n; ++i) {
            denom += g[i] * g[i];
            numer += (grad[i] - g[i]) * grad[i];
        }
        if (denom == 0.0) {
            return 0.0;
        }
        return numer / denom;
    }
}

