/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.bayesian.query.sample;

import java.io.Serializable;
import org.encog.ml.bayesian.BayesianError;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.EventType;
import org.encog.util.Format;

public class EventState
implements Serializable {
    private boolean calculated;
    private int value;
    private final BayesianEvent event;
    private EventType eventType;
    private int compareValue;

    public EventState(BayesianEvent theEvent) {
        this.event = theEvent;
        this.eventType = EventType.Hidden;
        this.calculated = false;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void setCalculated(boolean calculated) {
        this.calculated = calculated;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.calculated = true;
        this.value = value;
    }

    public BayesianEvent getEvent() {
        return this.event;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public void randomize(int ... args) {
        this.setValue(this.event.getTable().generateRandom(args));
    }

    public int getCompareValue() {
        return this.compareValue;
    }

    public void setCompareValue(int compareValue) {
        this.compareValue = compareValue;
    }

    public boolean isSatisfied() {
        if (this.eventType == EventType.Hidden) {
            throw new BayesianError("Satisfy can't be called on a hidden event.");
        }
        return (double)Math.abs(this.compareValue - this.value) < 1.0E-13;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[EventState:event=");
        result.append(this.event.toString());
        result.append(",type=");
        result.append(this.eventType.toString());
        result.append(",value=");
        result.append(Format.formatDouble(this.value, 2));
        result.append(",compare=");
        result.append(Format.formatDouble(this.compareValue, 2));
        result.append(",calc=");
        result.append(this.calculated ? "y" : "n");
        result.append("]");
        return result.toString();
    }

    public static String toSimpleString(EventState state) {
        return BayesianEvent.formatEventName(state.getEvent(), state.getCompareValue());
    }
}

