/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.WordData;
import morfologik.tools.CliTool;
import morfologik.tools.ExitStatus;
import morfologik.tools.FSAInfo;
import morfologik.tools.ValidateFileExists;

@Parameters(commandNames={"dict_decompile"}, commandDescription="Decompiles morphological dictionary automaton back to source state.")
public class DictDecompile
extends CliTool {
    @Parameter(names={"-i", "--input"}, description="The input dictionary (*.dict and a sibling *.info metadata).", required=true, validateValueWith=ValidateFileExists.class)
    private Path input;
    @Parameter(names={"-o", "--output"}, description="The output file for dictionary data.")
    private Path output;
    @Parameter(names={"--overwrite"}, description="Overwrite the output file if it exists.")
    private boolean overwrite;
    @Parameter(names={"--validate"}, arity=1, description="Validate decoded output to make sure it can be re-encoded.")
    private boolean validate = true;

    DictDecompile() {
    }

    public DictDecompile(Path input, Path output, boolean overwrite, boolean validate) {
        this.input = DictDecompile.checkNotNull(input);
        this.output = output;
        this.overwrite = overwrite;
        this.validate = validate;
    }

    @Override
    public ExitStatus call() throws Exception {
        Dictionary dictionary = Dictionary.read((Path)this.input);
        DictionaryLookup lookup = new DictionaryLookup(dictionary);
        if (this.output == null) {
            this.output = this.input.resolveSibling(this.input.getFileName().toString().replaceAll("\\.dict$", "") + ".input");
            if (Files.exists(this.output, new LinkOption[0]) && !this.overwrite) {
                System.err.println("ERROR: the default output file location already exists. Use --overwrite or remove the file manually: " + this.output.toString());
                return ExitStatus.ERROR_CONFIRMATION_REQUIRED;
            }
        }
        byte separator = dictionary.metadata.getSeparator();
        ByteBuffer stem = ByteBuffer.allocate(0);
        ByteBuffer word = ByteBuffer.allocate(0);
        ByteBuffer tag = ByteBuffer.allocate(0);
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(this.output, new OpenOption[0]));){
            boolean hasTags = false;
            for (WordData wd : lookup) {
                tag = wd.getTagBytes(tag);
                if (!tag.hasRemaining()) continue;
                hasTags = true;
                break;
            }
            for (WordData wd : lookup) {
                stem = wd.getStemBytes(stem);
                word = wd.getWordBytes(word);
                tag = wd.getTagBytes(tag);
                this.write(os, stem);
                ((OutputStream)os).write(separator);
                this.write(os, word);
                if (hasTags) {
                    ((OutputStream)os).write(separator);
                    this.write(os, tag);
                }
                ((OutputStream)os).write(10);
                if (!this.validate || !this.ensureNoSeparator(stem, separator) && !this.ensureNoSeparator(word, separator)) continue;
                System.err.println("ERROR: The stem or word of a dictionary entry contains separator  byte " + FSAInfo.byteAsChar(separator) + ", this will prevent proper re-encoding." + " Add '--validate false' to override. Offending entry: " + wd.getStem() + ", " + wd.getWord());
                ExitStatus exitStatus = ExitStatus.ERROR_OTHER;
                return exitStatus;
            }
        }
        return ExitStatus.SUCCESS;
    }

    private void write(OutputStream os, ByteBuffer bb) throws IOException {
        os.write(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
    }

    private boolean ensureNoSeparator(ByteBuffer bb, byte marker) {
        byte[] buf = bb.array();
        int o = bb.arrayOffset() + bb.position();
        for (int i = bb.remaining(); i > 0; --i) {
            if (buf[o] != marker) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        DictDecompile.main(args, (CliTool)new DictDecompile());
    }
}

