/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class WordRepeatRule
extends Rule {
    public WordRepeatRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(Categories.MISC.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Duplication);
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        return false;
    }

    @Override
    public String getId() {
        return "WORD_REPEAT_RULE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_repetition");
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String prevToken = "";
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i].getToken();
            if (tokens[i].isImmunized()) {
                prevToken = "";
                continue;
            }
            if (this.isWord(token) && prevToken.equalsIgnoreCase(token) && !this.ignore(tokens, i)) {
                String msg = this.messages.getString("repetition");
                int prevPos = tokens[i - 1].getStartPos();
                int pos = tokens[i].getStartPos();
                RuleMatch ruleMatch = this.createRuleMatch(prevToken, token, prevPos, pos, msg);
                ruleMatches.add(ruleMatch);
            }
            prevToken = token;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected RuleMatch createRuleMatch(String prevToken, String token, int prevPos, int pos, String msg) {
        RuleMatch ruleMatch = new RuleMatch(this, prevPos, pos + prevToken.length(), msg, this.messages.getString("desc_repetition_short"));
        ruleMatch.setSuggestedReplacement(prevToken);
        return ruleMatch;
    }

    private boolean isWord(String token) {
        boolean isWord = true;
        if (token.length() == 0) {
            isWord = false;
        } else if (token.length() == 1) {
            char c = token.charAt(0);
            if (!Character.isLetter(c)) {
                isWord = false;
            }
        } else if (token.matches("0+")) {
            isWord = false;
        }
        return isWord;
    }

    @Override
    public void reset() {
    }
}

