/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.values.ValueContainer;
import java.io.Serializable;
import java.util.Arrays;

public abstract class AbstractNgramMap<T>
implements NgramMap<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final byte NUM_BITS_PER_BYTE = 8;
    protected final int NUM_WORD_BITS;
    protected final int NUM_SUFFIX_BITS;
    protected final long WORD_BIT_MASK;
    protected final long SUFFIX_BIT_MASK;
    protected final ValueContainer<T> values;
    protected final ConfigOptions opts;

    protected final long contextOffsetOf(long key) {
        return key & this.SUFFIX_BIT_MASK;
    }

    protected final int wordOf(long key) {
        return (int)((key & this.WORD_BIT_MASK) >>> this.NUM_SUFFIX_BITS);
    }

    protected final long combineToKey(int word, long suffixIndex) {
        return (long)word << this.NUM_SUFFIX_BITS | suffixIndex;
    }

    protected AbstractNgramMap(ValueContainer<T> values, ConfigOptions opts) {
        this.values = values;
        this.opts = opts;
        this.NUM_WORD_BITS = opts.numWordBits;
        this.NUM_SUFFIX_BITS = 64 - this.NUM_WORD_BITS;
        this.WORD_BIT_MASK = (1L << this.NUM_WORD_BITS) - 1L << this.NUM_SUFFIX_BITS;
        this.SUFFIX_BIT_MASK = (1L << this.NUM_SUFFIX_BITS) - 1L;
    }

    protected static boolean equals(int[] ngram, int startPos, int endPos, int[] cachedNgram) {
        if (cachedNgram.length != endPos - startPos) {
            return false;
        }
        for (int i = 0; i < endPos - startPos; ++i) {
            if (ngram[startPos + i] == cachedNgram[i]) continue;
            return false;
        }
        return true;
    }

    protected static int[] getSubArray(int[] ngram, int startPos, int endPos) {
        return Arrays.copyOfRange(ngram, startPos, endPos);
    }

    protected static boolean containsOutOfVocab(int[] ngram, int startPos, int endPos) {
        for (int i = startPos; i < endPos; ++i) {
            if (ngram[i] >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValueContainer<T> getValues() {
        return this.values;
    }
}

