/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.NgramLanguageModel;
import edu.berkeley.nlp.lm.io.LmReaders;
import edu.berkeley.nlp.lm.util.Logger;
import java.util.ArrayList;

public class MakeLmBinaryFromArpa {
    private static void usage() {
        System.err.println("Usage: [opts] <ARPA lm file> <outputfile>");
        for (Opts opts : Opts.values()) {
            System.err.println("\t" + opts.toString() + ": " + opts.docString());
        }
        System.exit(1);
    }

    public static void main(String[] argv) {
        ArrayList<String> fileArgs = new ArrayList<String>();
        Opts finalOpt = Opts.HASH_OPT;
        block0: for (String arg : argv) {
            if (arg.startsWith("-")) {
                for (Opts opts : Opts.values()) {
                    if (!opts.toString().equals(arg)) continue;
                    finalOpt = opts;
                    continue block0;
                }
                System.err.println("Unrecognized opts: " + arg);
                MakeLmBinaryFromArpa.usage();
                continue;
            }
            fileArgs.add(arg);
        }
        if (fileArgs.size() != 2) {
            MakeLmBinaryFromArpa.usage();
        }
        Logger.setGlobalLogger(new Logger.SystemLogger(System.out, System.err));
        String lmFile = (String)fileArgs.get(0);
        Logger.startTrack("Reading Lm File " + lmFile + " . . . ", new Object[0]);
        NgramLanguageModel<String> lm = finalOpt.makeLm(lmFile);
        Logger.endTrack();
        String outFile = (String)fileArgs.get(1);
        Logger.startTrack("Writing to file " + outFile + " . . . ", new Object[0]);
        LmReaders.writeLmBinary(lm, outFile);
        Logger.endTrack();
    }

    private static enum Opts {
        HASH_OPT{

            public String toString() {
                return "-h";
            }

            @Override
            public String docString() {
                return "build an array-encoded hash-table LM (the default)";
            }

            @Override
            public NgramLanguageModel<String> makeLm(String file) {
                return LmReaders.readArrayEncodedLmFromArpa(file, false);
            }
        }
        ,
        CONTEXT_OPT{

            public String toString() {
                return "-e";
            }

            @Override
            public String docString() {
                return "build a context-encoded LM instead of the default hash table";
            }

            @Override
            public NgramLanguageModel<String> makeLm(String file) {
                return LmReaders.readContextEncodedLmFromArpa(file);
            }
        }
        ,
        COMPRESS_OPT{

            public String toString() {
                return "-c";
            }

            @Override
            public String docString() {
                return "build a compressed hash-table LM instead of the array encoding";
            }

            @Override
            public NgramLanguageModel<String> makeLm(String file) {
                return LmReaders.readArrayEncodedLmFromArpa(file, true);
            }
        };


        public abstract String docString();

        public abstract NgramLanguageModel<String> makeLm(String var1);
    }
}

