/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.ModelLibrary;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryImpl
extends PluginElementImpl<Library>
implements Library {
    private final ModelLibrary model;
    private List<String> exports;

    LibraryImpl(PluginDescriptorImpl descr, PluginFragmentImpl aFragment, ModelLibrary aModel) throws ManifestProcessingException {
        super(descr, aFragment, aModel.getId(), aModel.getDocumentation());
        this.model = aModel;
        if (this.model.getPath() == null || this.model.getPath().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "libraryPathIsBlank");
        }
        this.exports = new ArrayList<String>(this.model.getExports().size());
        for (String exportPrefix : this.model.getExports()) {
            if (exportPrefix == null || exportPrefix.trim().length() == 0) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "exportPrefixIBlank");
            }
            if ((exportPrefix = exportPrefix.replace('\\', '.').replace('/', '.')).startsWith(".")) {
                exportPrefix = exportPrefix.substring(1);
            }
            this.exports.add(exportPrefix);
        }
        this.exports = Collections.unmodifiableList(this.exports);
        if (this.log.isDebugEnabled()) {
            this.log.debug("object instantiated: " + this);
        }
    }

    @Override
    public String getPath() {
        return this.model.getPath();
    }

    @Override
    public Collection<String> getExports() {
        return this.exports;
    }

    @Override
    public boolean isCodeLibrary() {
        return this.model.isCodeLibrary();
    }

    @Override
    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    public String toString() {
        return "{Library: uid=" + this.getUniqueId() + "}";
    }

    @Override
    public Version getVersion() {
        return this.model.getVersion();
    }
}

