/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class DesktopFile {
    public static final String BOOLEAN_TRUE = "true";
    public static final String BOOLEAN_FALSE = "false";
    public static final String TYPE_APPLICATION = "Application";
    public static final String TYPE_TERMINAL = "Terminal";
    private static DesktopFile desktopFile = null;
    private static File localFileDesktop = null;
    private String desktopFileName;
    private String defaultName;
    private Map<Locale, String> names;
    private String defaultComment;
    private Map<Locale, String> comments;
    private String command;
    private String icon;
    private String categories;
    private String startupWMClass;
    private String startupNotify = "true";
    private String terminal = "false";
    private String type = "Application";
    private boolean changed = false;

    public static DesktopFile initialize(String string, String string2) throws IOException {
        if (string == null) {
            throw new NullPointerException("desktopFileName can't be null");
        }
        desktopFile = new DesktopFile(string, string2);
        return desktopFile;
    }

    public static DesktopFile getInstance() {
        if (desktopFile == null) {
            throw new IllegalAccessError("DesktopFile is not initialized");
        }
        return desktopFile;
    }

    private DesktopFile(String string, String string2) throws IOException {
        this.desktopFileName = string;
        if (!this.desktopFileName.endsWith(".desktop")) {
            this.desktopFileName = this.desktopFileName + ".desktop";
        }
        this.names = new TreeMap<Locale, String>();
        this.comments = new TreeMap<Locale, String>();
        this.load();
        this.setStartupWMClass(string2);
    }

    public void setName(String string) {
        this.defaultName = string;
    }

    public void setName(String string, Locale locale) {
        String string2 = this.names.put(locale, string);
        if (string2 == null ? string2 != null : !string2.equals(string)) {
            this.changed = true;
        }
    }

    public String getName() {
        return this.defaultName;
    }

    public String getName(Locale locale) {
        return this.names.get(locale);
    }

    public void setComment(String string) {
        this.defaultComment = string;
    }

    public void setComment(String string, Locale locale) {
        String string2 = this.comments.put(locale, string);
        if (string2 == null ? string2 != null : !string2.equals(string2)) {
            this.changed = true;
        }
    }

    public String getComment() {
        return this.defaultComment;
    }

    public String getComment(Locale locale) {
        return this.comments.get(locale);
    }

    public void setCommand(String string) {
        if (this.command == null ? string != null : !this.command.equals(string)) {
            this.changed = true;
        }
        this.command = string;
    }

    public String getCommand() {
        return this.command;
    }

    public void setIcon(String string) {
        if (this.icon == null ? string != null : !this.icon.equals(string)) {
            this.changed = true;
        }
        this.icon = string;
    }

    public String getIcon() {
        return this.icon;
    }

    private String toStringCategories(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        String string = "";
        for (String string2 : stringArray) {
            string = string + string2 + ";";
        }
        string = string.substring(0, string.length() - 1);
        return string;
    }

    public void setCategories(String ... stringArray) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (this.categories == null ? stringArray.length > 0 : !this.categories.equals(this.toStringCategories(stringArray))) {
            this.changed = true;
        }
        this.categories = this.toStringCategories(stringArray);
    }

    public String getCategories() {
        return this.categories;
    }

    public void setStartupWMClass(String string) {
        if (string == null) {
            throw new NullPointerException("startupWMClass can't be null");
        }
        if (this.startupWMClass == null ? string != null : !this.startupWMClass.equals(string)) {
            this.changed = true;
        }
        this.startupWMClass = string;
        if (this.changed) {
            DesktopFile.setStartupWMClassToToolKit(string);
        }
    }

    public static String getStartupWMClassFromToolKit() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Field field = toolkit.getClass().getDeclaredField("awtAppClassName");
            field.setAccessible(true);
            String string = (String)field.get(toolkit);
            field.setAccessible(false);
            return string;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void setStartupWMClassToToolKit() {
        DesktopFile.setStartupWMClassToToolKit(DesktopFile.getInstance().getStartupWMClass());
    }

    public static void setStartupWMClassToToolKit(String string) {
        try {
            System.setProperty("java.awt.WM_CLASS", string);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Field field = toolkit.getClass().getDeclaredField("awtAppClassName");
            field.setAccessible(true);
            field.set(toolkit, string);
            field.setAccessible(false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getStartupWMClass() {
        return this.startupWMClass;
    }

    private String getStartupNotify() {
        return this.startupNotify;
    }

    private void setStartupNotify(String string) {
        if (this.startupNotify == null ? string != null : !this.startupNotify.equals(string)) {
            this.changed = true;
        }
        this.startupNotify = string;
    }

    private String getTerminal() {
        return this.terminal;
    }

    private void setTerminal(String string) {
        if (this.terminal == null ? string != null : !this.terminal.equals(string)) {
            this.changed = true;
        }
        this.terminal = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        if (this.type == null ? string != null : !this.type.equals(string)) {
            this.changed = true;
        }
        this.type = string;
    }

    private Locale resolveLocale(String string) {
        Locale locale;
        if (string.contains("_")) {
            String[] stringArray = string.split("_");
            locale = new Locale(stringArray[0], stringArray[1]);
        } else {
            locale = new Locale(string);
        }
        return locale;
    }

    public boolean load() throws IOException {
        File file = this.getLocalFile();
        if (!file.exists()) {
            file = new File("/usr/share/applications/" + this.getDesktopFileName());
        }
        if (file.exists()) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                if (!string.contains("=") || string.startsWith("#")) continue;
                String[] stringArray = string.split("=");
                String string3 = stringArray[0].trim().toLowerCase();
                String string4 = stringArray[1].trim();
                if (string3.startsWith("name")) {
                    if (string3.endsWith("]")) {
                        string2 = string3.substring(string3.indexOf("[") + 1, string3.length() - 1);
                        this.setName(string4, this.resolveLocale(string2));
                        continue;
                    }
                    this.setName(string4);
                    continue;
                }
                if (string3.startsWith("comment")) {
                    if (string3.endsWith("]")) {
                        string2 = string3.substring(string3.indexOf("[") + 1, string3.length() - 1);
                        this.setComment(string4, this.resolveLocale(string2));
                        continue;
                    }
                    this.setComment(string4);
                    continue;
                }
                if (string3.equals("encoding")) continue;
                if (string3.equals("exec")) {
                    this.setCommand(string4);
                    continue;
                }
                if (string3.equals("icon")) {
                    this.setIcon(string4);
                    continue;
                }
                if (string3.equals("categories")) {
                    this.setCategories(string4.split(","));
                    continue;
                }
                if (string3.equals("startupwmclass")) {
                    this.setStartupWMClass(string4);
                    continue;
                }
                if (string3.equals("startupnotify")) {
                    this.setStartupNotify(string4);
                    continue;
                }
                if (string3.equals("type")) {
                    this.setType(string4);
                    continue;
                }
                if (!string3.equals("terminal")) continue;
                this.setTerminal(string4);
            }
            bufferedReader.close();
            this.changed = false;
            return true;
        }
        return false;
    }

    public boolean update() throws IOException {
        if (this.changed) {
            File file = this.getLocalFile();
            file.getParentFile().mkdirs();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("[Desktop Entry]");
            bufferedWriter.newLine();
            if (this.getName() != null) {
                bufferedWriter.write("Name=" + this.getName());
                bufferedWriter.newLine();
            }
            for (Map.Entry<Locale, String> entry : this.names.entrySet()) {
                if (entry.getValue() == null) continue;
                bufferedWriter.write("Name[" + entry.getKey().toString() + "]=" + entry.getValue());
                bufferedWriter.newLine();
            }
            if (this.getComment() != null) {
                bufferedWriter.write("Comment=" + this.getComment());
                bufferedWriter.newLine();
            }
            for (Map.Entry<Locale, String> entry : this.comments.entrySet()) {
                if (entry.getValue() == null) continue;
                bufferedWriter.write("Comment[" + entry.getKey().toString() + "]=" + entry.getValue());
                bufferedWriter.newLine();
            }
            if (this.getCommand() != null) {
                bufferedWriter.write("Exec=" + this.getCommand());
                bufferedWriter.newLine();
            }
            if (this.getIcon() != null) {
                bufferedWriter.write("Icon=" + this.getIcon());
                bufferedWriter.newLine();
            }
            if (this.getCategories() != null) {
                bufferedWriter.write("Categories=" + this.getCategories());
                bufferedWriter.newLine();
            }
            if (this.getStartupWMClass() != null) {
                bufferedWriter.write("StartupWMClass=" + this.getStartupWMClass());
                bufferedWriter.newLine();
            }
            if (this.getStartupNotify() != null) {
                bufferedWriter.write("StartupNotify=" + this.getStartupNotify());
                bufferedWriter.newLine();
            }
            if (this.getTerminal() != null) {
                bufferedWriter.write("Terminal=" + this.getTerminal());
                bufferedWriter.newLine();
            }
            if (this.getType() != null) {
                bufferedWriter.write("Type=" + this.getType());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            try {
                Runtime.getRuntime().exec("xdg-desktop-menu forceupdate");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.changed = false;
            return true;
        }
        return false;
    }

    public boolean delete() {
        return this.getLocalFile().delete();
    }

    public String getDesktopFileName() {
        return this.desktopFileName;
    }

    File getLocalFile() {
        if (localFileDesktop == null) {
            localFileDesktop = new File(System.getProperty("user.home"), "/.local/share/applications/" + this.getDesktopFileName());
        }
        return localFileDesktop;
    }
}

