/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.SwingUtilities;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.JabRef;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.specialfields.SpecialFieldsUtils;

public class SpecialFieldUpdateListener
implements VetoableChangeListener {
    private static SpecialFieldUpdateListener INSTANCE = null;

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        final BibtexEntry entry = (BibtexEntry)e.getSource();
        final String fieldName = e.getPropertyName();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (fieldName.equals("keywords")) {
                    SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JabRef.jrf.basePanel().updateEntryEditorIfShowing();
                        }
                    });
                } else {
                    SpecialField field = SpecialFieldsUtils.getSpecialFieldInstanceFromFieldName(fieldName);
                    if (field != null) {
                        SpecialFieldsUtils.syncKeywordsFromSpecialFields(entry, null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JabRef.jrf.basePanel().updateEntryEditorIfShowing();
                            }
                        });
                    }
                }
            }
        });
    }

    public static SpecialFieldUpdateListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpecialFieldUpdateListener();
        }
        return INSTANCE;
    }
}

