/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.sun.star.awt.FontSlant;
import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.UnoRuntime;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.oo.OOPreFormatter;
import net.sf.jabref.oo.OpenOfficePanel;
import net.sf.jabref.oo.UndefinedParagraphFormatException;

public class OOUtil {
    static Pattern htmlTag = Pattern.compile("</?[a-z]+>");
    static OOPreFormatter postformatter = new OOPreFormatter();

    public static void insertFullReferenceAtCurrentLocation(XText text, XTextCursor cursor, Layout layout, String parStyle, BibtexEntry entry, BibtexDatabase database, String uniquefier) throws UndefinedParagraphFormatException, Exception {
        String UNIQUEFIER_FIELD = "uniq";
        String oldUniqVal = entry.getField("uniq");
        entry.setField("uniq", uniquefier);
        String lText = layout.doLayout(entry, database);
        entry.setField("uniq", oldUniqVal);
        OOUtil.insertOOFormattedTextAtCurrentLocation(text, cursor, lText, parStyle);
    }

    public static void insertOOFormattedTextAtCurrentLocation(XText text, XTextCursor cursor, String lText, String parStyle) throws UndefinedParagraphFormatException, Exception {
        XParagraphCursor parCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)cursor);
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)parCursor);
        try {
            props.setPropertyValue("ParaStyleName", (Object)parStyle);
        }
        catch (IllegalArgumentException ex) {
            throw new UndefinedParagraphFormatException(parStyle);
        }
        int piv = 0;
        int italic = 0;
        int bold = 0;
        int sup = 0;
        int sub = 0;
        int mono = 0;
        int smallCaps = 0;
        Matcher m = htmlTag.matcher(lText);
        while (m.find()) {
            String tag;
            String ss = lText.substring(piv, m.start());
            if (ss.length() > 0) {
                OOUtil.insertTextAtCurrentLocation(text, cursor, ss, bold % 2 > 0, italic % 2 > 0, mono > 0, smallCaps > 0, sup > 0, sub > 0);
            }
            if ((tag = m.group()).equals("<b>")) {
                ++bold;
            } else if (tag.equals("</b>")) {
                --bold;
            } else if (tag.equals("<i>") || tag.equals("<em>")) {
                ++italic;
            } else if (tag.equals("</i>") || tag.equals("</em>")) {
                --italic;
            } else if (tag.equals("</monospace>")) {
                mono = 0;
            } else if (tag.equals("<monospace>")) {
                mono = 1;
            } else if (tag.equals("</smallcaps>")) {
                smallCaps = 0;
            } else if (tag.equals("<smallcaps>")) {
                smallCaps = 1;
            } else if (tag.equals("</sup>")) {
                sup = 0;
            } else if (tag.equals("<sup>")) {
                sup = 1;
            } else if (tag.equals("</sub>")) {
                sub = 0;
            } else if (tag.equals("<sub>")) {
                sub = 1;
            }
            piv = m.end();
        }
        if (piv < lText.length()) {
            OOUtil.insertTextAtCurrentLocation(text, cursor, lText.substring(piv), bold % 2 > 0, italic % 2 > 0, mono > 0, smallCaps > 0, sup > 0, sub > 0);
        }
        cursor.collapseToEnd();
    }

    public static void insertParagraphBreak(XText text, XTextCursor cursor) throws Exception {
        text.insertControlCharacter((XTextRange)cursor, (short)0, true);
        cursor.collapseToEnd();
    }

    public static void insertTextAtCurrentLocation(XText text, XTextCursor cursor, String string, boolean bold, boolean italic, boolean monospace, boolean smallCaps, boolean superscript, boolean subscript) throws Exception {
        text.insertString((XTextRange)cursor, string, true);
        XPropertySet xCursorProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)cursor);
        if (bold) {
            xCursorProps.setPropertyValue("CharWeight", (Object)new Float(150.0f));
        } else {
            xCursorProps.setPropertyValue("CharWeight", (Object)new Float(100.0f));
        }
        if (italic) {
            xCursorProps.setPropertyValue("CharPosture", (Object)FontSlant.ITALIC);
        } else {
            xCursorProps.setPropertyValue("CharPosture", (Object)FontSlant.NONE);
        }
        if (smallCaps) {
            xCursorProps.setPropertyValue("CharCaseMap", (Object)4);
        } else {
            xCursorProps.setPropertyValue("CharCaseMap", (Object)0);
        }
        if (subscript) {
            xCursorProps.setPropertyValue("CharEscapement", (Object)-101);
            xCursorProps.setPropertyValue("CharEscapementHeight", (Object)58);
        } else if (superscript) {
            xCursorProps.setPropertyValue("CharEscapement", (Object)101);
            xCursorProps.setPropertyValue("CharEscapementHeight", (Object)58);
        } else {
            xCursorProps.setPropertyValue("CharEscapement", (Object)0);
            xCursorProps.setPropertyValue("CharEscapementHeight", (Object)100);
        }
        cursor.collapseToEnd();
    }

    public static void insertTextAtCurrentLocation(XText text, XTextCursor cursor, String string, String parStyle) throws Exception {
        text.insertString((XTextRange)cursor, string, true);
        XParagraphCursor parCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)cursor);
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)parCursor);
        try {
            props.setPropertyValue("ParaStyleName", (Object)parStyle);
        }
        catch (IllegalArgumentException ex) {
            throw new UndefinedParagraphFormatException(parStyle);
        }
        cursor.collapseToEnd();
    }

    public static Object getProperty(Object o, String property) throws Exception {
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)o);
        return props.getPropertyValue(property);
    }

    public static void listProperties(Object o) throws Exception {
        XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)o);
        Property[] pr = props.getPropertySetInfo().getProperties();
        for (int i = 0; i < pr.length; ++i) {
            Property property1 = pr[i];
            System.out.println(property1.Name + " : " + props.getPropertyValue(property1.Name));
        }
    }

    public static XTextDocument selectComponent(JFrame parent, XDesktop xDesktop, List<XTextDocument> list) throws Exception {
        String[] values = new String[list.size()];
        int ii = 0;
        for (XTextDocument doc : list) {
            values[ii++] = String.valueOf(OOUtil.getProperty(doc.getCurrentController().getFrame(), "Title"));
        }
        JList<String> sel = new JList<String>(values);
        sel.setSelectionMode(0);
        sel.setSelectedIndex(0);
        int ans = JOptionPane.showConfirmDialog(parent, new JScrollPane(sel), Globals.lang("Select document"), 2);
        if (ans == 0) {
            return list.get(sel.getSelectedIndex());
        }
        return null;
    }

    public static BibtexEntry createAdaptedEntry(BibtexEntry entry) {
        if (entry == null) {
            return null;
        }
        BibtexEntry e = (BibtexEntry)entry.clone();
        for (String field : e.getAllFields()) {
            if (field.equals("bibtexkey")) continue;
            String value = e.getField(field);
            if (OpenOfficePanel.postLayoutSupported || value == null) continue;
            e.setField(field, postformatter.format(value));
        }
        return e;
    }
}

