/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Util;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.external.FileLinksUpgradeWarning;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CheckForNewEntryTypesAction;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PostOpenAction;
import net.sf.jabref.label.HandleDuplicateWarnings;
import net.sf.jabref.specialfields.SpecialFieldsUtils;

public class OpenDatabaseAction
extends MnemonicAwareAction {
    private static Logger logger = Logger.getLogger(OpenDatabaseAction.class.toString());
    boolean showDialog;
    private JabRefFrame frame;
    private static ArrayList<PostOpenAction> postOpenActions = new ArrayList();

    public OpenDatabaseAction(JabRefFrame frame, boolean showDialog) {
        super(GUIGlobals.getImage("open"));
        this.frame = frame;
        this.showDialog = showDialog;
        this.putValue("Name", "Open database");
        this.putValue("AcceleratorKey", Globals.prefs.getKey("Open database"));
        this.putValue("ShortDescription", Globals.lang("Open BibTeX database"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<File> filesToOpen = new ArrayList<File>();
        if (this.showDialog) {
            String[] chosen = FileDialogs.getMultipleFiles(this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", true);
            if (chosen != null) {
                for (int i = 0; i < chosen.length; ++i) {
                    if (chosen[i] == null) continue;
                    filesToOpen.add(new File(chosen[i]));
                }
            }
        } else {
            Util.pr("Name");
            Util.pr(e.getActionCommand());
            filesToOpen.add(new File(Util.checkName(e.getActionCommand())));
        }
        BasePanel toRaise = null;
        int initialCount = filesToOpen.size();
        int removed = 0;
        Iterator iterator = filesToOpen.iterator();
        block1: while (iterator.hasNext()) {
            File file = (File)iterator.next();
            for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
                BasePanel bp = this.frame.baseAt(i);
                if (bp.getFile() == null || !bp.getFile().equals(file)) continue;
                iterator.remove();
                if (++removed != initialCount) continue block1;
                toRaise = bp;
                continue block1;
            }
        }
        if (filesToOpen.size() > 0) {
            final List theFiles = Collections.unmodifiableList(filesToOpen);
            new Thread(){

                @Override
                public void run() {
                    Iterator i = theFiles.iterator();
                    while (i.hasNext()) {
                        OpenDatabaseAction.this.openIt((File)i.next(), true);
                    }
                }
            }.start();
            Iterator i = theFiles.iterator();
            while (i.hasNext()) {
                this.frame.getFileHistory().newFile(((File)i.next()).getPath());
            }
        } else if (toRaise != null) {
            this.frame.output(Globals.lang("File '%0' is already open.", toRaise.getFile().getPath()));
            this.frame.getTabbedPane().setSelectedComponent(toRaise);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openIt(File file, boolean raisePanel) {
        int answer;
        if (file == null) return;
        if (!file.exists()) return;
        File fileToLoad = file;
        this.frame.output(Globals.lang("Opening") + ": '" + file.getPath() + "'");
        boolean tryingAutosave = false;
        boolean autoSaveFound = AutoSaveManager.newerAutoSaveExists(file);
        if (autoSaveFound && !Globals.prefs.getBoolean("promptBeforeUsingAutosave")) {
            fileToLoad = AutoSaveManager.getAutoSaveFile(file);
            tryingAutosave = true;
        } else if (autoSaveFound && (answer = JOptionPane.showConfirmDialog(null, "<html>" + Globals.lang("An autosave file was found for this database. This could indicate ") + Globals.lang("that JabRef didn't shut down cleanly last time the file was used.") + "<br>" + Globals.lang("Do you want to recover the database from the autosave file?") + "</html>", Globals.lang("Recover from autosave"), 0)) == 0) {
            fileToLoad = AutoSaveManager.getAutoSaveFile(file);
            tryingAutosave = true;
        }
        boolean done = false;
        while (!done) {
            ParserResult pr;
            String fileName = file.getPath();
            Globals.prefs.put("workingDirectory", file.getPath());
            String encoding = Globals.prefs.get("defaultEncoding");
            if (Util.hasLockFile(file)) {
                long modTime = Util.getLockFileTimeStamp(file);
                if (modTime != -1L && System.currentTimeMillis() - modTime > 60000L) {
                    int answer2 = JOptionPane.showConfirmDialog(null, "<html>" + Globals.lang("Error opening file") + " '" + fileName + "'. " + Globals.lang("File is locked by another JabRef instance.") + "<p>" + Globals.lang("Do you want to override the file lock?"), Globals.lang("File locked"), 0);
                    if (answer2 != 0) return;
                    Util.deleteLockFile(file);
                } else if (!Util.waitForFileLock(file, 10)) {
                    JOptionPane.showMessageDialog(null, Globals.lang("Error opening file") + " '" + fileName + "'. " + Globals.lang("File is locked by another JabRef instance."), Globals.lang("Error"), 0);
                    return;
                }
            }
            String errorMessage = null;
            try {
                pr = OpenDatabaseAction.loadDatabase(fileToLoad, encoding);
            }
            catch (Exception ex) {
                errorMessage = ex.getMessage();
                pr = null;
            }
            if (pr == null || pr == ParserResult.INVALID_FORMAT) {
                JOptionPane.showMessageDialog(null, Globals.lang("Error opening file") + " '" + fileName + "'", Globals.lang("Error"), 0);
                String message = "<html>" + errorMessage + "<p>" + (tryingAutosave ? Globals.lang("Error opening autosave of '%0'. Trying to load '%0' instead.", file.getName()) : "") + "</html>";
                JOptionPane.showMessageDialog(null, message, Globals.lang("Error opening file"), 0);
                if (!tryingAutosave) return;
                tryingAutosave = false;
                fileToLoad = file;
                continue;
            }
            done = true;
            final BasePanel panel = this.addNewDatabase(pr, file, raisePanel);
            if (tryingAutosave) {
                panel.markNonUndoableBaseChanged();
            }
            final ParserResult prf = pr;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OpenDatabaseAction.performPostOpenActions(panel, prf, true);
                }
            });
        }
    }

    public static void performPostOpenActions(BasePanel panel, ParserResult pr, boolean mustRaisePanel) {
        for (PostOpenAction action : postOpenActions) {
            if (!action.isActionNecessary(pr)) continue;
            if (mustRaisePanel) {
                panel.frame().getTabbedPane().setSelectedComponent(panel);
            }
            action.performAction(panel, pr);
        }
    }

    public BasePanel addNewDatabase(ParserResult pr, final File file, boolean raisePanel) {
        String fileName = file.getPath();
        BibtexDatabase db = pr.getDatabase();
        MetaData meta = pr.getMetaData();
        if (pr.hasWarnings()) {
            final String[] wrns = pr.warnings();
            new Thread(){

                @Override
                public void run() {
                    StringBuffer wrn = new StringBuffer();
                    for (int i = 0; i < wrns.length; ++i) {
                        wrn.append(i + 1).append(". ").append(wrns[i]).append("\n");
                    }
                    if (wrn.length() > 0) {
                        wrn.deleteCharAt(wrn.length() - 1);
                    }
                    JOptionPane.showMessageDialog(OpenDatabaseAction.this.frame, wrn.toString(), Globals.lang("Warnings") + " (" + file.getName() + ")", 2);
                }
            }.start();
        }
        BasePanel bp = new BasePanel(this.frame, db, file, meta, pr.getEncoding());
        SwingUtilities.invokeLater(new OpenItSwingHelper(bp, file, raisePanel));
        this.frame.output(Globals.lang("Opened database") + " '" + fileName + "' " + Globals.lang("with") + " " + db.getEntryCount() + " " + Globals.lang("entries") + ".");
        return bp;
    }

    public static ParserResult loadDatabase(File fileToOpen, String encoding) throws IOException {
        Reader reader;
        Reader utf8Reader = ImportFormatReader.getReader(fileToOpen, "UTF8");
        String suppliedEncoding = OpenDatabaseAction.checkForEncoding(utf8Reader);
        utf8Reader.close();
        if (suppliedEncoding == null) {
            Reader utf16Reader = ImportFormatReader.getReader(fileToOpen, "UTF-16");
            suppliedEncoding = OpenDatabaseAction.checkForEncoding(utf16Reader);
            utf16Reader.close();
        }
        if (suppliedEncoding != null) {
            try {
                reader = ImportFormatReader.getReader(fileToOpen, suppliedEncoding);
                encoding = suppliedEncoding;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                reader = ImportFormatReader.getReader(fileToOpen, encoding);
            }
        } else {
            reader = ImportFormatReader.getReader(fileToOpen, encoding);
        }
        BibtexParser bp = new BibtexParser(reader);
        ParserResult pr = bp.parse();
        pr.setEncoding(encoding);
        pr.setFile(fileToOpen);
        if (SpecialFieldsUtils.keywordSyncEnabled()) {
            for (BibtexEntry entry : pr.getDatabase().getEntries()) {
                SpecialFieldsUtils.syncSpecialFieldsFromKeywords(entry, null);
            }
            logger.fine(Globals.lang("Synchronized special fields based on keywords"));
        }
        if (!pr.getMetaData().isGroupTreeValid()) {
            pr.addWarning(Globals.lang("Group tree could not be parsed. If you save the BibTeX database, all groups will be lost."));
        }
        return pr;
    }

    private static String checkForEncoding(Reader reader) {
        String suppliedEncoding = null;
        StringBuffer headerText = new StringBuffer();
        try {
            boolean keepon = true;
            int piv = 0;
            int offset = 0;
            block2: while (keepon) {
                int c = reader.read();
                if (piv == 0 && (c == 37 || Character.isWhitespace((char)c))) {
                    ++offset;
                } else {
                    headerText.append((char)c);
                    if (c == "This file was created with JabRef".charAt(piv)) {
                        ++piv;
                    } else {
                        keepon = false;
                    }
                }
                if (piv != "This file was created with JabRef".length()) continue;
                keepon = false;
                while (reader.read() != 10) {
                }
                while ((c = reader.read()) == 37 || Character.isWhitespace((char)c)) {
                }
                if ((char)c != GUIGlobals.encPrefix.charAt(0)) continue;
                for (int i = 1; i < GUIGlobals.encPrefix.length(); ++i) {
                    if (reader.read() != GUIGlobals.encPrefix.charAt(i)) continue block2;
                }
                StringBuffer sb = new StringBuffer();
                while ((c = reader.read()) != 10) {
                    sb.append((char)c);
                }
                suppliedEncoding = sb.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return suppliedEncoding != null ? suppliedEncoding.trim() : null;
    }

    static {
        postOpenActions.add(new CheckForNewEntryTypesAction());
        postOpenActions.add(new FileLinksUpgradeWarning());
        postOpenActions.add(new HandleDuplicateWarnings());
    }

    class OpenItSwingHelper
    implements Runnable {
        BasePanel bp;
        boolean raisePanel;
        File file;

        OpenItSwingHelper(BasePanel bp, File file, boolean raisePanel) {
            this.bp = bp;
            this.raisePanel = raisePanel;
            this.file = file;
        }

        @Override
        public void run() {
            OpenDatabaseAction.this.frame.addTab(this.bp, this.file, this.raisePanel);
        }
    }
}

