/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibsonomyScraper;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.net.URLDownload;

public class JSTORFetcher2
implements EntryFetcher {
    protected static final String CANCELLED = "__CANCELLED__";
    protected static int MAX_PAGES_TO_LOAD = 8;
    protected static int MAX_REFS = 175;
    protected static int REFS_PER_PAGE = 25;
    protected static final String JSTOR_URL = "http://www.jstor.org";
    protected static final String SEARCH_URL = "http://www.jstor.org/action/doBasicSearch?Query=";
    protected static final String SEARCH_URL_END = "&x=0&y=0&wc=on";
    protected static final String SINGLE_CIT_ENC = "http://www.jstor.org/action/exportSingleCitation?singleCitation=true&suffix=";
    protected static final Pattern idPattern = Pattern.compile("<a class=\"title\" href=\"/stable/(\\d+)\\?");
    protected static final Pattern numberofhits = Pattern.compile("<span id=\"NumberOfHits\" name=\"(\\d+)\"");
    protected static final Pattern nextPagePattern = Pattern.compile("<a href=\"(.*)\">Next&nbsp;&raquo;");
    protected static final String noAccessIndicator = "We do not recognize you as having access to JSTOR";
    protected boolean stopFetching = false;
    protected boolean noAccessFound = false;

    @Override
    public String getHelpPage() {
        return "JSTOR.html";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getKeyName() {
        return "JSTOR";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "JSTOR";
    }

    @Override
    public void stopFetching() {
        this.stopFetching = true;
        this.noAccessFound = false;
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        this.stopFetching = false;
        try {
            List<String> citations = this.getCitations(query, dialog, status);
            if (citations == null) {
                return false;
            }
            if (citations.size() == 0) {
                if (!this.noAccessFound) {
                    status.showMessage(Globals.lang("No entries found for the search string '%0'", query), Globals.lang("Search JSTOR"), 1);
                } else {
                    status.showMessage(Globals.lang("No entries found. It looks like you do not have access to search JStor.", query), Globals.lang("Search JSTOR"), 1);
                }
                return false;
            }
            int i = 0;
            for (String cit : citations) {
                if (this.stopFetching) break;
                BibtexEntry entry = this.getSingleCitation(cit);
                if (entry != null) {
                    dialog.addEntry(entry);
                }
                dialog.setProgress(++i, citations.size());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            status.showMessage(Globals.lang("Error while fetching from JSTOR") + ": " + e.getMessage());
            return false;
        }
    }

    protected List<String> getCitations(String query, ImportInspector dialog, OutputPrinter status) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            String urlQuery = SEARCH_URL + URLEncoder.encode(query, "UTF-8") + SEARCH_URL_END;
            String[] numberOfRefs = new String[2];
            int refsRequested = 0;
            int numberOfPagesRequested = MAX_PAGES_TO_LOAD;
            String nextPage = null;
            for (int count = 1; count <= Math.min(MAX_PAGES_TO_LOAD, numberOfPagesRequested) && (nextPage = this.getCitationsFromUrl(urlQuery, ids, count, numberOfRefs, dialog, status)) != null; ++count) {
                if (count == 1 && nextPage.equals(CANCELLED)) {
                    return null;
                }
                refsRequested = Integer.valueOf(numberOfRefs[1]);
                numberOfPagesRequested = (refsRequested - 1 - (refsRequested - 1) % REFS_PER_PAGE) / REFS_PER_PAGE + 1;
                urlQuery = nextPage;
            }
            return ids;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCitationsFromUrl(String urlQuery, List<String> ids, int count, String[] numberOfRefs, ImportInspector dialog, OutputPrinter status) throws IOException {
        String cont;
        URL url = new URL(urlQuery);
        URLDownload ud = new URLDownload(url);
        ud.download();
        String entirePage = cont = ud.getStringContent();
        String pageEntire = ud.getStringContent();
        int countOfRefs = 0;
        int refsRequested = 0;
        if (count == 1) {
            Matcher mn = numberofhits.matcher(pageEntire);
            if (mn.find()) {
                numberOfRefs[0] = mn.group(1);
                countOfRefs = Integer.valueOf(numberOfRefs[0]);
            } else {
                numberOfRefs[0] = "0";
            }
            while (true) {
                String strCount;
                if ((strCount = JOptionPane.showInputDialog(Globals.lang("References found") + ": " + countOfRefs + "  " + Globals.lang("Number of references to fetch?"), (Object)Integer.toString(countOfRefs))) == null) {
                    status.setStatus(Globals.lang("JSTOR import cancelled"));
                    return CANCELLED;
                }
                try {
                    numberOfRefs[1] = strCount.trim();
                    refsRequested = Integer.parseInt(numberOfRefs[1]);
                }
                catch (RuntimeException ex) {
                    status.showMessage(Globals.lang("Please enter a valid number"));
                    continue;
                }
                break;
            }
        }
        countOfRefs = Integer.valueOf(numberOfRefs[0]);
        refsRequested = Integer.valueOf(numberOfRefs[1]);
        Matcher m = idPattern.matcher(cont);
        if (m.find() && ids.size() + 1 <= Integer.valueOf(refsRequested)) {
            do {
                ids.add(m.group(1));
            } while ((m = idPattern.matcher(cont = cont.substring(m.end()))).find() && ids.size() + 1 <= Integer.valueOf(refsRequested));
        } else {
            if (entirePage.indexOf(noAccessIndicator) >= 0) {
                this.noAccessFound = true;
                return null;
            }
            return null;
        }
        m = nextPagePattern.matcher(entirePage);
        if (m.find()) {
            String newQuery = JSTOR_URL + m.group(1);
            return newQuery;
        }
        return null;
    }

    protected BibtexEntry getSingleCitation(String cit) {
        return BibsonomyScraper.getEntry(SINGLE_CIT_ENC + cit);
    }
}

