/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.OutputPrinter;

public abstract class ImportFormat
implements Comparable<ImportFormat> {
    private boolean isCustomImporter = false;

    public abstract boolean isRecognizedFormat(InputStream var1) throws IOException;

    public abstract List<BibtexEntry> importEntries(InputStream var1, OutputPrinter var2) throws IOException;

    public abstract String getFormatName();

    public String getExtensions() {
        return null;
    }

    public String getCLIId() {
        String id = this.getFormatName();
        StringBuffer result = new StringBuffer(id.length());
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public String getDescription() {
        return "No description available for " + this.getFormatName() + ".";
    }

    public final void setIsCustomImporter(boolean isCustomImporter) {
        this.isCustomImporter = isCustomImporter;
    }

    public final boolean getIsCustomImporter() {
        return this.isCustomImporter;
    }

    public int hashCode() {
        return this.getFormatName().hashCode();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ImportFormat && ((ImportFormat)o).getIsCustomImporter() == this.getIsCustomImporter() && ((ImportFormat)o).getFormatName().equals(this.getFormatName());
    }

    public String toString() {
        return this.getFormatName();
    }

    @Override
    public int compareTo(ImportFormat importer) {
        int result = 0;
        result = this.getIsCustomImporter() == importer.getIsCustomImporter() ? this.getFormatName().compareTo(importer.getFormatName()) : (this.getIsCustomImporter() ? 1 : -1);
        return result;
    }
}

