/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JPanel;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;

public class ADSFetcher
implements EntryFetcher {
    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getHelpPage() {
        return null;
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getKeyName() {
        return "ADS from ADS-DOI";
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle(this.getKeyName());
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        try {
            String key = query = query.replaceAll("^(doi:|DOI:)", "");
            status.setStatus(Globals.lang("Processing ") + key);
            BibtexDatabase bd = this.importADSEntries(key, status);
            status.setStatus("Adding fetched entries");
            if (bd.getEntryCount() > 0) {
                for (BibtexEntry entry : bd.getEntries()) {
                    this.importADSAbstract(key, entry, status);
                    dialog.addEntry(entry);
                }
            }
        }
        catch (Exception e) {
            status.setStatus(Globals.lang("Error while fetching from ADS") + ": " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void stopFetching() {
    }

    public BibtexDatabase importADSEntries(String key, OutputPrinter status) {
        String url = this.constructUrl(key);
        try {
            URL ADSUrl = new URL(url + "&data_type=BIBTEX");
            HttpURLConnection ADSConnection = (HttpURLConnection)ADSUrl.openConnection();
            ADSConnection.setRequestProperty("User-Agent", "Jabref");
            InputStream is = ADSConnection.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ParserResult pr = BibtexParser.parse(reader);
            return pr.getDatabase();
        }
        catch (IOException e) {
            status.showMessage(Globals.lang("An Exception ocurred while accessing '%0'", url) + "\n\n" + e.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException e) {
            status.showMessage(Globals.lang("An Error occurred while fetching from ADS (%0):", new String[]{url}) + "\n\n" + e.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        return null;
    }

    public String constructUrl(String key) {
        return "http://adsabs.harvard.edu/doi/" + key;
    }

    public void importADSAbstract(String key, BibtexEntry entry, OutputPrinter status) {
        String url = this.constructUrl(key);
        try {
            URL ADSUrl = new URL(url + "&data_type=XML");
            HttpURLConnection ADSConnection = (HttpURLConnection)ADSUrl.openConnection();
            ADSConnection.setRequestProperty("User-Agent", "Jabref");
            BufferedInputStream bis = new BufferedInputStream(ADSConnection.getInputStream());
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(bis);
            boolean isAbstract = false;
            String abstractText = "";
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement() && reader.getLocalName() == "abstract") {
                    isAbstract = true;
                }
                if (isAbstract && reader.isCharacters()) {
                    abstractText = abstractText + reader.getText();
                }
                if (!isAbstract || !reader.isEndElement()) continue;
                isAbstract = false;
            }
            abstractText = abstractText.replace("\n", " ");
            entry.setField("abstract", abstractText);
        }
        catch (XMLStreamException e) {
            status.showMessage(Globals.lang("An Error occurred while parsing abstract"), Globals.lang(this.getKeyName()), 0);
        }
        catch (IOException e) {
            status.showMessage(Globals.lang("An Exception ocurred while accessing '%0'", url) + "\n\n" + e.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException e) {
            status.showMessage(Globals.lang("An Error occurred while fetching from ADS (%0):", new String[]{url}) + "\n\n" + e.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
    }
}

