/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.help;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JViewport;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import net.sf.jabref.help.LargeHTMLEditorKit;

public class MyEditorKit
extends LargeHTMLEditorKit {
    private Action[] myActions;

    @Override
    public Action[] getActions() {
        if (this.myActions == null) {
            Action[] actions = super.getActions();
            Action[] newActions = new Action[2];
            for (int i = 0; i < actions.length; ++i) {
                Action actn = actions[i];
                String name = (String)actn.getValue("Name");
                if (name.equals("caret-up")) {
                    newActions[0] = new MyNextVisualPositionAction(actions[i], 1);
                    continue;
                }
                if (!name.equals("caret-down")) continue;
                newActions[1] = new MyNextVisualPositionAction(actions[i], 5);
            }
            this.myActions = TextAction.augmentList(actions, newActions);
        }
        return this.myActions;
    }

    public class MyNextVisualPositionAction
    extends TextAction {
        private Action textActn;
        private int direction;

        private MyNextVisualPositionAction(Action textActn, int direction) {
            super((String)textActn.getValue("Name"));
            this.textActn = textActn;
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent c = this.getTextComponent(e);
            if (c.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)c.getParent();
                Point p = viewport.getViewPosition();
                if (this.direction == 1) {
                    c.setCaretPosition(c.viewToModel(p));
                } else {
                    p.y += viewport.getExtentSize().height;
                    c.setCaretPosition(c.viewToModel(p));
                }
            }
            this.textActn.actionPerformed(e);
        }
    }
}

