/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.AndOrSearchRuleSet;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.UndoableMoveGroup;

public class GroupTreeNode
extends DefaultMutableTreeNode
implements Transferable {
    public static final DataFlavor flavor;
    public static final DataFlavor[] flavors;

    public GroupTreeNode(AbstractGroup group) {
        this.setGroup(group);
    }

    public AbstractGroup getGroup() {
        return (AbstractGroup)this.getUserObject();
    }

    public void setGroup(AbstractGroup group) {
        this.setUserObject(group);
    }

    public String getTreeAsString() {
        StringBuffer sb = new StringBuffer();
        Enumeration<GroupTreeNode> e = this.preorderEnumeration();
        while (e.hasMoreElements()) {
            GroupTreeNode cursor = e.nextElement();
            sb.append(cursor.getLevel()).append(" ").append(cursor.getGroup().toString()).append("\n");
        }
        return sb.toString();
    }

    public GroupTreeNode deepCopy() {
        GroupTreeNode copy = new GroupTreeNode(this.getGroup());
        for (int i = 0; i < this.getChildCount(); ++i) {
            copy.add(((GroupTreeNode)this.getChildAt(i)).deepCopy());
        }
        return copy;
    }

    public void refreshGroupsForNewDatabase(BibtexDatabase db) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            GroupTreeNode node = (GroupTreeNode)this.getChildAt(i);
            node.getGroup().refreshForNewDatabase(db);
            node.refreshGroupsForNewDatabase(db);
        }
    }

    public int[] getIndexedPath() {
        TreeNode[] path = this.getPath();
        int[] indexedPath = new int[path.length - 1];
        for (int i = 1; i < path.length; ++i) {
            indexedPath[i - 1] = path[i - 1].getIndex(path[i]);
        }
        return indexedPath;
    }

    public GroupTreeNode getNode(int[] indexedPath) {
        GroupTreeNode cursor = this;
        for (int i = 0; i < indexedPath.length; ++i) {
            cursor = (GroupTreeNode)cursor.getChildAt(indexedPath[i]);
        }
        return cursor;
    }

    public GroupTreeNode getDescendant(int[] indexedPath) {
        GroupTreeNode cursor = this;
        for (int i = 0; i < indexedPath.length && cursor != null; cursor = (GroupTreeNode)cursor.getChildAt(indexedPath[i]), ++i) {
        }
        return cursor;
    }

    public SearchRule getSearchRule() {
        return this.getSearchRule(this.getGroup().getHierarchicalContext());
    }

    protected SearchRule getSearchRule(int originalContext) {
        int context = this.getGroup().getHierarchicalContext();
        if (context == 0) {
            return this.getGroup().getSearchRule();
        }
        AndOrSearchRuleSet searchRule = new AndOrSearchRuleSet(context == 1, false);
        searchRule.addRule(this.getGroup().getSearchRule());
        if (context == 2 && originalContext != 1) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                searchRule.addRule(((GroupTreeNode)this.getChildAt(i)).getSearchRule(originalContext));
            }
        } else if (context == 1 && !this.isRoot() && originalContext != 2) {
            searchRule.addRule(((GroupTreeNode)this.getParent()).getSearchRule(originalContext));
        }
        return searchRule;
    }

    public Enumeration<GroupTreeNode> preorderEnumeration() {
        return super.preorderEnumeration();
    }

    public Enumeration<GroupTreeNode> depthFirstEnumeration() {
        return super.depthFirstEnumeration();
    }

    public Enumeration<GroupTreeNode> breadthFirstEnumeration() {
        return super.breadthFirstEnumeration();
    }

    public Enumeration<GroupTreeNode> children() {
        return super.children();
    }

    public AbstractGroup[] getMatchingGroups(BibtexEntry entry) {
        Vector<AbstractGroup> matchingGroups = new Vector<AbstractGroup>();
        Enumeration<GroupTreeNode> e = this.preorderEnumeration();
        while (e.hasMoreElements()) {
            AbstractGroup group = e.nextElement().getGroup();
            if (!group.contains(null, entry)) continue;
            matchingGroups.add(group);
        }
        AbstractGroup[] matchingGroupsArray = new AbstractGroup[matchingGroups.size()];
        return matchingGroups.toArray(matchingGroupsArray);
    }

    public boolean canMoveUp() {
        return this.getPreviousSibling() != null && !(this.getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveDown() {
        return this.getNextSibling() != null && !(this.getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveLeft() {
        return !(this.getGroup() instanceof AllEntriesGroup) && !(((GroupTreeNode)this.getParent()).getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveRight() {
        return this.getPreviousSibling() != null && !(this.getGroup() instanceof AllEntriesGroup);
    }

    public AbstractUndoableEdit moveUp(GroupSelector groupSelector) {
        GroupTreeNode myParent = (GroupTreeNode)this.getParent();
        int index = myParent.getIndex(this);
        if (index > 0) {
            UndoableMoveGroup undo = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, myParent, index - 1);
            myParent.insert(this, index - 1);
            return undo;
        }
        return null;
    }

    public AbstractUndoableEdit moveDown(GroupSelector groupSelector) {
        GroupTreeNode myParent = (GroupTreeNode)this.getParent();
        int index = myParent.getIndex(this);
        if (index < this.parent.getChildCount() - 1) {
            UndoableMoveGroup undo = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, myParent, index + 1);
            myParent.insert(this, index + 1);
            return undo;
        }
        return null;
    }

    public AbstractUndoableEdit moveLeft(GroupSelector groupSelector) {
        GroupTreeNode myParent = (GroupTreeNode)this.getParent();
        GroupTreeNode myGrandParent = (GroupTreeNode)myParent.getParent();
        if (myGrandParent == null) {
            return null;
        }
        int index = myGrandParent.getIndex(myParent);
        UndoableMoveGroup undo = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, myGrandParent, index + 1);
        myGrandParent.insert(this, index + 1);
        return undo;
    }

    public AbstractUndoableEdit moveRight(GroupSelector groupSelector) {
        GroupTreeNode myPreviousSibling = (GroupTreeNode)this.getPreviousSibling();
        if (myPreviousSibling == null) {
            return null;
        }
        UndoableMoveGroup undo = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, myPreviousSibling, myPreviousSibling.getChildCount());
        myPreviousSibling.add(this);
        return undo;
    }

    public GroupTreeNode getChildAt(int[] path) {
        GroupTreeNode cursor = this;
        for (int i = 0; i < path.length && cursor != null; cursor = (GroupTreeNode)cursor.getChildAt(path[i]), ++i) {
        }
        return cursor;
    }

    public AbstractUndoableEdit addToGroup(BibtexEntry[] entries) {
        if (this.getGroup() == null) {
            return null;
        }
        AbstractUndoableEdit undo = this.getGroup().add(entries);
        if (undo instanceof UndoableChangeAssignment) {
            ((UndoableChangeAssignment)undo).setEditedNode(this);
        }
        return undo;
    }

    public AbstractUndoableEdit removeFromGroup(BibtexEntry[] entries) {
        if (this.getGroup() == null) {
            return null;
        }
        AbstractUndoableEdit undo = this.getGroup().remove(entries);
        if (undo instanceof UndoableChangeAssignment) {
            ((UndoableChangeAssignment)undo).setEditedNode(this);
        }
        return undo;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor someFlavor) {
        return someFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor someFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(someFlavor)) {
            throw new UnsupportedFlavorException(someFlavor);
        }
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GroupTreeNode)) {
            return false;
        }
        GroupTreeNode otherNode = (GroupTreeNode)other;
        if (this.getChildCount() != otherNode.getChildCount()) {
            return false;
        }
        AbstractGroup g1 = this.getGroup();
        AbstractGroup g2 = otherNode.getGroup();
        if (g1 == null && g2 != null || g1 != null && g2 == null) {
            return false;
        }
        if (g1 != null && g2 != null && !g1.equals(g2)) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i).equals(otherNode.getChildAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getGroup().getName().hashCode();
    }

    static {
        DataFlavor df = null;
        try {
            df = new DataFlavor("application/x-java-jvm-local-objectref;class=net.sf.jabref.groups.GroupTreeNode");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        flavor = df;
        flavors = new DataFlavor[]{flavor};
    }
}

