/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.ExternalFileTypeEntryEditor;
import net.sf.jabref.external.UnknownExternalFileType;
import net.sf.jabref.gui.FileListEditor;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class SynchronizeFileField
extends AbstractWorker {
    private String fieldName = "file";
    private BasePanel panel;
    private BibtexEntry[] sel = null;
    private OptionsDialog optDiag = null;
    Object[] brokenLinkOptions = new Object[]{Globals.lang("Ignore"), Globals.lang("Assign new file"), Globals.lang("Remove link"), Globals.lang("Remove all broken links"), Globals.lang("Quit synchronization")};
    private boolean goOn = true;
    private boolean autoSet = true;
    private boolean checkExisting = true;
    private int brokenLinks = 0;
    private int entriesChangedCount = 0;

    public SynchronizeFileField(BasePanel panel) {
        this.panel = panel;
    }

    @Override
    public void init() {
        Collection<BibtexEntry> col = this.panel.database().getEntries();
        this.goOn = true;
        this.sel = new BibtexEntry[col.size()];
        this.sel = col.toArray(this.sel);
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame(), this.panel.metaData(), this.fieldName);
        }
        Util.placeDialog(this.optDiag, this.panel.frame());
        this.optDiag.setVisible(true);
        if (this.optDiag.canceled()) {
            this.goOn = false;
            return;
        }
        this.autoSet = !this.optDiag.autoSetNone.isSelected();
        this.checkExisting = this.optDiag.checkLinks.isSelected();
        this.panel.output(Globals.lang("Synchronizing %0 links...", this.fieldName.toUpperCase()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (!this.goOn) {
            this.panel.output(Globals.lang("No entries selected."));
            return;
        }
        this.panel.frame().setProgressBarValue(0);
        this.panel.frame().setProgressBarVisible(true);
        int weightAutoSet = 10;
        int progressBarMax = (this.autoSet ? weightAutoSet * this.sel.length : 0) + (this.checkExisting ? this.sel.length : 0);
        this.panel.frame().setProgressBarMaximum(progressBarMax);
        int progress = 0;
        this.brokenLinks = 0;
        NamedCompound ce = new NamedCompound(Globals.lang("Autoset %0 field", this.fieldName));
        String[] dirsS = this.panel.metaData().getFileDirectory("file");
        HashSet<BibtexEntry> changedEntries = new HashSet<BibtexEntry>();
        if (this.autoSet) {
            ArrayList<BibtexEntry> entries = new ArrayList<BibtexEntry>();
            for (int i = 0; i < this.sel.length; ++i) {
                entries.add(this.sel[i]);
            }
            ArrayList<File> dirs = new ArrayList<File>();
            for (int i = 0; i < dirsS.length; ++i) {
                dirs.add(new File(dirsS[i]));
            }
            Thread t = FileListEditor.autoSetLinks(entries, ce, changedEntries, dirs);
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.panel.frame().setProgressBarValue(progress += this.sel.length * weightAutoSet);
        if (this.checkExisting) {
            boolean removeAllBroken = false;
            block10: for (int i = 0; i < this.sel.length; ++i) {
                this.panel.frame().setProgressBarValue(progress++);
                String old = this.sel[i].getField(this.fieldName);
                if (old == null || old.equals("")) continue;
                FileListTableModel tableModel = new FileListTableModel();
                tableModel.setContentDontGuessTypes(old);
                for (int j = 0; j < tableModel.getRowCount(); ++j) {
                    FileListEntry flEntry = tableModel.getEntry(j);
                    boolean httpLink = flEntry.getLink().toLowerCase().startsWith("http");
                    if (httpLink) continue;
                    boolean deleted = false;
                    File file = Util.expandFilename(flEntry.getLink(), dirsS);
                    if (file == null || !file.exists()) {
                        int answer = !removeAllBroken ? JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("<HTML>Could not find file '%0'<BR>linked from entry '%1'</HTML>", new String[]{flEntry.getLink(), this.sel[i].getCiteKey()}), Globals.lang("Broken link"), 1, 3, null, this.brokenLinkOptions, this.brokenLinkOptions[0]) : 2;
                        switch (answer) {
                            case 1: {
                                FileListEntryEditor flEditor = new FileListEntryEditor(this.panel.frame(), flEntry, false, true, this.panel.metaData());
                                flEditor.setVisible(true, true);
                                break;
                            }
                            case 2: {
                                tableModel.removeEntry(j);
                                deleted = true;
                                --j;
                                break;
                            }
                            case 3: {
                                tableModel.removeEntry(j);
                                deleted = true;
                                --j;
                                removeAllBroken = true;
                                break;
                            }
                            case 4: {
                                break block10;
                            }
                        }
                        ++this.brokenLinks;
                    }
                    if (deleted || !(flEntry.getType() instanceof UnknownExternalFileType)) continue;
                    Object[] options = new String[]{Globals.lang("Define '%0'", flEntry.getType().getName()), Globals.lang("Change file type"), Globals.lang("Cancel")};
                    String defOption = options[0];
                    int answer = JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("One or more file links are of the type '%0', which is undefined. What do you want to do?", flEntry.getType().getName()), Globals.lang("Undefined file type"), 1, 3, null, options, defOption);
                    if (answer == 2) continue;
                    if (answer == 0) {
                        ExternalFileType newType = new ExternalFileType(flEntry.getType().getName(), "", "", "", "new");
                        ExternalFileTypeEntryEditor editor = new ExternalFileTypeEntryEditor(this.panel.frame(), newType);
                        editor.setVisible(true);
                        if (!editor.okPressed()) continue;
                        ArrayList<ExternalFileType> fileTypes = new ArrayList<ExternalFileType>();
                        ExternalFileType[] oldTypes = Globals.prefs.getExternalFileTypeSelection();
                        for (int k = 0; k < oldTypes.length; ++k) {
                            fileTypes.add(oldTypes[k]);
                        }
                        fileTypes.add(newType);
                        Collections.sort(fileTypes);
                        Globals.prefs.setExternalFileTypes(fileTypes);
                        this.panel.mainTable.repaint();
                        continue;
                    }
                    FileListEntryEditor editor = new FileListEntryEditor(this.panel.frame(), flEntry, false, true, this.panel.metaData());
                    editor.setVisible(true, false);
                }
                if (tableModel.getStringRepresentation().equals(old)) continue;
                String toSet = tableModel.getStringRepresentation();
                if (toSet.length() == 0) {
                    toSet = null;
                }
                ce.addEdit(new UndoableFieldChange(this.sel[i], this.fieldName, old, toSet));
                this.sel[i].setField(this.fieldName, toSet);
                changedEntries.add(this.sel[i]);
            }
        }
        this.entriesChangedCount = changedEntries.size();
        if (this.entriesChangedCount > 0) {
            ce.end();
            this.panel.undoManager.addEdit(ce);
        }
    }

    @Override
    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Globals.lang("Finished synchronizing %0 links. Entries changed%c %1.", new String[]{this.fieldName.toUpperCase(), String.valueOf(this.entriesChangedCount)}));
        this.panel.frame().setProgressBarVisible(false);
        if (this.entriesChangedCount > 0) {
            this.panel.markBaseChanged();
        }
    }

    static class OptionsDialog
    extends JDialog {
        JRadioButton autoSetUnset;
        JRadioButton autoSetAll;
        JRadioButton autoSetNone;
        JCheckBox checkLinks;
        JButton ok = new JButton(Globals.lang("Ok"));
        JButton cancel = new JButton(Globals.lang("Cancel"));
        JLabel description;
        private boolean canceled = true;
        private MetaData metaData;

        public OptionsDialog(JFrame parent, MetaData metaData, String fieldName) {
            super(parent, Globals.lang("Synchronize %0 links", fieldName.toUpperCase()), true);
            this.metaData = metaData;
            String fn = Globals.lang("file");
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.canceled = false;
                    OptionsDialog.this.dispose();
                }
            });
            AbstractAction closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.dispose();
                }
            };
            this.cancel.addActionListener(closeAction);
            InputMap im = this.cancel.getInputMap(2);
            ActionMap am = this.cancel.getActionMap();
            im.put(Globals.prefs.getKey("Close dialog"), "close");
            am.put("close", closeAction);
            this.autoSetUnset = new JRadioButton(Globals.lang("Autoset %0 links. Do not overwrite existing links.", fn), true);
            this.autoSetAll = new JRadioButton(Globals.lang("Autoset %0 links. Allow overwriting existing links.", fn), false);
            this.autoSetNone = new JRadioButton(Globals.lang("Do not autoset"), false);
            this.checkLinks = new JCheckBox(Globals.lang("Check existing %0 links", fn), true);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.autoSetUnset);
            bg.add(this.autoSetNone);
            bg.add(this.autoSetAll);
            FormLayout layout = new FormLayout("fill:pref", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            this.description = new JLabel("<HTML>" + Globals.lang("Attempt to autoset %0 links for your entries. Autoset works if a %0 file in your %0 directory or a subdirectory<BR>is named identically to an entry's BibTeX key, plus extension.", fn) + "</HTML>");
            builder.appendSeparator(Globals.lang("Autoset"));
            builder.append(this.description);
            builder.nextLine();
            builder.append(this.autoSetUnset);
            builder.nextLine();
            builder.append(this.autoSetAll);
            builder.nextLine();
            builder.append(this.autoSetNone);
            builder.nextLine();
            builder.appendSeparator(Globals.lang("Check links"));
            this.description = new JLabel("<HTML>" + Globals.lang("This makes JabRef look up each %0 extension and check if the file exists. If not, you will be given options<BR>to resolve the problem.", fn) + "</HTML>");
            builder.append(this.description);
            builder.nextLine();
            builder.append(this.checkLinks);
            builder.nextLine();
            builder.appendSeparator();
            JPanel main = builder.getPanel();
            main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addButton((JComponent)this.ok);
            bb.addButton((JComponent)this.cancel);
            bb.addGlue();
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bb.getPanel(), "South");
            this.pack();
        }

        @Override
        public void setVisible(boolean visible) {
            String[] dirs;
            if (visible) {
                this.canceled = true;
            }
            if ((dirs = this.metaData.getFileDirectory("file")).length == 0) {
                this.autoSetNone.setSelected(true);
                this.autoSetNone.setEnabled(false);
                this.autoSetAll.setEnabled(false);
                this.autoSetUnset.setEnabled(false);
            } else {
                this.autoSetNone.setEnabled(true);
                this.autoSetAll.setEnabled(true);
                this.autoSetUnset.setEnabled(true);
            }
            new FocusRequester(this.ok);
            super.setVisible(visible);
        }

        public boolean canceled() {
            return this.canceled;
        }
    }
}

