/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.external.PushToApplication;

public class PushToWinEdt
implements PushToApplication {
    private boolean couldNotCall = false;
    private boolean notDefined = false;
    private JPanel settings = null;
    private JTextField winEdtPath = new JTextField(30);
    private JTextField citeCommand = new JTextField(30);

    @Override
    public String getName() {
        return Globals.lang("Insert selected citations into WinEdt");
    }

    @Override
    public String getApplicationName() {
        return "WinEdt";
    }

    @Override
    public String getTooltip() {
        return Globals.lang("Push selection to WinEdt");
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("winedt");
    }

    @Override
    public String getKeyStrokeName() {
        return "Push to WinEdt";
    }

    @Override
    public void pushEntries(BibtexDatabase database, BibtexEntry[] entries, String keyString, MetaData metaData) {
        this.couldNotCall = false;
        this.notDefined = false;
        String winEdt = Globals.prefs.get("winEdtPath");
        if (winEdt == null || winEdt.trim().length() == 0) {
            this.notDefined = true;
            return;
        }
        try {
            StringBuffer toSend = new StringBuffer("\"[InsText('").append(Globals.prefs.get("citeCommandWinEdt")).append("{").append(keyString.replaceAll("'", "''")).append("}');]\"");
            Runtime.getRuntime().exec(winEdt + " " + toSend.toString());
        }
        catch (IOException excep) {
            this.couldNotCall = true;
            excep.printStackTrace();
        }
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.notDefined) {
            panel.output(Globals.lang("Error") + ": " + Globals.lang("Path to %0 not defined", this.getApplicationName()) + ".");
        } else if (this.couldNotCall) {
            panel.output(Globals.lang("Error") + ": " + Globals.lang("Could not call executable") + " '" + Globals.prefs.get("winEdtPath") + "'.");
        } else {
            Globals.lang("Pushed citations to WinEdt");
        }
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settings == null) {
            this.initSettingsPanel();
        }
        this.winEdtPath.setText(Globals.prefs.get("winEdtPath"));
        this.citeCommand.setText(Globals.prefs.get("citeCommandWinEdt"));
        return this.settings;
    }

    private void initSettingsPanel() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref, 4dlu, fill:pref", ""));
        builder.append(new JLabel(Globals.lang("Path to WinEdt.exe") + ":"));
        builder.append(this.winEdtPath);
        BrowseAction action = new BrowseAction(null, this.winEdtPath, false);
        JButton browse = new JButton(Globals.lang("Browse"));
        browse.addActionListener(action);
        builder.append(browse);
        builder.nextLine();
        builder.append(Globals.lang("Cite command") + ":");
        builder.append(this.citeCommand);
        this.settings = builder.getPanel();
    }

    @Override
    public void storeSettings() {
        Globals.prefs.put("winEdtPath", this.winEdtPath.getText());
        Globals.prefs.put("citeCommandWinEdt", this.citeCommand.getText());
    }
}

