/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.LayoutFormatter;

public class XMLChars
implements LayoutFormatter {
    Pattern pattern = Pattern.compile(".*\\{\\\\.*[a-zA-Z]\\}.*");
    boolean[] forceReplace;

    @Override
    public String format(String fieldText) {
        fieldText = this.firstFormat(fieldText);
        for (Map.Entry<String, String> entry : Globals.XML_CHARS.entrySet()) {
            String s = entry.getKey();
            String repl = entry.getValue();
            if (repl == null) continue;
            fieldText = fieldText.replaceAll(s, repl);
        }
        return this.restFormat(fieldText);
    }

    private String firstFormat(String s) {
        return s.replaceAll("&|\\\\&", "&#x0026;").replaceAll("--", "&#x2013;");
    }

    private String restFormat(String toFormat) {
        String fieldText = toFormat.replaceAll("\\}", "").replaceAll("\\{", "");
        if (this.forceReplace == null) {
            this.forceReplace = new boolean[126];
            for (int i = 0; i < 40; ++i) {
                this.forceReplace[i] = true;
            }
            this.forceReplace[32] = false;
            for (int i : new int[]{44, 45, 63, 64, 94, 95, 96, 124}) {
                this.forceReplace[i] = true;
            }
        }
        StringBuffer buffer = new StringBuffer(fieldText.length() * 2);
        for (int i = 0; i < fieldText.length(); ++i) {
            char code = fieldText.charAt(i);
            if (code == '&' && fieldText.charAt(i + 1) == '#') {
                buffer.append("&#");
                code = fieldText.charAt(i += 2);
            }
            if (code > '}' || this.forceReplace[code]) {
                buffer.append("&#" + code + ";");
                continue;
            }
            buffer.append(code);
        }
        fieldText = buffer.toString();
        for (Map.Entry<String, String> entry : Globals.ASCII2XML_CHARS.entrySet()) {
            String s = entry.getKey();
            String repl = entry.getValue();
            if (repl == null) continue;
            fieldText = fieldText.replaceAll(s, repl);
        }
        return fieldText;
    }
}

