/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.LayoutFormatter;

public class RemoveLatexCommands
implements LayoutFormatter {
    int i;

    @Override
    public String format(String field) {
        StringBuffer sb = new StringBuffer("");
        StringBuffer currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        this.i = 0;
        while (this.i < field.length()) {
            char c = field.charAt(this.i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
                incommand = true;
                currentCommand = new StringBuffer();
            } else if (incommand || c != '{' && c != '}') {
                if (Character.isLetter(c) || Globals.SPECIAL_COMMAND_CHARS.indexOf("" + c) >= 0) {
                    escaped = false;
                    if (!incommand) {
                        sb.append(c);
                    } else {
                        currentCommand.append(c);
                        if (currentCommand.length() == 1 && Globals.SPECIAL_COMMAND_CHARS.indexOf(currentCommand.toString()) >= 0) {
                            incommand = false;
                            escaped = false;
                        }
                    }
                } else if (Character.isLetter(c)) {
                    escaped = false;
                    if (!incommand) {
                        sb.append(c);
                    } else {
                        currentCommand.append(c);
                    }
                } else {
                    if (!incommand || !Character.isWhitespace(c) && c != '{') {
                        sb.append(c);
                    } else if (c != '{') {
                        sb.append(c);
                    }
                    incommand = false;
                    escaped = false;
                }
            }
            ++this.i;
        }
        return sb.toString();
    }
}

