/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class EntryDeleteChange
extends Change {
    BibtexEntry memEntry;
    BibtexEntry tmpEntry;
    BibtexEntry diskEntry;
    boolean isModifiedLocally;
    double matchWithTmp;
    PreviewPanel pp;
    JScrollPane sp;

    public EntryDeleteChange(BibtexEntry memEntry, BibtexEntry tmpEntry) {
        super("Deleted entry");
        this.memEntry = memEntry;
        this.tmpEntry = tmpEntry;
        this.matchWithTmp = DuplicateCheck.compareEntriesStrictly(memEntry, tmpEntry);
        this.isModifiedLocally = !(this.matchWithTmp > 1.0);
        this.pp = new PreviewPanel(null, memEntry, null, new MetaData(), Globals.prefs.get("preview0"));
        this.sp = new JScrollPane(this.pp);
    }

    @Override
    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        panel.database().removeEntry(this.memEntry.getId());
        undoEdit.addEdit(new UndoableRemoveEntry(panel.database(), this.memEntry, panel));
        secondary.removeEntry(this.tmpEntry.getId());
        return true;
    }

    @Override
    JComponent description() {
        return this.sp;
    }
}

