/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;

public class EntryEditorPrefsTab
extends JPanel
implements PrefsTab {
    private JCheckBox autoOpenForm;
    private JCheckBox showSource;
    private JCheckBox defSource;
    private JCheckBox editSource;
    private JCheckBox disableOnMultiple;
    private JCheckBox autoComplete;
    private JRadioButton autoCompBoth;
    private JRadioButton autoCompFF;
    private JRadioButton autoCompLF;
    private JRadioButton autoCompFirstNameMode_Full;
    private JRadioButton autoCompFirstNameMode_Abbr;
    private JRadioButton autoCompFirstNameMode_Both;
    boolean oldAutoCompFF;
    boolean oldAutoCompLF;
    boolean oldAutoCompFModeAbbr;
    boolean oldAutoCompFModeFull;
    private JSpinner shortestToComplete;
    private JTextField autoCompFields;
    JabRefPreferences _prefs;
    JabRefFrame _frame;

    private void setAutoCompleteElementsEnabled(boolean enabled) {
        this.autoCompFields.setEnabled(enabled);
        this.autoCompLF.setEnabled(enabled);
        this.autoCompFF.setEnabled(enabled);
        this.autoCompBoth.setEnabled(enabled);
        this.autoCompFirstNameMode_Abbr.setEnabled(enabled);
        this.autoCompFirstNameMode_Full.setEnabled(enabled);
        this.autoCompFirstNameMode_Both.setEnabled(enabled);
        this.shortestToComplete.setEnabled(enabled);
    }

    public EntryEditorPrefsTab(JabRefFrame frame, JabRefPreferences prefs) {
        this._prefs = prefs;
        this._frame = frame;
        this.setLayout(new BorderLayout());
        this.autoOpenForm = new JCheckBox(Globals.lang("Open editor when a new entry is created"));
        this.defSource = new JCheckBox(Globals.lang("Show BibTeX source by default"));
        this.showSource = new JCheckBox(Globals.lang("Show BibTeX source panel"));
        this.editSource = new JCheckBox(Globals.lang("Enable source editing"));
        this.disableOnMultiple = new JCheckBox(Globals.lang("Disable entry editor when multiple entries are selected"));
        this.autoComplete = new JCheckBox(Globals.lang("Enable word/name autocompletion"));
        this.shortestToComplete = new JSpinner(new SpinnerNumberModel(prefs.getInt("shortestToComplete"), 1, 5, 1));
        this.autoCompFF = new JRadioButton(Globals.lang("Autocomplete names in 'Firstname Lastname' format only"));
        this.autoCompLF = new JRadioButton(Globals.lang("Autocomplete names in 'Lastname, Firstname' format only"));
        this.autoCompBoth = new JRadioButton(Globals.lang("Autocomplete names in both formats"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.autoCompLF);
        bg.add(this.autoCompFF);
        bg.add(this.autoCompBoth);
        this.autoCompFirstNameMode_Full = new JRadioButton(Globals.lang("Use full firstname whenever possible"));
        this.autoCompFirstNameMode_Abbr = new JRadioButton(Globals.lang("Use abbreviated firstname whenever possible"));
        this.autoCompFirstNameMode_Both = new JRadioButton(Globals.lang("Use abbreviated and full firstname"));
        ButtonGroup bg_firstNameMode = new ButtonGroup();
        bg_firstNameMode.add(this.autoCompFirstNameMode_Full);
        bg_firstNameMode.add(this.autoCompFirstNameMode_Abbr);
        bg_firstNameMode.add(this.autoCompFirstNameMode_Both);
        this.autoCompFields = new JTextField(40);
        Insets marg = new Insets(0, 12, 3, 0);
        this.editSource.setMargin(marg);
        this.defSource.setMargin(marg);
        this.showSource.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                EntryEditorPrefsTab.this.defSource.setEnabled(EntryEditorPrefsTab.this.showSource.isSelected());
                EntryEditorPrefsTab.this.editSource.setEnabled(EntryEditorPrefsTab.this.showSource.isSelected());
            }
        });
        this.autoComplete.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                EntryEditorPrefsTab.this.setAutoCompleteElementsEnabled(EntryEditorPrefsTab.this.autoComplete.isSelected());
            }
        });
        FormLayout layout = new FormLayout("8dlu, left:pref, 8dlu, fill:150dlu, 4dlu, fill:pref", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, pref, pref, pref, 6dlu, pref, pref, pref, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Globals.lang("Editor options"), cc.xyw(1, 1, 5));
        builder.add((Component)this.autoOpenForm, cc.xy(2, 3));
        builder.add((Component)this.disableOnMultiple, cc.xy(2, 5));
        builder.add((Component)this.showSource, cc.xy(2, 7));
        builder.add((Component)this.defSource, cc.xy(2, 9));
        builder.addSeparator(Globals.lang("Autocompletion options"), cc.xyw(1, 11, 5));
        builder.add((Component)this.autoComplete, cc.xy(2, 13));
        DefaultFormBuilder builder3 = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:150dlu", ""));
        JLabel label = new JLabel(Globals.lang("Use autocompletion for the following fields") + ":");
        builder3.append(label);
        builder3.append(this.autoCompFields);
        JLabel label2 = new JLabel(Globals.lang("Autocomplete after following number of characters") + ":");
        builder3.append(label2);
        builder3.append(this.shortestToComplete);
        builder.add((Component)builder3.getPanel(), cc.xyw(2, 15, 3));
        builder.addSeparator(Globals.lang("Name format used for autocompletion"), cc.xyw(2, 17, 4));
        builder.add((Component)this.autoCompFF, cc.xy(2, 18));
        builder.add((Component)this.autoCompLF, cc.xy(2, 19));
        builder.add((Component)this.autoCompBoth, cc.xy(2, 20));
        builder.addSeparator(Globals.lang("Treatment of first names"), cc.xyw(2, 22, 4));
        builder.add((Component)this.autoCompFirstNameMode_Abbr, cc.xy(2, 23));
        builder.add((Component)this.autoCompFirstNameMode_Full, cc.xy(2, 24));
        builder.add((Component)this.autoCompFirstNameMode_Both, cc.xy(2, 25));
        JPanel pan = builder.getPanel();
        pan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)pan, "Center");
    }

    @Override
    public void setValues() {
        this.autoOpenForm.setSelected(this._prefs.getBoolean("autoOpenForm"));
        this.defSource.setSelected(this._prefs.getBoolean("defaultShowSource"));
        this.showSource.setSelected(this._prefs.getBoolean("showSource"));
        this.editSource.setSelected(this._prefs.getBoolean("enableSourceEditing"));
        this.disableOnMultiple.setSelected(this._prefs.getBoolean("disableOnMultipleSelection"));
        this.autoComplete.setSelected(this._prefs.getBoolean("autoComplete"));
        this.autoCompFields.setText(this._prefs.get("autoCompleteFields"));
        this.shortestToComplete.setValue(this._prefs.getInt("shortestToComplete"));
        if (this._prefs.getBoolean("autoCompFF")) {
            this.autoCompFF.setSelected(true);
        } else if (this._prefs.getBoolean("autoCompLF")) {
            this.autoCompLF.setSelected(true);
        } else {
            this.autoCompBoth.setSelected(true);
        }
        this.oldAutoCompFF = this.autoCompFF.isSelected();
        this.oldAutoCompLF = this.autoCompLF.isSelected();
        if (this._prefs.get("autoCompFirstNameMode").equals("abbrOnly")) {
            this.autoCompFirstNameMode_Abbr.setSelected(true);
        } else if (this._prefs.get("autoCompFirstNameMode").equals("fullOnly")) {
            this.autoCompFirstNameMode_Full.setSelected(true);
        } else {
            this.autoCompFirstNameMode_Both.setSelected(true);
        }
        this.oldAutoCompFModeAbbr = this.autoCompFirstNameMode_Abbr.isSelected();
        this.oldAutoCompFModeFull = this.autoCompFirstNameMode_Full.isSelected();
        this.defSource.setEnabled(this.showSource.isSelected());
        this.editSource.setEnabled(this.showSource.isSelected());
        this.setAutoCompleteElementsEnabled(this.autoComplete.isSelected());
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("autoOpenForm", this.autoOpenForm.isSelected());
        this._prefs.putBoolean("defaultShowSource", this.defSource.isSelected());
        this._prefs.putBoolean("enableSourceEditing", this.editSource.isSelected());
        this._prefs.putBoolean("disableOnMultipleSelection", this.disableOnMultiple.isSelected());
        boolean oldAutoComplete = this._prefs.getBoolean("autoComplete");
        boolean oldShowSource = this._prefs.getBoolean("showSource");
        String oldAutoCompFields = this._prefs.get("autoCompleteFields");
        this._prefs.putInt("shortestToComplete", (Integer)this.shortestToComplete.getValue());
        this._prefs.putBoolean("autoComplete", this.autoComplete.isSelected());
        this._prefs.put("autoCompleteFields", this.autoCompFields.getText());
        this._prefs.putBoolean("showSource", this.showSource.isSelected());
        if (this.autoCompBoth.isSelected()) {
            this._prefs.putBoolean("autoCompFF", false);
            this._prefs.putBoolean("autoCompLF", false);
        } else if (this.autoCompFF.isSelected()) {
            this._prefs.putBoolean("autoCompFF", true);
            this._prefs.putBoolean("autoCompLF", false);
        } else {
            this._prefs.putBoolean("autoCompFF", false);
            this._prefs.putBoolean("autoCompLF", true);
        }
        if (this.autoCompFirstNameMode_Abbr.isSelected()) {
            this._prefs.put("autoCompFirstNameMode", "abbrOnly");
        } else if (this.autoCompFirstNameMode_Full.isSelected()) {
            this._prefs.put("autoCompFirstNameMode", "fullOnly");
        } else {
            this._prefs.put("autoCompFirstNameMode", "both");
        }
        if (oldShowSource != this.showSource.isSelected() || oldAutoComplete != this.autoComplete.isSelected() || !oldAutoCompFields.equals(this.autoCompFields.getText()) || this.oldAutoCompFF != this.autoCompFF.isSelected() || this.oldAutoCompLF != this.autoCompLF.isSelected() || this.oldAutoCompFModeAbbr != this.autoCompFirstNameMode_Abbr.isSelected() || this.oldAutoCompFModeFull != this.autoCompFirstNameMode_Full.isSelected()) {
            for (int j = 0; j < this._frame.getTabbedPane().getTabCount(); ++j) {
                BasePanel bp = (BasePanel)this._frame.getTabbedPane().getComponentAt(j);
                bp.entryEditors.clear();
            }
        }
        AbstractAutoCompleter.SHORTEST_TO_COMPLETE = (Integer)this.shortestToComplete.getValue();
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Entry editor");
    }
}

