/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.tree;

import org.eclipse.core.internal.databinding.observable.tree.TreeDiffVisitor;
import org.eclipse.core.internal.databinding.observable.tree.TreePath;

public abstract class TreeDiffNode {
    public static final int NO_CHANGE = 0;
    public static final int ADDED = 1;
    public static final int REMOVED = 2;
    public static final int REPLACED = 3;
    public static final TreeDiffNode[] NO_CHILDREN = new TreeDiffNode[0];
    public static final int INDEX_UNKNOWN = -1;

    public abstract int getChangeType();

    public abstract Object getOldElement();

    public abstract Object getNewElement();

    public abstract int getIndex();

    public abstract TreeDiffNode[] getChildren();

    protected void doAccept(TreeDiffVisitor visitor, TreePath parentPath) {
        TreePath currentPath = parentPath.createChildPath(this.getNewElement());
        boolean recurse = visitor.visit(this, currentPath);
        if (recurse) {
            TreeDiffNode[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                TreeDiffNode child = children[i];
                child.doAccept(visitor, currentPath);
                ++i;
            }
        }
    }
}

