/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist.dao;

import com.db4o.query.Query;
import java.util.List;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.Preference;
import org.rssowl.core.internal.persist.dao.AbstractEntityDAO;
import org.rssowl.core.persist.IPreference;
import org.rssowl.core.persist.dao.IPreferenceDAO;
import org.rssowl.core.persist.event.PreferenceEvent;
import org.rssowl.core.persist.event.PreferenceListener;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.persist.service.UniqueConstraintException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesDAOImpl
extends AbstractEntityDAO<IPreference, PreferenceListener, PreferenceEvent>
implements IPreferenceDAO {
    public PreferencesDAOImpl() {
        super(Preference.class, true);
    }

    @Override
    protected void doSave(IPreference entity) {
        IPreference pref = this.load(entity.getKey());
        if (pref != null && pref != entity) {
            throw new UniqueConstraintException("key", entity);
        }
        super.doSave(entity);
    }

    @Override
    public boolean delete(String key) throws PersistenceException {
        List<IPreference> preferences = this.loadAll(key);
        if (preferences == null || preferences.isEmpty()) {
            return false;
        }
        for (IPreference pref : preferences) {
            this.delete(pref);
        }
        return true;
    }

    @Override
    protected PreferenceEvent createDeleteEventTemplate(IPreference entity) {
        return null;
    }

    @Override
    protected PreferenceEvent createSaveEventTemplate(IPreference entity) {
        return null;
    }

    @Override
    public IPreference load(String key) throws PersistenceException {
        List<IPreference> prefs = this.loadAll(key);
        if (!prefs.isEmpty()) {
            return prefs.iterator().next();
        }
        return null;
    }

    private List<IPreference> loadAll(String key) {
        Query query = this.fDb.query();
        query.constrain((Object)this.fEntityClass);
        query.descend("fKey").constrain((Object)key);
        List<IPreference> prefs = this.getList(query);
        this.activateAll(prefs);
        return prefs;
    }

    @Override
    public IPreference loadOrCreate(String key) throws PersistenceException {
        IPreference pref = this.load(key);
        if (pref == null) {
            return Owl.getModelFactory().createPreference(key);
        }
        return pref;
    }
}

