/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.rssowl.core.internal.persist.Messages;
import org.rssowl.core.internal.persist.SearchValueType;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.ISearchValueType;
import org.rssowl.core.util.CoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchField
implements ISearchField {
    private int fField;
    private String fEntityName;

    public SearchField(int field, String entityName) {
        this.fField = field;
        Assert.isNotNull((Object)entityName, (String)"The type SearchField requires a entityName that is not NULL");
        this.fEntityName = entityName;
    }

    protected SearchField() {
    }

    @Override
    public synchronized int getId() {
        return this.fField;
    }

    @Override
    public synchronized String getEntityName() {
        return this.fEntityName;
    }

    @Override
    public synchronized String getName() {
        if (this.fEntityName.equals(IAttachment.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_ATTACHMENT;
                }
                case 0: {
                    return Messages.SearchField_LINK;
                }
                case 2: {
                    return Messages.SearchField_SIZE;
                }
                case 1: {
                    return Messages.SearchField_TYPE;
                }
            }
        }
        if (this.fEntityName.equals(IFolder.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_FOLDER;
                }
                case 0: {
                    return Messages.SearchField_NAME;
                }
                case 1: {
                    return Messages.SearchField_BLOGROLL_LINK;
                }
                case 3: {
                    return Messages.SearchField_SUB_FOLDERS;
                }
                case 2: {
                    return Messages.SearchField_BOOKMARKS;
                }
            }
        }
        if (this.fEntityName.equals(ILabel.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_LABEL;
                }
                case 0: {
                    return Messages.SearchField_NAME;
                }
                case 1: {
                    return Messages.SearchField_COLOR;
                }
            }
        }
        if (this.fEntityName.equals(ICategory.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_CATEGORY;
                }
                case 0: {
                    return Messages.SearchField_NAME;
                }
                case 1: {
                    return Messages.SearchField_DOMAIN;
                }
            }
        }
        if (this.fEntityName.equals(IBookMark.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_BOOKMARK;
                }
                case 1: {
                    return Messages.SearchField_CREATION_DATE;
                }
                case 0: {
                    return Messages.SearchField_NAME;
                }
                case 2: {
                    return Messages.SearchField_LAST_VISIT;
                }
                case 3: {
                    return Messages.SearchField_NUMBER_OF_VISITS;
                }
                case 4: {
                    return Messages.SearchField_ERROR_LOADING;
                }
            }
        }
        if (this.fEntityName.equals(ISearchMark.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_SEARCHMARK;
                }
                case 1: {
                    return Messages.SearchField_CREATION_DATE;
                }
                case 0: {
                    return Messages.SearchField_NAME;
                }
                case 2: {
                    return Messages.SearchField_LAST_VISIT;
                }
                case 3: {
                    return Messages.SearchField_NUMBER_OF_VISITS;
                }
            }
        }
        if (this.fEntityName.equals(IPerson.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_PERSON;
                }
                case 0: {
                    return Messages.SearchField_NAME;
                }
                case 2: {
                    return Messages.SearchField_EMAIL;
                }
                case 1: {
                    return Messages.SearchField_URI;
                }
            }
        }
        if (this.fEntityName.equals(INews.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_NEWS;
                }
                case 0: {
                    return Messages.SearchField_TITLE;
                }
                case 1: {
                    return Messages.SearchField_LINK;
                }
                case 2: {
                    return Messages.SearchField_DESCRIPTION;
                }
                case 6: {
                    return Messages.SearchField_PUBLISH_DATE;
                }
                case 7: {
                    return Messages.SearchField_MODIFIED_DATE;
                }
                case 8: {
                    return Messages.SearchField_RECEIVED_DATE;
                }
                case 3: {
                    return Messages.SearchField_AUTHOR;
                }
                case 4: {
                    return Messages.SearchField_COMMENTS;
                }
                case 5: {
                    return Messages.SearchField_GUID;
                }
                case 9: {
                    return Messages.SearchField_SOURCE;
                }
                case 10: {
                    return Messages.SearchField_HAS_ATTACHMENT;
                }
                case 11: {
                    return Messages.SearchField_ATTACHMENT;
                }
                case 12: {
                    return Messages.SearchField_CATEGORY;
                }
                case 13: {
                    return Messages.SearchField_IS_STICKY;
                }
                case 14: {
                    return Messages.SearchField_STATE_OF_NEWS;
                }
                case 15: {
                    return Messages.SearchField_LABEL;
                }
                case 16: {
                    return Messages.SearchField_RATING;
                }
                case 17: {
                    return Messages.SearchField_FEED;
                }
                case 18: {
                    return Messages.SearchField_AGE;
                }
                case 21: {
                    return Messages.SearchField_AGE;
                }
                case 19: {
                    return Messages.SearchField_LOCATION;
                }
            }
        }
        if (this.fEntityName.equals(IFeed.class.getName())) {
            switch (this.fField) {
                case -1: {
                    return Messages.SearchField_ENTIRE_NEWS;
                }
                case 0: {
                    return Messages.SearchField_LINK;
                }
                case 1: {
                    return Messages.SearchField_TITLE;
                }
                case 2: {
                    return Messages.SearchField_PUBLISH_DATE;
                }
                case 3: {
                    return Messages.SearchField_DESCRIPTION;
                }
                case 4: {
                    return Messages.SearchField_HOMEPAGE;
                }
                case 5: {
                    return Messages.SearchField_LANGUAGE;
                }
                case 6: {
                    return Messages.SearchField_COPYRIGHT;
                }
                case 7: {
                    return Messages.SearchField_DOCS;
                }
                case 8: {
                    return Messages.SearchField_GENERATOR;
                }
                case 9: {
                    return Messages.SearchField_LAST_BUILT_DATE;
                }
                case 10: {
                    return Messages.SearchField_WEBMASTER;
                }
                case 11: {
                    return Messages.SearchField_LAST_MODIFIED_DATE;
                }
                case 12: {
                    return Messages.SearchField_TIME_TO_LIVE;
                }
                case 13: {
                    return Messages.SearchField_FORMAT;
                }
                case 15: {
                    return Messages.SearchField_AUTHOR;
                }
                case 16: {
                    return Messages.SearchField_NUMBER_OF_NEWS;
                }
                case 17: {
                    return Messages.SearchField_CATEGORY;
                }
                case 14: {
                    return Messages.SearchField_IMAGE;
                }
            }
        }
        return String.valueOf(this.fEntityName) + "#" + this.fField;
    }

    @Override
    public synchronized ISearchValueType getSearchValueType() {
        if (this.fEntityName.equals(IAttachment.class.getName())) {
            switch (this.fField) {
                case 2: {
                    return SearchValueType.INTEGER;
                }
                case 0: {
                    return SearchValueType.LINK;
                }
            }
        } else if (this.fEntityName.equals(IFolder.class.getName())) {
            switch (this.fField) {
                case 3: {
                    return SearchValueType.INTEGER;
                }
                case 2: {
                    return SearchValueType.INTEGER;
                }
            }
        } else if (this.fEntityName.equals(IBookMark.class.getName())) {
            switch (this.fField) {
                case 1: {
                    return SearchValueType.DATETIME;
                }
                case 2: {
                    return SearchValueType.DATETIME;
                }
                case 3: {
                    return SearchValueType.INTEGER;
                }
                case 4: {
                    return SearchValueType.BOOLEAN;
                }
            }
        } else if (this.fEntityName.equals(ISearchMark.class.getName())) {
            switch (this.fField) {
                case 1: {
                    return SearchValueType.DATETIME;
                }
                case 2: {
                    return SearchValueType.DATETIME;
                }
                case 3: {
                    return SearchValueType.INTEGER;
                }
            }
        } else {
            if (this.fEntityName.equals(IPerson.class.getName())) {
                return SearchValueType.STRING;
            }
            if (this.fEntityName.equals(ILabel.class.getName())) {
                return SearchValueType.STRING;
            }
            if (this.fEntityName.equals(ICategory.class.getName())) {
                return SearchValueType.STRING;
            }
            if (this.fEntityName.equals(INews.class.getName())) {
                switch (this.fField) {
                    case 6: {
                        return SearchValueType.DATETIME;
                    }
                    case 7: {
                        return SearchValueType.DATETIME;
                    }
                    case 8: {
                        return SearchValueType.DATETIME;
                    }
                    case 13: {
                        return SearchValueType.BOOLEAN;
                    }
                    case 14: {
                        return new SearchValueType(this.loadStateValues());
                    }
                    case 15: {
                        return new SearchValueType(this.loadLabelValues());
                    }
                    case 16: {
                        return SearchValueType.INTEGER;
                    }
                    case 1: {
                        return SearchValueType.LINK;
                    }
                    case 17: {
                        return SearchValueType.LINK;
                    }
                    case 18: {
                        return SearchValueType.INTEGER;
                    }
                    case 21: {
                        return SearchValueType.INTEGER;
                    }
                    case 9: {
                        return SearchValueType.LINK;
                    }
                    case 10: {
                        return SearchValueType.BOOLEAN;
                    }
                }
            } else if (this.fEntityName.equals(IFeed.class.getName())) {
                switch (this.fField) {
                    case 0: {
                        return SearchValueType.LINK;
                    }
                    case 2: {
                        return SearchValueType.DATETIME;
                    }
                    case 5: {
                        return new SearchValueType(this.loadLanguageValues());
                    }
                    case 9: {
                        return SearchValueType.DATETIME;
                    }
                    case 11: {
                        return SearchValueType.DATETIME;
                    }
                    case 12: {
                        return SearchValueType.INTEGER;
                    }
                    case 16: {
                        return SearchValueType.INTEGER;
                    }
                }
            }
        }
        return SearchValueType.STRING;
    }

    private List<String> loadStateValues() {
        return new ArrayList<String>(Arrays.asList(Messages.SearchField_NEW, Messages.SearchField_READ, Messages.SearchField_UNREAD, Messages.SearchField_UPDATED, Messages.SearchField_DELETED));
    }

    private List<String> loadLanguageValues() {
        return new ArrayList<String>();
    }

    private List<String> loadLabelValues() {
        Set<ILabel> labels = CoreUtils.loadSortedLabels();
        ArrayList<String> values = new ArrayList<String>(labels.size());
        for (ILabel label : labels) {
            values.add(label.getName());
        }
        return values;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Object object = obj;
        synchronized (object) {
            SearchField f = (SearchField)obj;
            return this.fField == f.fField && this.fEntityName.equals(f.fEntityName);
        }
    }

    public synchronized int hashCode() {
        int typeHashCode = this.fEntityName == null ? 0 : this.fEntityName.hashCode();
        return ((this.fField + 2) * typeHashCode + 17) * 37;
    }

    public synchronized String toString() {
        return String.valueOf(this.fEntityName) + ": " + this.fField;
    }

    public synchronized String toLongString() {
        return String.valueOf(super.toString()) + "(Field = " + this.fField + ", Class = " + this.fEntityName + ", Name = " + this.getName() + ", Search-Value-Type = " + this.getSearchValueType() + ")";
    }
}

