/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.internal.persist.ComplexMergeResult;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.reference.PersonReference;
import org.rssowl.core.util.MergeUtils;

public class Person
extends AbstractEntity
implements IPerson {
    private String fName;
    private String fUri;
    private String fEmail;

    public Person(Long id) {
        super(id);
    }

    protected Person() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Person(IPerson author) {
        IPerson iPerson = author;
        synchronized (iPerson) {
            this.setName(author.getName());
            this.setUri(author.getUri());
            this.setEmail(author.getEmail());
        }
    }

    public synchronized void setName(String name) {
        this.fName = name;
    }

    public synchronized void setUri(URI uri) {
        this.fUri = this.getURIText(uri);
    }

    public synchronized void setEmail(URI email) {
        this.fEmail = this.getURIText(email);
    }

    public synchronized String getName() {
        return this.fName;
    }

    public synchronized URI getUri() {
        return this.createURI(this.fUri);
    }

    public synchronized URI getEmail() {
        return this.createURI(this.fEmail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MergeResult merge(IPerson objectToMerge) {
        Assert.isNotNull((Object)objectToMerge);
        IPerson iPerson = objectToMerge;
        synchronized (iPerson) {
            boolean updated = !this.isSimpleFieldsEqual(objectToMerge);
            this.fName = objectToMerge.getName();
            this.setUri(objectToMerge.getUri());
            this.setEmail(objectToMerge.getEmail());
            ComplexMergeResult<?> mergeResult = MergeUtils.mergeProperties(this, objectToMerge);
            if (updated || mergeResult.isStructuralChange()) {
                mergeResult.addUpdatedObject(this);
            }
            return mergeResult;
        }
    }

    private boolean isSimpleFieldsEqual(IPerson person) {
        return MergeUtils.equals(this.fName, person.getName()) && MergeUtils.equals(this.getUri(), person.getUri()) && MergeUtils.equals(this.getEmail(), person.getEmail());
    }

    public PersonReference toReference() {
        return new PersonReference(this.getIdAsPrimitive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(IPerson person) {
        if (this == person) {
            return true;
        }
        if (!(person instanceof Person)) {
            return false;
        }
        IPerson iPerson = person;
        synchronized (iPerson) {
            Person p = (Person)person;
            return (this.getId() == null ? p.getId() == null : this.getId().equals(p.getId())) && (this.fName == null ? p.fName == null : this.fName.equals(p.fName)) && (this.getUri() == null ? p.getUri() == null : this.getUri().toString().equals(p.getUri().toString())) && (this.getEmail() == null ? p.getEmail() == null : this.getEmail().equals(p.getEmail())) && (this.getProperties() == null ? p.getProperties() == null : this.getProperties().equals(p.getProperties()));
        }
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Name = " + this.fName + ", URI = " + this.fUri + ", EMail = " + this.fEmail + ")";
    }
}

