/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.util.Arrays;
import org.rssowl.core.util.ArrayUtils;

public class LongArrayList {
    protected long[] fElements;
    protected int fSize;

    protected LongArrayList() {
    }

    public LongArrayList(int initialCapacity) {
        this.fElements = new long[initialCapacity];
    }

    public LongArrayList(LongArrayList list) {
        this.fElements = new long[list.size()];
        System.arraycopy(list.fElements, 0, this.fElements, 0, list.fSize);
        this.fSize = list.fSize;
    }

    public final int size() {
        return this.fSize;
    }

    public final long get(int index) {
        this.rangeCheck(index);
        return this.fElements[index];
    }

    public final long[] getElements() {
        return this.fElements;
    }

    public int indexOf(long element) {
        int i = 0;
        while (i < this.fSize) {
            if (this.fElements[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(long element) {
        int i = this.fSize - 1;
        while (i >= 0) {
            if (this.fElements[i] == element) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public final boolean removeByElement(long element) {
        int index = this.indexOf(element);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    private void remove(int index) {
        int movedCount = this.fSize - 1 - index;
        if (movedCount > 0) {
            System.arraycopy(this.fElements, index + 1, this.fElements, index, movedCount);
        }
        this.fElements[--this.fSize] = 0L;
    }

    public final long removeByIndex(int index) {
        long oldValue = this.get(index);
        this.remove(index);
        return oldValue;
    }

    public void setAll(long[] elements) {
        this.fSize = elements.length;
        if (this.fElements.length > elements.length) {
            Arrays.fill(this.fElements, this.fSize, this.fElements.length, 0L);
        } else if (this.fElements.length < elements.length) {
            this.fElements = new long[elements.length];
        }
        System.arraycopy(elements, 0, this.fElements, 0, elements.length);
    }

    public final boolean elementsEqual(long[] other) {
        if (this.fSize != other.length) {
            return false;
        }
        int i = 0;
        int c = this.fSize;
        while (i < c) {
            if (this.fElements[i] != other[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void rangeCheck(int index) {
        if (index >= this.fSize) {
            throw new IndexOutOfBoundsException("size: " + this.fSize + ", index: " + index);
        }
    }

    public final boolean contains(long element) {
        return this.indexOf(element) >= 0;
    }

    public void add(long element) {
        this.fElements = ArrayUtils.ensureCapacity(this.fElements, this.fSize + 1);
        this.fElements[this.fSize++] = element;
    }

    public final void compact() {
        long[] compacted = new long[this.fSize];
        System.arraycopy(this.fElements, 0, compacted, 0, this.fSize);
        this.fElements = compacted;
    }

    public final void clear() {
        this.fSize = 0;
        this.fElements = new long[0];
    }

    public void removeAll(LongArrayList list) {
        long[] lArray = list.fElements;
        int n = list.fElements.length;
        int n2 = 0;
        while (n2 < n) {
            long element = lArray[n2];
            this.removeByElement(element);
            ++n2;
        }
    }

    public long[] toArray() {
        long[] copy = new long[this.fSize];
        System.arraycopy(this.fElements, 0, copy, 0, this.fSize);
        return copy;
    }

    public final boolean isEmpty() {
        return this.fSize == 0;
    }

    public final String toString() {
        return Arrays.toString(this.fElements);
    }

    public final int hashCode() {
        int hashCode = 1;
        int i = 0;
        while (i < this.fSize) {
            long element = this.fElements[i];
            hashCode = 31 * hashCode + (int)(element ^ element >>> 32);
            ++i;
        }
        return hashCode;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongArrayList)) {
            return false;
        }
        LongArrayList otherList = (LongArrayList)o;
        if (this.fSize != otherList.fSize) {
            return false;
        }
        int i = 0;
        int c = this.fSize;
        while (i < c) {
            if (this.fElements[i] != otherList.fElements[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

