/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.Persistable;
import org.rssowl.core.persist.IEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntity
extends Persistable
implements IEntity {
    private volatile Long fId;
    private HashMap<String, Serializable> fProperties;

    protected AbstractEntity() {
    }

    protected AbstractEntity(Long id) {
        this.fId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractEntity(Long id, AbstractEntity entity) {
        this.fId = id;
        AbstractEntity abstractEntity = entity;
        synchronized (abstractEntity) {
            if (entity.fProperties != null) {
                this.fProperties = new HashMap<String, Serializable>(entity.fProperties);
            }
        }
    }

    @Override
    public final Long getId() {
        return this.fId;
    }

    protected final long getIdAsPrimitive() {
        Long id = this.getId();
        Assert.isNotNull((Object)id, (String)"fId");
        return id;
    }

    @Override
    public void setId(Long id) {
        Assert.isNotNull((Object)id, (String)"id cannot be null");
        if (id.equals(this.fId)) {
            return;
        }
        if (this.fId != null) {
            throw new IllegalStateException("Cannot change id after it's been set.");
        }
        this.fId = id;
    }

    @Override
    public synchronized void setProperty(String key, Serializable value) {
        Assert.isNotNull((Object)key, (String)"Using NULL as Key is not permitted!");
        if (this.fProperties == null) {
            this.fProperties = new HashMap();
        }
        this.fProperties.put(key, value);
    }

    @Override
    public synchronized Object getProperty(String key) {
        Assert.isNotNull((Object)key, (String)"Using NULL as Key is not permitted!");
        if (this.fProperties == null) {
            return null;
        }
        return this.fProperties.get(key);
    }

    @Override
    public synchronized Object removeProperty(String key) {
        Assert.isNotNull((Object)key, (String)"Using NULL as Key is not permitted!");
        if (this.fProperties == null) {
            return null;
        }
        return this.fProperties.remove(key);
    }

    @Override
    public synchronized Map<String, Serializable> getProperties() {
        if (this.fProperties == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, Serializable>(this.fProperties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IEntity type = (IEntity)obj;
        if (this.fId == null || type.getId() == null) {
            return false;
        }
        return this.fId.equals(type.getId());
    }

    public int hashCode() {
        if (this.fId == null) {
            return super.hashCode();
        }
        return this.fId.hashCode();
    }

    public synchronized String toString() {
        String name = super.toString();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1, name.length());
        }
        return String.valueOf(name) + " (id = " + this.fId + ", Properties = " + this.getProperties() + ", ";
    }
}

