/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URIException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.connection.IConditionalGetCompatible;
import org.rssowl.core.connection.Messages;
import org.rssowl.core.connection.MonitorCanceledException;

public class HttpConnectionInputStream
extends FilterInputStream
implements IConditionalGetCompatible,
IAbortable {
    private static final String HEADER_RESPONSE_ETAG = "ETag";
    private static final String HEADER_RESPONSE_LAST_MODIFIED = "Last-Modified";
    private static final String HEADER_RESPONSE_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_RESPONSE_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_RESPONSE_CONTENT_DISPOSITION = "Content-Disposition";
    private static final String HEADER_RESPONSE_CONTENT_ENCODING = "Content-Encoding";
    private final HttpMethodBase fMethod;
    private final IProgressMonitor fMonitor;
    private String fIfModifiedSince;
    private String fIfNoneMatch;
    private final URI fLink;

    public HttpConnectionInputStream(URI link, HttpMethodBase method, IProgressMonitor monitor, InputStream inS) {
        super(inS);
        Header headerETag;
        this.fLink = link;
        this.fMethod = method;
        this.fMonitor = monitor;
        Header headerLastModified = method.getResponseHeader(HEADER_RESPONSE_LAST_MODIFIED);
        if (headerLastModified != null) {
            this.setIfModifiedSince(headerLastModified.getValue());
        }
        if ((headerETag = method.getResponseHeader(HEADER_RESPONSE_ETAG)) != null) {
            this.setIfNoneMatch(headerETag.getValue());
        }
    }

    public URI getLink() {
        try {
            return new URI(this.fMethod.getURI().toString());
        }
        catch (URIException uRIException) {
            return this.fLink;
        }
        catch (URISyntaxException uRISyntaxException) {
            return this.fLink;
        }
    }

    public String getIfModifiedSince() {
        return this.fIfModifiedSince;
    }

    public String getIfNoneMatch() {
        return this.fIfNoneMatch;
    }

    public void setIfModifiedSince(String ifModifiedSince) {
        this.fIfModifiedSince = ifModifiedSince;
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.fIfNoneMatch = ifNoneMatch;
    }

    public void abort() {
        this.fMethod.abort();
        this.fMethod.releaseConnection();
    }

    public void close() throws IOException {
        super.close();
        this.fMethod.releaseConnection();
    }

    public int read() throws IOException {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            throw new MonitorCanceledException(Messages.HttpConnectionInputStream_ERROR_CONNECTION_CANCELED);
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            throw new MonitorCanceledException(Messages.HttpConnectionInputStream_ERROR_CONNECTION_CANCELED);
        }
        return super.read(b, off, len);
    }

    public int available() throws IOException {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            throw new MonitorCanceledException(Messages.HttpConnectionInputStream_ERROR_CONNECTION_CANCELED);
        }
        return super.available();
    }

    public int getContentLength() {
        Header header = this.fMethod.getResponseHeader(HEADER_RESPONSE_CONTENT_LENGTH);
        if (header != null) {
            String value = header.getValue();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public String getContentType() {
        Header header = this.fMethod.getResponseHeader(HEADER_RESPONSE_CONTENT_TYPE);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public String getContentDisposition() {
        Header header = this.fMethod.getResponseHeader(HEADER_RESPONSE_CONTENT_DISPOSITION);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public String getContentEncoding() {
        Header header = this.fMethod.getResponseHeader(HEADER_RESPONSE_CONTENT_ENCODING);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }
}

