/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.CorruptionException;
import com.db4o.internal.Buffer;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.SlotReader;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.marshall.ObjectHeaderAttributes;

public abstract class StringMarshaller {
    public abstract boolean inlinedStrings();

    public abstract void calculateLengths(Transaction var1, ObjectHeaderAttributes var2, boolean var3, Object var4, boolean var5);

    protected final int linkLength() {
        return 8;
    }

    public abstract Object writeNew(Object var1, boolean var2, StatefulBuffer var3, boolean var4);

    public final String read(ObjectContainerBase objectContainerBase, Buffer buffer) throws CorruptionException {
        if (buffer == null) {
            return null;
        }
        String string = StringMarshaller.readShort(objectContainerBase, buffer);
        return string;
    }

    public String readFromOwnSlot(ObjectContainerBase objectContainerBase, Buffer buffer) {
        try {
            return this.read(objectContainerBase, buffer);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String readFromParentSlot(ObjectContainerBase objectContainerBase, Buffer buffer, boolean bl) throws CorruptionException {
        if (!bl) {
            return this.read(objectContainerBase, buffer);
        }
        return this.read(objectContainerBase, this.readSlotFromParentSlot(objectContainerBase, buffer));
    }

    public abstract Buffer readIndexEntry(StatefulBuffer var1) throws CorruptionException;

    public static String readShort(ObjectContainerBase objectContainerBase, Buffer buffer) throws CorruptionException {
        return StringMarshaller.readShort(objectContainerBase.stringIO(), objectContainerBase.configImpl().internStrings(), buffer);
    }

    public static String readShort(LatinStringIO latinStringIO, boolean bl, Buffer buffer) throws CorruptionException {
        int n = buffer.readInt();
        if (n > 70000000) {
            throw new CorruptionException();
        }
        if (n > 0) {
            String string = latinStringIO.read(buffer, n);
            if (bl) {
                string = string.intern();
            }
            return string;
        }
        return "";
    }

    public abstract Buffer readSlotFromParentSlot(ObjectContainerBase var1, Buffer var2) throws CorruptionException;

    public static Buffer writeShort(ObjectContainerBase objectContainerBase, String string) {
        Buffer buffer = new Buffer(objectContainerBase.stringIO().length(string));
        StringMarshaller.writeShort(objectContainerBase, string, buffer);
        return buffer;
    }

    public static void writeShort(ObjectContainerBase objectContainerBase, String string, Buffer buffer) {
        int n = string.length();
        buffer.writeInt(n);
        objectContainerBase.stringIO().write(buffer, string);
    }

    public abstract void defrag(SlotReader var1);
}

