/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.foundation.Coercion4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.reflect.ReflectClass;

public final class ByteHandler
extends PrimitiveHandler {
    static final int LENGTH = 1;
    private static final Byte i_primitive = new Byte(0);
    private byte i_compareTo;

    public ByteHandler(ObjectContainerBase objectContainerBase) {
        super(objectContainerBase);
    }

    public Object coerce(ReflectClass reflectClass, Object object) {
        return Coercion4.toSByte(object);
    }

    public int getID() {
        return 6;
    }

    public Object defaultValue() {
        return i_primitive;
    }

    public int linkLength() {
        return 1;
    }

    protected Class primitiveJavaClass() {
        return Byte.TYPE;
    }

    public Object primitiveNull() {
        return i_primitive;
    }

    Object read1(Buffer buffer) {
        byte by = buffer.readByte();
        return new Byte(by);
    }

    public void write(Object object, Buffer buffer) {
        buffer.append((Byte)object);
    }

    public boolean readArray(Object object, Buffer buffer) {
        if (object instanceof byte[]) {
            buffer.readBytes((byte[])object);
            return true;
        }
        return false;
    }

    public boolean writeArray(Object object, Buffer buffer) {
        if (object instanceof byte[]) {
            buffer.append((byte[])object);
            return true;
        }
        return false;
    }

    private byte val(Object object) {
        return (Byte)object;
    }

    void prepareComparison1(Object object) {
        this.i_compareTo = this.val(object);
    }

    public Object current1() {
        return new Byte(this.i_compareTo);
    }

    boolean isEqual1(Object object) {
        return object instanceof Byte && this.val(object) == this.i_compareTo;
    }

    boolean isGreater1(Object object) {
        return object instanceof Byte && this.val(object) > this.i_compareTo;
    }

    boolean isSmaller1(Object object) {
        return object instanceof Byte && this.val(object) < this.i_compareTo;
    }
}

