/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.diagnostic;

import com.db4o.diagnostic.ClassHasNoFields;
import com.db4o.diagnostic.DescendIntoTranslator;
import com.db4o.diagnostic.Diagnostic;
import com.db4o.diagnostic.DiagnosticConfiguration;
import com.db4o.diagnostic.DiagnosticListener;
import com.db4o.diagnostic.LoadedFromClassIndex;
import com.db4o.diagnostic.NativeQueryNotOptimized;
import com.db4o.diagnostic.UpdateDepthGreaterOne;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Platform4;
import com.db4o.query.Predicate;

public class DiagnosticProcessor
implements DiagnosticConfiguration,
DeepClone {
    private Collection4 _listeners;

    public DiagnosticProcessor() {
    }

    private DiagnosticProcessor(Collection4 collection4) {
        this._listeners = collection4;
    }

    public void addListener(DiagnosticListener diagnosticListener) {
        if (this._listeners == null) {
            this._listeners = new Collection4();
        }
        this._listeners.add(diagnosticListener);
    }

    public void checkClassHasFields(ClassMetadata classMetadata) {
        FieldMetadata[] fieldMetadataArray = classMetadata.i_fields;
        if (fieldMetadataArray != null && fieldMetadataArray.length == 0) {
            String string = classMetadata.getName();
            String[] stringArray = new String[]{"java.util."};
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) != 0) continue;
                return;
            }
            if (this.isDb4oClass(classMetadata)) {
                return;
            }
            this.onDiagnostic(new ClassHasNoFields(string));
        }
    }

    public void checkUpdateDepth(int n) {
        if (n > 1) {
            this.onDiagnostic(new UpdateDepthGreaterOne(n));
        }
    }

    public Object deepClone(Object object) {
        return new DiagnosticProcessor(this.cloneListeners());
    }

    private Collection4 cloneListeners() {
        return this._listeners != null ? new Collection4(this._listeners) : null;
    }

    public boolean enabled() {
        return this._listeners != null;
    }

    private boolean isDb4oClass(ClassMetadata classMetadata) {
        return Platform4.isDb4oClass(classMetadata.getName());
    }

    public void loadedFromClassIndex(ClassMetadata classMetadata) {
        if (this.isDb4oClass(classMetadata)) {
            return;
        }
        this.onDiagnostic(new LoadedFromClassIndex(classMetadata.getName()));
    }

    public void descendIntoTranslator(ClassMetadata classMetadata, String string) {
        this.onDiagnostic(new DescendIntoTranslator(classMetadata.getName(), string));
    }

    public void nativeQueryUnoptimized(Predicate predicate) {
        this.onDiagnostic(new NativeQueryNotOptimized(predicate));
    }

    private void onDiagnostic(Diagnostic diagnostic) {
        if (this._listeners == null) {
            return;
        }
        Iterator4 iterator4 = this._listeners.iterator();
        while (iterator4.moveNext()) {
            ((DiagnosticListener)iterator4.current()).onDiagnostic(diagnostic);
        }
    }

    public void removeAllListeners() {
        this._listeners = null;
    }
}

