/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.views.explorer.Messages;

public class BookMarkLabelProvider
extends CellLabelProvider {
    private LocalResourceManager fResources;
    private Image fFolderIcon;
    private Image fFolderNewIcon;
    private Image fBookMarkErrorIcon;
    private Image fBookMarkIcon;
    private Image fSearchMarkIcon;
    private Image fSearchMarkNewIcon;
    private Image fSearchMarkEmptyIcon;
    private Image fGroupIcon;
    private Image fBookmarkSetIcon;
    private Image fArchiveIcon;
    private Image fArchiveNewIcon;
    private Image fNewsBinIcon;
    private Image fNewsBinNewIcon;
    private Image fNewsBinEmptyIcon;
    private Color fStickyBgColor;
    private Color fGradientFgColor;
    private Color fGradientBgColor;
    private Color fGradientEndColor;
    private Color fGroupFgColor;
    private Font fBoldFont;
    private Font fDefaultFont;
    private boolean fIndicateState;
    private final boolean fUseDialogFont;
    private boolean fUseFavicons = true;

    public BookMarkLabelProvider() {
        this(true);
    }

    public BookMarkLabelProvider(boolean indicateState) {
        this(indicateState, false);
    }

    public BookMarkLabelProvider(boolean indicateState, boolean useDialogFont) {
        this.fIndicateState = indicateState;
        this.fUseDialogFont = useDialogFont;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.createResources();
    }

    void updateResources() {
        this.fStickyBgColor = OwlUI.getThemeColor("org.rssowl.ui.StickyBGColor", (ResourceManager)this.fResources, new RGB(255, 255, 180));
    }

    void setUseFavicons(boolean useFavicons) {
        this.fUseFavicons = useFavicons;
    }

    private void createResources() {
        this.fBookmarkSetIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.BOOKMARK_SET);
        this.fGroupIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.GROUP);
        this.fFolderIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.FOLDER);
        this.fFolderNewIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.FOLDER_NEW);
        this.fBookMarkErrorIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.BOOKMARK_ERROR);
        this.fBookMarkIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.BOOKMARK);
        this.fSearchMarkIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.SEARCHMARK);
        this.fSearchMarkNewIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.SEARCHMARK_NEW);
        this.fSearchMarkEmptyIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.SEARCHMARK_EMPTY);
        this.fArchiveIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.ARCHIVE);
        this.fArchiveNewIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.ARCHIVE_NEW);
        this.fNewsBinIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWSBIN);
        this.fNewsBinNewIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWSBIN_NEW);
        this.fNewsBinEmptyIcon = OwlUI.getImage((ResourceManager)this.fResources, OwlUI.NEWSBIN_EMPTY);
        this.fBoldFont = OwlUI.getThemeFont(this.fUseDialogFont ? "org.eclipse.jface.dialogfont" : "org.rssowl.ui.BookmarkExplorerFont", 1);
        this.fDefaultFont = OwlUI.getThemeFont(this.fUseDialogFont ? "org.eclipse.jface.dialogfont" : "org.rssowl.ui.BookmarkExplorerFont", 0);
        this.fStickyBgColor = OwlUI.getThemeColor("org.rssowl.ui.StickyBGColor", (ResourceManager)this.fResources, new RGB(255, 255, 180));
        this.fGroupFgColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_FG_COLOR);
        this.fGradientFgColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_GRADIENT_FG_COLOR);
        this.fGradientBgColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_GRADIENT_BG_COLOR);
        this.fGradientEndColor = OwlUI.getColor((ResourceManager)this.fResources, OwlUI.GROUP_GRADIENT_END_COLOR);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        int unreadNewsCount = 0;
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            int newNewsCount = 0;
            boolean hasSticky = false;
            if (this.fIndicateState) {
                FolderDecorationHelper helper = new FolderDecorationHelper();
                this.computeFolderDecoration(folder, helper);
                hasSticky = helper.fHasSticky;
                unreadNewsCount = helper.fUnreadCount;
                newNewsCount = helper.fNewCount;
            }
            if (folder.getParent() == null) {
                cell.setImage(this.fBookmarkSetIcon);
            } else if (newNewsCount == 0) {
                cell.setImage(this.fFolderIcon);
            } else {
                cell.setImage(this.fFolderNewIcon);
            }
            if (unreadNewsCount > 0) {
                cell.setFont(this.fBoldFont);
            } else {
                cell.setFont(this.fDefaultFont);
            }
            if (unreadNewsCount > 0) {
                cell.setText(NLS.bind((String)Messages.BookMarkLabelProvider_NAME_UNREAD, (Object)folder.getName(), (Object)unreadNewsCount));
            } else {
                cell.setText(folder.getName());
            }
            cell.setForeground(null);
            if (hasSticky && !OwlUI.isHighContrast()) {
                cell.setBackground(this.fStickyBgColor);
            } else {
                cell.setBackground(null);
            }
        } else if (element instanceof INewsMark) {
            boolean hasNew = false;
            int stickyNewsCount = 0;
            INewsMark newsmark = (INewsMark)element;
            if (this.fIndicateState) {
                unreadNewsCount = newsmark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED));
                boolean bl = hasNew = newsmark.getNewsCount(EnumSet.of(INews.State.NEW)) != 0;
            }
            if (unreadNewsCount > 0) {
                cell.setFont(this.fBoldFont);
            } else {
                cell.setFont(this.fDefaultFont);
            }
            if (unreadNewsCount > 0) {
                cell.setText(NLS.bind((String)Messages.BookMarkLabelProvider_NAME_UNREAD, (Object)newsmark.getName(), (Object)unreadNewsCount));
            } else {
                cell.setText(newsmark.getName());
            }
            if (newsmark instanceof IBookMark && this.fIndicateState) {
                stickyNewsCount = ((IBookMark)newsmark).getStickyNewsCount();
            }
            if (stickyNewsCount > 0 && !OwlUI.isHighContrast()) {
                cell.setBackground(this.fStickyBgColor);
            } else {
                cell.setBackground(null);
            }
            cell.setForeground(null);
            if (newsmark instanceof IBookMark) {
                cell.setImage(this.getIconForBookMark((IBookMark)newsmark, hasNew));
            } else if (newsmark instanceof ISearchMark) {
                cell.setImage(this.getIconForSearchMark((ISearchMark)newsmark, hasNew, unreadNewsCount));
            } else if (newsmark instanceof INewsBin) {
                cell.setImage(this.getIconForNewsBin((INewsBin)newsmark, hasNew, unreadNewsCount));
            }
        } else if (element instanceof EntityGroup) {
            EntityGroup group = (EntityGroup)element;
            cell.setText(group.getName());
            cell.setImage(this.fGroupIcon);
            if (!OwlUI.isHighContrast()) {
                cell.setForeground(this.fGroupFgColor);
            }
            cell.setBackground(null);
            cell.setFont(this.fBoldFont);
        }
    }

    private Image getIconForBookMark(IBookMark bookmark, boolean hasNew) {
        Image icon;
        ImageDescriptor favicon;
        ImageDescriptor imageDescriptor = favicon = this.fUseFavicons ? OwlUI.getFavicon(bookmark) : null;
        if (bookmark.isErrorLoading()) {
            if (favicon != null) {
                Image faviconImg = OwlUI.getImage((ResourceManager)this.fResources, favicon);
                DecorationOverlayIcon overlay = new DecorationOverlayIcon(faviconImg, OwlUI.getImageDescriptor("icons/ovr16/error.gif"), 3);
                return OwlUI.getImage((ResourceManager)this.fResources, (ImageDescriptor)overlay);
            }
            return this.fBookMarkErrorIcon;
        }
        Image image = icon = favicon != null ? OwlUI.getImage((ResourceManager)this.fResources, favicon) : this.fBookMarkIcon;
        if (hasNew) {
            DecorationOverlayIcon overlay = new DecorationOverlayIcon(icon, OwlUI.getImageDescriptor("icons/ovr16/new.gif"), 3);
            return OwlUI.getImage((ResourceManager)this.fResources, (ImageDescriptor)overlay);
        }
        return icon;
    }

    private Image getIconForSearchMark(ISearchMark searchmark, boolean hasNew, int unreadNewsCount) {
        boolean hasMatchingNews;
        boolean bl = hasMatchingNews = unreadNewsCount > 0 || searchmark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED, INews.State.READ)) != 0;
        if (hasNew) {
            return this.fSearchMarkNewIcon;
        }
        if (hasMatchingNews) {
            return this.fSearchMarkIcon;
        }
        return this.fSearchMarkEmptyIcon;
    }

    private Image getIconForNewsBin(INewsBin newsbin, boolean hasNew, int unreadNewsCount) {
        boolean isArchive;
        boolean hasMatchingNews = unreadNewsCount > 0 || newsbin.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED, INews.State.READ)) != 0;
        boolean bl = isArchive = newsbin.getProperty(DefaultPreferences.ARCHIVE_BIN_MARKER) != null;
        if (hasNew) {
            return isArchive ? this.fArchiveNewIcon : this.fNewsBinNewIcon;
        }
        if (isArchive) {
            return this.fArchiveIcon;
        }
        if (hasMatchingNews) {
            return this.fNewsBinIcon;
        }
        return this.fNewsBinEmptyIcon;
    }

    public void dispose() {
        this.fResources.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    private void computeFolderDecoration(IFolder folder, FolderDecorationHelper helper) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof INewsMark) {
                INewsMark newsMark = (INewsMark)child;
                helper.fUnreadCount += this.getUnreadNewsCount(newsMark);
                helper.fNewCount += newsMark.getNewsCount(EnumSet.of(INews.State.NEW));
                if (helper.fHasSticky || !(newsMark instanceof IBookMark) || ((IBookMark)newsMark).getStickyNewsCount() <= 0) continue;
                helper.fHasSticky = true;
                continue;
            }
            if (!(child instanceof IFolder)) continue;
            this.computeFolderDecoration((IFolder)child, helper);
        }
    }

    private int getUnreadNewsCount(INewsMark newsMark) {
        return newsMark.getNewsCount(EnumSet.of(INews.State.NEW, INews.State.UNREAD, INews.State.UPDATED));
    }

    void erase(Event event, Object element) {
        if (element instanceof EntityGroup) {
            OwlUI.codDrawGradient(event, this.fGradientFgColor, this.fGradientBgColor, this.fGradientEndColor);
        }
    }

    private static class FolderDecorationHelper {
        int fNewCount;
        int fUnreadCount;
        boolean fHasSticky;

        private FolderDecorationHelper() {
        }
    }
}

