/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.IBookMarkDAO;
import org.rssowl.core.persist.dao.INewsBinDAO;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.BookMarkListener;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.event.FolderEvent;
import org.rssowl.core.persist.event.FolderListener;
import org.rssowl.core.persist.event.MarkEvent;
import org.rssowl.core.persist.event.NewsAdapter;
import org.rssowl.core.persist.event.NewsBinEvent;
import org.rssowl.core.persist.event.NewsBinListener;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.NewsListener;
import org.rssowl.core.persist.event.SearchMarkEvent;
import org.rssowl.core.persist.event.SearchMarkListener;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.EntityGroup;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.views.explorer.BookMarkFilter;
import org.rssowl.ui.internal.views.explorer.BookMarkGrouping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookMarkContentProvider
implements ITreeContentProvider {
    private static final int SELECTION_DELAY = 20;
    private FolderListener fFolderListener;
    private BookMarkListener fBookMarkListener;
    private NewsBinListener fNewsBinListener;
    private SearchMarkListener fSearchMarkListener;
    private NewsListener fNewsListener;
    private IFolder fInput;
    private TreeViewer fViewer;
    private BookMarkFilter fBookmarkFilter;
    private BookMarkGrouping fBookmarkGrouping;
    private IBookMarkDAO fBookMarkDAO = (IBookMarkDAO)DynamicDAO.getDAO(IBookMarkDAO.class);

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IFolder) {
            IFolder rootFolder = (IFolder)inputElement;
            if (!this.fBookmarkGrouping.isActive()) {
                List elements = rootFolder.getChildren();
                return elements.toArray();
            }
            ArrayList<IMark> marks = new ArrayList<IMark>();
            this.getAllMarks(rootFolder, marks);
            return this.fBookmarkGrouping.group(marks);
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFolder) {
            IFolder parent = (IFolder)parentElement;
            List children = parent.getChildren();
            return children.toArray();
        }
        if (parentElement instanceof EntityGroup) {
            List<IEntity> children = ((EntityGroup)parentElement).getEntities();
            return children.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (this.fBookmarkGrouping.isActive() && element instanceof IEntity) {
            IEntity entity = (IEntity)element;
            EntityGroup[] groups = this.fBookmarkGrouping.group(Collections.singletonList(entity));
            if (groups.length == 1) {
                return groups[0];
            }
        } else {
            if (element instanceof IFolder) {
                IFolder folder = (IFolder)element;
                return folder.getParent();
            }
            if (element instanceof IMark) {
                IMark mark = (IMark)element;
                return mark.getParent();
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            return folder.getChildren().size() > 0;
        }
        if (element instanceof EntityGroup) {
            return ((EntityGroup)element).size() > 0;
        }
        return false;
    }

    public void dispose() {
        this.unregisterListeners();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Assert.isTrue((newInput instanceof IFolder || newInput == null ? 1 : 0) != 0);
        this.fViewer = (TreeViewer)viewer;
        this.fInput = (IFolder)newInput;
        if (newInput != null && oldInput == null) {
            this.registerListeners();
        } else if (newInput == null && oldInput != null) {
            this.unregisterListeners();
        }
    }

    void setBookmarkFilter(BookMarkFilter bookmarkFilter) {
        this.fBookmarkFilter = bookmarkFilter;
    }

    void setBookmarkGrouping(BookMarkGrouping bookmarkGrouping) {
        this.fBookmarkGrouping = bookmarkGrouping;
    }

    private void registerListeners() {
        this.fFolderListener = new FolderListener(){

            public void entitiesUpdated(final Set<FolderEvent> events) {
                JobRunner.runInUIThread((Widget)BookMarkContentProvider.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        HashSet<IFolder> updatedFolders = null;
                        HashMap<IFolder, IFolder> reparentedFolders = null;
                        for (FolderEvent event : events) {
                            if (!event.isRoot()) continue;
                            if (event.getOldParent() != null) {
                                if (reparentedFolders == null) {
                                    reparentedFolders = new HashMap<IFolder, IFolder>();
                                }
                                reparentedFolders.put(event.getEntity(), event.getOldParent());
                                continue;
                            }
                            if (updatedFolders == null) {
                                updatedFolders = new HashSet<IFolder>();
                            }
                            updatedFolders.add(event.getEntity());
                        }
                        if (updatedFolders == null && reparentedFolders == null) {
                            return;
                        }
                        if (BookMarkContentProvider.this.fBookmarkFilter.needsRefresh(IFolder.class, events)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        } else if (BookMarkContentProvider.this.fBookmarkGrouping.needsRefresh(IFolder.class)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        } else if (reparentedFolders != null) {
                            Set entries = reparentedFolders.entrySet();
                            HashSet<IFolder> parentsToUpdate = new HashSet<IFolder>();
                            ArrayList<Object> expandedElements = new ArrayList<Object>(Arrays.asList(BookMarkContentProvider.this.fViewer.getExpandedElements()));
                            try {
                                BookMarkContentProvider.this.fViewer.getControl().getParent().setRedraw(false);
                                for (Map.Entry entry : entries) {
                                    IFolder reparentedFolder = (IFolder)entry.getKey();
                                    IFolder oldParent = (IFolder)entry.getValue();
                                    ISelection selection = BookMarkContentProvider.this.fViewer.getSelection();
                                    boolean expand = expandedElements.contains(reparentedFolder);
                                    BookMarkContentProvider.this.fViewer.remove((Object)oldParent, new Object[]{reparentedFolder});
                                    BookMarkContentProvider.this.fViewer.refresh((Object)reparentedFolder.getParent(), false);
                                    BookMarkContentProvider.this.fViewer.setSelection(selection);
                                    if (expand) {
                                        BookMarkContentProvider.this.fViewer.setExpandedState((Object)reparentedFolder, expand);
                                    }
                                    parentsToUpdate.add(oldParent);
                                    parentsToUpdate.add(reparentedFolder.getParent());
                                }
                            }
                            finally {
                                BookMarkContentProvider.this.fViewer.getControl().getParent().setRedraw(true);
                            }
                            for (IFolder folder : parentsToUpdate) {
                                BookMarkContentProvider.this.updateFolderAndParents(folder);
                            }
                        }
                        if (updatedFolders != null) {
                            for (IFolder folder : updatedFolders) {
                                if (BookMarkContentProvider.this.fInput.equals(folder)) {
                                    BookMarkContentProvider.this.fViewer.refresh((Object)BookMarkContentProvider.this.fInput);
                                    continue;
                                }
                                BookMarkContentProvider.this.fViewer.refresh((Object)folder);
                            }
                        }
                    }
                });
            }

            public void entitiesDeleted(final Set<FolderEvent> events) {
                JobRunner.runInUIThread((Widget)BookMarkContentProvider.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        HashSet<IFolder> removedFolders = null;
                        for (FolderEvent event : events) {
                            if (!event.isRoot() || event.getEntity().getParent() == null) continue;
                            if (removedFolders == null) {
                                removedFolders = new HashSet<IFolder>();
                            }
                            removedFolders.add(event.getEntity());
                        }
                        if (removedFolders == null || removedFolders.size() == 0) {
                            return;
                        }
                        if (BookMarkContentProvider.this.fBookmarkFilter.needsRefresh(IFolder.class, events)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        } else if (BookMarkContentProvider.this.fBookmarkGrouping.needsRefresh(IFolder.class)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        } else {
                            BookMarkContentProvider.this.fViewer.remove(removedFolders.toArray());
                        }
                        if (!BookMarkContentProvider.this.fBookmarkGrouping.isActive()) {
                            for (FolderEvent event : events) {
                                IFolder eventParent = event.getEntity().getParent();
                                if (eventParent == null || eventParent.getParent() == null) continue;
                                BookMarkContentProvider.this.updateFolderAndParents(eventParent);
                            }
                        }
                    }
                });
            }

            public void entitiesAdded(final Set<FolderEvent> events) {
                JobRunner.runInUIThread(20, (Widget)BookMarkContentProvider.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        ArrayList<IFolder> addedFolders = new ArrayList<IFolder>();
                        for (FolderEvent folderEvent : events) {
                            IFolder addedFolder = folderEvent.getEntity();
                            if (addedFolder.getParent() == null) continue;
                            addedFolders.add(addedFolder);
                        }
                        if (addedFolders.size() == 1) {
                            BookMarkContentProvider.this.fViewer.setSelection((ISelection)new StructuredSelection(addedFolders), true);
                        }
                    }
                });
            }
        };
        this.fBookMarkListener = new BookMarkListener(){

            public void entitiesUpdated(Set<BookMarkEvent> events) {
                BookMarkContentProvider.this.onMarksUpdated(events);
            }

            public void entitiesDeleted(Set<BookMarkEvent> events) {
                BookMarkContentProvider.this.onMarksRemoved(events);
            }

            public void entitiesAdded(Set<BookMarkEvent> events) {
                BookMarkContentProvider.this.onMarksAdded(events);
            }
        };
        this.fSearchMarkListener = new SearchMarkListener(){

            public void entitiesUpdated(Set<SearchMarkEvent> events) {
                BookMarkContentProvider.this.onMarksUpdated(events);
            }

            public void entitiesDeleted(Set<SearchMarkEvent> events) {
                BookMarkContentProvider.this.onMarksRemoved(events);
            }

            public void entitiesAdded(Set<SearchMarkEvent> events) {
                BookMarkContentProvider.this.onMarksAdded(events);
            }

            public void newsChanged(final Set<SearchMarkEvent> events) {
                JobRunner.runInUIThread((Widget)BookMarkContentProvider.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        if (BookMarkContentProvider.this.fBookmarkFilter.needsRefresh(ISearchMark.class, events, true)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        }
                        HashSet<ISearchMark> updatedSearchMarks = new HashSet<ISearchMark>(events.size());
                        for (SearchMarkEvent event : events) {
                            updatedSearchMarks.add(event.getEntity());
                        }
                        BookMarkContentProvider.this.fViewer.update(updatedSearchMarks.toArray(), null);
                        if (!BookMarkContentProvider.this.fBookmarkGrouping.isActive()) {
                            for (ISearchMark searchMark : updatedSearchMarks) {
                                BookMarkContentProvider.this.updateFolderAndParents(searchMark.getParent());
                            }
                        }
                    }
                });
            }
        };
        this.fNewsBinListener = new NewsBinListener(){

            public void entitiesUpdated(Set<NewsBinEvent> events) {
                BookMarkContentProvider.this.onMarksUpdated(events);
            }

            public void entitiesDeleted(Set<NewsBinEvent> events) {
                BookMarkContentProvider.this.onMarksRemoved(events);
            }

            public void entitiesAdded(Set<NewsBinEvent> events) {
                BookMarkContentProvider.this.onMarksAdded(events);
            }
        };
        this.fNewsListener = new NewsAdapter(){

            public void entitiesAdded(final Set<NewsEvent> events) {
                JobRunner.runInUIThread((Widget)BookMarkContentProvider.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        if (Controller.getDefault().isShuttingDown()) {
                            return;
                        }
                        if (BookMarkContentProvider.this.fBookmarkFilter.needsRefresh(INews.class, events)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        } else if (BookMarkContentProvider.this.fBookmarkGrouping.needsRefresh(INews.class)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        }
                        if (BookMarkContentProvider.this.requiresUpdate(events)) {
                            BookMarkContentProvider.this.updateParents(events);
                        }
                    }
                });
            }

            public void entitiesUpdated(final Set<NewsEvent> events) {
                JobRunner.runInUIThread((Widget)BookMarkContentProvider.this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        if (Controller.getDefault().isShuttingDown()) {
                            return;
                        }
                        if (BookMarkContentProvider.this.fBookmarkFilter.needsRefresh(INews.class, events)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        } else if (BookMarkContentProvider.this.fBookmarkGrouping.needsRefresh(INews.class)) {
                            BookMarkContentProvider.this.fViewer.refresh(false);
                        }
                        if (BookMarkContentProvider.this.requiresUpdate(events)) {
                            BookMarkContentProvider.this.updateParents(events);
                        }
                    }
                });
            }
        };
        DynamicDAO.addEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
        DynamicDAO.addEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
        DynamicDAO.addEntityListener(INewsBin.class, (EntityListener)this.fNewsBinListener);
        DynamicDAO.addEntityListener(ISearchMark.class, (EntityListener)this.fSearchMarkListener);
        DynamicDAO.addEntityListener(INews.class, (EntityListener)this.fNewsListener);
    }

    private void onMarksAdded(Set<? extends MarkEvent> events) {
        if (events.size() == 1) {
            final MarkEvent event = events.iterator().next();
            JobRunner.runInUIThread((Widget)this.fViewer.getControl(), new Runnable(){

                public void run() {
                    BookMarkContentProvider.this.expand(event.getEntity().getParent());
                }
            });
        }
    }

    private void onMarksRemoved(final Set<? extends MarkEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        JobRunner.runInUIThread((Widget)this.fViewer.getControl(), new Runnable(){

            public void run() {
                Class<?> clazz = null;
                HashSet<IMark> removedMarks = null;
                for (MarkEvent event : events) {
                    if (event.isRoot()) {
                        if (removedMarks == null) {
                            removedMarks = new HashSet<IMark>();
                        }
                        removedMarks.add(event.getEntity());
                    }
                    if (clazz != null) continue;
                    clazz = event.getEntity().getClass();
                }
                if (removedMarks == null || removedMarks.size() == 0) {
                    return;
                }
                if (BookMarkContentProvider.this.fBookmarkFilter.needsRefresh(clazz, events)) {
                    BookMarkContentProvider.this.fViewer.refresh(false);
                } else if (BookMarkContentProvider.this.fBookmarkGrouping.needsRefresh(clazz)) {
                    BookMarkContentProvider.this.fViewer.refresh(false);
                } else {
                    BookMarkContentProvider.this.fViewer.remove(removedMarks.toArray());
                }
                if (!BookMarkContentProvider.this.fBookmarkGrouping.isActive()) {
                    for (MarkEvent event : events) {
                        IFolder eventParent = event.getEntity().getParent();
                        if (eventParent == null || eventParent.getParent() == null) continue;
                        BookMarkContentProvider.this.updateFolderAndParents(eventParent);
                    }
                }
            }
        });
    }

    private void onMarksUpdated(final Set<? extends MarkEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        JobRunner.runInUIThread((Widget)this.fViewer.getControl(), new Runnable(){

            public void run() {
                Class<?> clazz = null;
                HashSet<IMark> updatedMarks = null;
                HashMap<IMark, IFolder> reparentedMarks = null;
                for (MarkEvent event : events) {
                    if (event.isRoot()) {
                        IFolder oldParent = event.getOldParent();
                        if (oldParent != null) {
                            if (reparentedMarks == null) {
                                reparentedMarks = new HashMap<IMark, IFolder>();
                            }
                            reparentedMarks.put(event.getEntity(), oldParent);
                        } else {
                            if (updatedMarks == null) {
                                updatedMarks = new HashSet<IMark>();
                            }
                            updatedMarks.add(event.getEntity());
                        }
                    }
                    if (clazz != null) continue;
                    clazz = event.getEntity().getClass();
                }
                if (updatedMarks == null && reparentedMarks == null) {
                    return;
                }
                if (BookMarkContentProvider.this.fBookmarkFilter.needsRefresh(clazz, events)) {
                    BookMarkContentProvider.this.fViewer.refresh(false);
                } else if (BookMarkContentProvider.this.fBookmarkGrouping.needsRefresh(clazz)) {
                    BookMarkContentProvider.this.fViewer.refresh(false);
                } else if (reparentedMarks != null) {
                    Set entries = reparentedMarks.entrySet();
                    HashSet<IFolder> parentsToUpdate = new HashSet<IFolder>();
                    try {
                        BookMarkContentProvider.this.fViewer.getControl().getParent().setRedraw(false);
                        for (Map.Entry entry : entries) {
                            IMark reparentedMark = (IMark)entry.getKey();
                            IFolder oldParent = (IFolder)entry.getValue();
                            ISelection selection = BookMarkContentProvider.this.fViewer.getSelection();
                            BookMarkContentProvider.this.fViewer.remove((Object)oldParent, new Object[]{reparentedMark});
                            BookMarkContentProvider.this.fViewer.refresh((Object)reparentedMark.getParent(), false);
                            BookMarkContentProvider.this.fViewer.setSelection(selection);
                            parentsToUpdate.add(oldParent);
                            parentsToUpdate.add(reparentedMark.getParent());
                        }
                    }
                    finally {
                        BookMarkContentProvider.this.fViewer.getControl().getParent().setRedraw(true);
                    }
                    for (IFolder folder : parentsToUpdate) {
                        BookMarkContentProvider.this.updateFolderAndParents(folder);
                    }
                }
                if (updatedMarks != null) {
                    BookMarkContentProvider.this.fViewer.update(updatedMarks.toArray(), null);
                }
            }
        });
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(IFolder.class, (EntityListener)this.fFolderListener);
        DynamicDAO.removeEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
        DynamicDAO.removeEntityListener(INewsBin.class, (EntityListener)this.fNewsBinListener);
        DynamicDAO.removeEntityListener(ISearchMark.class, (EntityListener)this.fSearchMarkListener);
        DynamicDAO.removeEntityListener(INews.class, (EntityListener)this.fNewsListener);
    }

    private void updateParents(Set<NewsEvent> events) {
        INewsBinDAO newsBinDao = (INewsBinDAO)DynamicDAO.getDAO(INewsBinDAO.class);
        HashSet<FeedLinkReference> affectedFeeds = new HashSet<FeedLinkReference>();
        HashSet<IFolder> affectedBinFolders = new HashSet<IFolder>();
        HashSet<Long> handledBins = new HashSet<Long>();
        for (NewsEvent event : events) {
            INews news = event.getEntity();
            long parentId = news.getParentId();
            if (!this.fBookmarkGrouping.isActive() && parentId != 0L) {
                if (handledBins.contains(parentId)) continue;
                INewsBin bin = (INewsBin)newsBinDao.load(parentId);
                if (bin != null) {
                    affectedBinFolders.add(bin.getParent());
                }
                handledBins.add(parentId);
                continue;
            }
            affectedFeeds.add(news.getFeedReference());
        }
        if (Controller.getDefault().isShuttingDown()) {
            return;
        }
        for (FeedLinkReference feedRef : affectedFeeds) {
            this.updateParents(feedRef);
        }
        for (IFolder folder : affectedBinFolders) {
            this.updateFolderAndParents(folder);
        }
    }

    private void updateParents(FeedLinkReference feedRef) throws PersistenceException {
        Collection affectedBookMarks = this.fBookMarkDAO.loadAll(feedRef);
        if (Controller.getDefault().isShuttingDown()) {
            return;
        }
        this.updateMarksAndParents(affectedBookMarks);
    }

    private void updateMarksAndParents(Collection<IBookMark> bookmarks) {
        HashSet<Object> entitiesToUpdate = new HashSet<Object>();
        entitiesToUpdate.addAll(bookmarks);
        if (!this.fBookmarkGrouping.isActive()) {
            for (IBookMark bookmark : bookmarks) {
                ArrayList<IFolder> visibleParents = new ArrayList<IFolder>();
                this.collectParents(visibleParents, (IEntity)bookmark);
                entitiesToUpdate.addAll(visibleParents);
                if (!Controller.getDefault().isShuttingDown()) continue;
                return;
            }
        }
        this.fViewer.update(entitiesToUpdate.toArray(), null);
    }

    private void collectParents(List<IFolder> parents, IEntity entity) {
        IFolder parent = null;
        if (entity instanceof IMark) {
            parent = ((IMark)entity).getParent();
        } else if (entity instanceof IFolder) {
            parent = ((IFolder)entity).getParent();
        }
        if (parent == null) {
            return;
        }
        if (this.fInput.equals(parent)) {
            return;
        }
        parents.add(parent);
        this.collectParents(parents, (IEntity)parent);
    }

    private void updateFolderAndParents(IFolder folder) {
        HashSet<IFolder> entitiesToUpdate = new HashSet<IFolder>();
        entitiesToUpdate.add(folder);
        ArrayList<IFolder> parents = new ArrayList<IFolder>();
        this.collectParents(parents, (IEntity)folder);
        entitiesToUpdate.addAll(parents);
        if (Controller.getDefault().isShuttingDown()) {
            return;
        }
        this.fViewer.update(entitiesToUpdate.toArray(), null);
    }

    private void getAllMarks(IFolder folder, List<IMark> marks) {
        marks.addAll(folder.getMarks());
        List folders = folder.getFolders();
        for (IFolder childFolder : folders) {
            this.getAllMarks(childFolder, marks);
        }
    }

    private boolean requiresUpdate(Set<NewsEvent> events) {
        for (NewsEvent newsEvent : events) {
            boolean newStateSticky;
            boolean newStateUnread;
            boolean currentStateNew;
            INews oldNews = newsEvent.getOldNews();
            INews currentNews = newsEvent.getEntity();
            boolean oldStateNew = INews.State.NEW.equals((Object)(oldNews != null ? oldNews.getState() : null));
            if (oldStateNew != (currentStateNew = INews.State.NEW.equals((Object)currentNews.getState()))) {
                return true;
            }
            boolean oldStateUnread = CoreUtils.isUnread((INews.State)(oldNews != null ? oldNews.getState() : null));
            if (oldStateUnread != (newStateUnread = CoreUtils.isUnread((INews.State)currentNews.getState()))) {
                return true;
            }
            boolean oldStateSticky = oldNews != null ? oldNews.isFlagged() : false;
            boolean bl = newStateSticky = currentNews.isVisible() && currentNews.isFlagged();
            if (oldStateSticky == newStateSticky) continue;
            return true;
        }
        return false;
    }

    private void expand(IFolder folder) {
        IFolder parent = folder.getParent();
        if (parent != null) {
            this.expand(parent);
        }
        if (folder.getParent() != null) {
            this.fViewer.setExpandedState((Object)folder, true);
        }
    }
}

