/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.undo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.rssowl.core.internal.InternalOwl;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.ui.internal.undo.IUndoOperation;
import org.rssowl.ui.internal.undo.IUndoRedoListener;
import org.rssowl.ui.internal.undo.Messages;

public class UndoStack {
    private static final int MAX_SIZE = 20;
    private static UndoStack singleton = new UndoStack();
    private final List<IUndoOperation> fOperations = Collections.synchronizedList(new ArrayList());
    private int fCurrentIndex = 0;
    private final List<IUndoRedoListener> fListeners = new ArrayList<IUndoRedoListener>();

    private UndoStack() {
    }

    public static UndoStack getInstance() {
        if (singleton == null) {
            singleton = new UndoStack();
        }
        return singleton;
    }

    public void clear() {
        this.fOperations.clear();
    }

    public void addListener(IUndoRedoListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeListener(IUndoRedoListener listener) {
        this.fListeners.remove(listener);
    }

    public synchronized void addOperation(IUndoOperation operation) {
        int i;
        ArrayList<IUndoOperation> toDelete;
        Assert.isNotNull((Object)operation);
        if (this.fCurrentIndex < this.fOperations.size() - 1) {
            toDelete = new ArrayList<IUndoOperation>();
            i = this.fCurrentIndex + 1;
            while (i < this.fOperations.size()) {
                toDelete.add(this.fOperations.get(i));
                ++i;
            }
            this.fOperations.removeAll(toDelete);
        }
        this.fOperations.add(operation);
        if (this.fOperations.size() > 20) {
            toDelete = new ArrayList();
            i = 0;
            while (i < this.fOperations.size() - 20) {
                toDelete.add(this.fOperations.get(i));
                ++i;
            }
            this.fOperations.removeAll(toDelete);
        }
        this.fCurrentIndex = this.fOperations.size() - 1;
        this.notifyOperationAdded();
    }

    public String getUndoName() {
        if (!this.isUndoSupported()) {
            return Messages.UndoStack_UNDO;
        }
        return NLS.bind((String)Messages.UndoStack_UNDO_N, (Object)this.fOperations.get(this.fCurrentIndex).getName());
    }

    public String getRedoName() {
        if (!this.isRedoSupported()) {
            return Messages.UndoStack_REDO;
        }
        return NLS.bind((String)Messages.UndoStack_REDO_N, (Object)this.fOperations.get(this.fCurrentIndex + 1).getName());
    }

    public boolean isUndoSupported() {
        return this.fCurrentIndex >= 0 && !this.fOperations.isEmpty();
    }

    public boolean isRedoSupported() {
        return this.fCurrentIndex < this.fOperations.size() - 1;
    }

    public synchronized void undo() {
        if (!this.isUndoSupported()) {
            return;
        }
        final IUndoOperation undoOperation = this.fOperations.get(this.fCurrentIndex);
        Runnable undoRunnable = new Runnable(){

            public void run() {
                undoOperation.undo();
            }
        };
        if (undoOperation.isLongRunning() && !InternalOwl.TESTING) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)undoRunnable);
        } else {
            undoRunnable.run();
        }
        --this.fCurrentIndex;
        this.notifyUndoPerformed();
    }

    public synchronized void redo() {
        if (!this.isRedoSupported()) {
            return;
        }
        ++this.fCurrentIndex;
        final IUndoOperation redoOperation = this.fOperations.get(this.fCurrentIndex);
        Runnable redoRunnable = new Runnable(){

            public void run() {
                redoOperation.redo();
            }
        };
        if (redoOperation.isLongRunning() && !InternalOwl.TESTING) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)redoRunnable);
        } else {
            redoRunnable.run();
        }
        this.notifyRedoPerformed();
    }

    private void notifyUndoPerformed() {
        for (final IUndoRedoListener listener : this.fListeners) {
            SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    listener.undoPerformed();
                }
            });
        }
    }

    private void notifyRedoPerformed() {
        for (final IUndoRedoListener listener : this.fListeners) {
            SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    listener.redoPerformed();
                }
            });
        }
    }

    private void notifyOperationAdded() {
        for (final IUndoRedoListener listener : this.fListeners) {
            SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    listener.operationAdded();
                }
            });
        }
    }
}

