/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IMark;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.dialogs.properties.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadingPropertyPage
implements IEntityPropertyPage {
    private List<IEntity> fEntities;
    private ArrayList<IPreferenceScope> fEntityPreferences;
    private boolean fPrefMarkReadState;
    private int fPrefMarkReadVal;
    private boolean fPrefMarkReadOnMinimize;
    private boolean fPrefMarkReadOnScrolling;
    private boolean fPrefMarkReadOnTabClose;
    private boolean fPrefMarkReadOnFeedChange;
    private Button fMarkReadStateCheck;
    private Spinner fMarkReadAfterSpinner;
    private Button fMarkReadOnMinimize;
    private Button fMarkReadOnScrolling;
    private Button fMarkReadOnChange;
    private boolean fSettingsChanged;
    private Button fMarkReadOnTabClose;

    @Override
    public void init(IPropertyDialogSite site, List<IEntity> entities) {
        Assert.isTrue((!entities.isEmpty() ? 1 : 0) != 0);
        this.fEntities = entities;
        this.fEntityPreferences = new ArrayList(this.fEntities.size());
        for (IEntity entity : entities) {
            this.fEntityPreferences.add(Owl.getPreferenceService().getEntityScope(entity));
        }
        this.loadInitialSettings();
    }

    private void loadInitialSettings() {
        IPreferenceScope firstScope = this.fEntityPreferences.get(0);
        this.fPrefMarkReadState = firstScope.getBoolean(DefaultPreferences.MARK_READ_STATE);
        this.fPrefMarkReadVal = firstScope.getInteger(DefaultPreferences.MARK_READ_IN_MILLIS);
        this.fPrefMarkReadOnMinimize = firstScope.getBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE);
        this.fPrefMarkReadOnScrolling = firstScope.getBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING);
        this.fPrefMarkReadOnTabClose = firstScope.getBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE);
        this.fPrefMarkReadOnFeedChange = firstScope.getBoolean(DefaultPreferences.MARK_READ_ON_CHANGE);
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        int i = 1;
        while (i < this.fEntityPreferences.size()) {
            IPreferenceScope otherScope = this.fEntityPreferences.get(i);
            if (otherScope.getBoolean(DefaultPreferences.MARK_READ_STATE) != this.fPrefMarkReadState) {
                this.fPrefMarkReadState = defaultScope.getBoolean(DefaultPreferences.MARK_READ_STATE);
            }
            if (otherScope.getInteger(DefaultPreferences.MARK_READ_IN_MILLIS) != this.fPrefMarkReadVal) {
                this.fPrefMarkReadVal = defaultScope.getInteger(DefaultPreferences.MARK_READ_IN_MILLIS);
            }
            if (otherScope.getBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE) != this.fPrefMarkReadOnMinimize) {
                this.fPrefMarkReadOnMinimize = defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE);
            }
            if (otherScope.getBoolean(DefaultPreferences.MARK_READ_ON_CHANGE) != this.fPrefMarkReadOnFeedChange) {
                this.fPrefMarkReadOnFeedChange = defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_CHANGE);
            }
            if (otherScope.getBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE) != this.fPrefMarkReadOnTabClose) {
                this.fPrefMarkReadOnTabClose = defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE);
            }
            if (otherScope.getBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING) != this.fPrefMarkReadOnScrolling) {
                this.fPrefMarkReadOnScrolling = defaultScope.getBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING);
            }
            ++i;
        }
    }

    @Override
    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(1, 10, 10));
        Composite markReadAfterContainer = new Composite(container, 0);
        markReadAfterContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
        this.fMarkReadStateCheck = new Button(markReadAfterContainer, 32);
        this.fMarkReadStateCheck.setText(Messages.ReadingPropertyPage_MARK_READ_AFTER);
        this.fMarkReadStateCheck.setSelection(this.fPrefMarkReadState);
        this.fMarkReadStateCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReadingPropertyPage.this.fMarkReadAfterSpinner.setEnabled(ReadingPropertyPage.this.fMarkReadStateCheck.getSelection());
            }
        });
        this.fMarkReadAfterSpinner = new Spinner(markReadAfterContainer, 2048);
        this.fMarkReadAfterSpinner.setMinimum(0);
        this.fMarkReadAfterSpinner.setMaximum(100);
        this.fMarkReadAfterSpinner.setSelection(this.fPrefMarkReadVal / 1000);
        this.fMarkReadAfterSpinner.setEnabled(this.fMarkReadStateCheck.getSelection());
        Label label = new Label(markReadAfterContainer, 0);
        label.setText(Messages.ReadingPropertyPage_SECONDS);
        this.fMarkReadOnScrolling = new Button(container, 32);
        this.fMarkReadOnScrolling.setText(Messages.ReadingPropertyPage_MARK_READ_ON_SCROLLING);
        this.fMarkReadOnScrolling.setSelection(this.fPrefMarkReadOnScrolling);
        this.fMarkReadOnChange = new Button(container, 32);
        this.fMarkReadOnChange.setText(Messages.ReadingPropertyPage_MARK_READ_ON_SWITCH);
        this.fMarkReadOnChange.setSelection(this.fPrefMarkReadOnFeedChange);
        this.fMarkReadOnTabClose = new Button(container, 32);
        this.fMarkReadOnTabClose.setText(Messages.ReadingPropertyPage_MARK_READ_ON_CLOSE);
        this.fMarkReadOnTabClose.setSelection(this.fPrefMarkReadOnTabClose);
        this.fMarkReadOnMinimize = new Button(container, 32);
        this.fMarkReadOnMinimize.setText(Messages.ReadingPropertyPage_MARK_READ_ON_MINIMIZE);
        this.fMarkReadOnMinimize.setSelection(this.fPrefMarkReadOnMinimize);
        return container;
    }

    @Override
    public ImageDescriptor getImage() {
        return null;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public boolean performOk(Set<IEntity> entitiesToSave) {
        this.fSettingsChanged = false;
        for (IPreferenceScope scope : this.fEntityPreferences) {
            if (!this.updatePreferences(scope)) continue;
            IEntity entityToSave = this.fEntities.get(this.fEntityPreferences.indexOf(scope));
            entitiesToSave.add(entityToSave);
            this.fSettingsChanged = true;
        }
        for (IEntity entity : this.fEntities) {
            if (!this.fSettingsChanged || !(entity instanceof IFolder)) continue;
            this.updateChildPreferences((IFolder)entity);
        }
        return true;
    }

    private void updateChildPreferences(IFolder folder) {
        List marks = folder.getMarks();
        for (IMark mark : marks) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)mark);
            this.updatePreferences(scope);
        }
        List folders = folder.getFolders();
        for (IFolder childFolder : folders) {
            IPreferenceScope scope = Owl.getPreferenceService().getEntityScope((IEntity)childFolder);
            this.updatePreferences(scope);
            this.updateChildPreferences(childFolder);
        }
    }

    private boolean updatePreferences(IPreferenceScope scope) {
        int iVal;
        boolean changed = false;
        boolean bVal = this.fMarkReadStateCheck.getSelection();
        if (this.fPrefMarkReadState != bVal) {
            scope.putBoolean(DefaultPreferences.MARK_READ_STATE, bVal);
            changed = true;
        }
        if (this.fPrefMarkReadVal != (iVal = this.fMarkReadAfterSpinner.getSelection())) {
            scope.putInteger(DefaultPreferences.MARK_READ_IN_MILLIS, iVal * 1000);
            changed = true;
        }
        if (this.fPrefMarkReadOnMinimize != (bVal = this.fMarkReadOnMinimize.getSelection())) {
            scope.putBoolean(DefaultPreferences.MARK_READ_ON_MINIMIZE, bVal);
            changed = true;
        }
        if (this.fPrefMarkReadOnFeedChange != (bVal = this.fMarkReadOnChange.getSelection())) {
            scope.putBoolean(DefaultPreferences.MARK_READ_ON_CHANGE, bVal);
            changed = true;
        }
        if (this.fPrefMarkReadOnTabClose != (bVal = this.fMarkReadOnTabClose.getSelection())) {
            scope.putBoolean(DefaultPreferences.MARK_READ_ON_TAB_CLOSE, bVal);
            changed = true;
        }
        if (this.fPrefMarkReadOnScrolling != (bVal = this.fMarkReadOnScrolling.getSelection())) {
            scope.putBoolean(DefaultPreferences.MARK_READ_ON_SCROLLING, bVal);
            changed = true;
        }
        return changed;
    }

    @Override
    public void finish() {
    }
}

