/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.rssowl.core.persist.IEntity;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityPropertyPageWrapper
implements Comparable<EntityPropertyPageWrapper> {
    private String fId;
    private IEntityPropertyPage fCachedPage;
    private IConfigurationElement fPageTemplate;
    private String fName;
    private int fOrder;
    private boolean fHandlesMultipleEntities;
    private List<Class<?>> fTargetEntities;

    public EntityPropertyPageWrapper(String id, IConfigurationElement pageTemplate, List<Class<?>> targetEntities, String name, int order, boolean handlesMultipleEntities) {
        this.fId = id;
        this.fPageTemplate = pageTemplate;
        this.fTargetEntities = targetEntities;
        this.fName = name;
        this.fOrder = order;
        this.fHandlesMultipleEntities = handlesMultipleEntities;
    }

    public IEntityPropertyPage getPage() {
        Assert.isNotNull((Object)this.fCachedPage, (String)"Call createPage() first!");
        return this.fCachedPage;
    }

    public void createPage() {
        try {
            this.fCachedPage = (IEntityPropertyPage)this.fPageTemplate.createExecutableExtension("class");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public String getName() {
        return this.fName;
    }

    public List<Class<?>> getTargetEntities() {
        return this.fTargetEntities;
    }

    public boolean handles(Set<Class<? extends IEntity>> classes) {
        if (this.fTargetEntities.size() == 0) {
            return false;
        }
        for (Class<? extends IEntity> clazz : classes) {
            if (this.handles(clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean handles(Class<? extends IEntity> clazz) {
        for (Class<? extends IEntity> clazz2 : this.fTargetEntities) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean isHandlingMultipleEntities() {
        return this.fHandlesMultipleEntities;
    }

    @Override
    public int compareTo(EntityPropertyPageWrapper other) {
        if (this.fOrder < other.fOrder) {
            return -1;
        }
        if (this.fOrder > other.fOrder) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPropertyPageWrapper other = (EntityPropertyPageWrapper)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }
}

