/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.properties;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.dialogs.properties.IEntityPropertyPage;
import org.rssowl.ui.dialogs.properties.IPropertyDialogSite;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.properties.EntityPropertyPageWrapper;
import org.rssowl.ui.internal.dialogs.properties.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityPropertyDialog
extends Dialog
implements IPropertyDialogSite {
    private List<IEntity> fEntities;
    private String fTitle;
    private Set<EntityPropertyPageWrapper> fPages = new TreeSet<EntityPropertyPageWrapper>();
    private Set<IEntityPropertyPage> fCreatedPages = new HashSet<IEntityPropertyPage>();
    private Label fMessageText;
    private Label fMessageImage;
    private LocalResourceManager fResources;
    private TabFolder fTabFolder;
    private String fInitialMessage;
    private IPropertyDialogSite.MessageType fInitialMessageType;
    private boolean fEntitiesUpdated;

    public EntityPropertyDialog(Shell parentShell, List<IEntity> entities) {
        super(parentShell);
        this.fEntities = entities;
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
    }

    public void addPage(EntityPropertyPageWrapper page) {
        this.fPages.add(page);
        page.getPage().init(this, this.fEntities);
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public boolean close() {
        super.close();
        this.fResources.dispose();
        return true;
    }

    protected void okPressed() {
        final boolean[] proceed = new boolean[]{true};
        final HashSet entitiesToSave = new HashSet();
        Iterator<EntityPropertyPageWrapper> iterator = this.fPages.iterator();
        while (iterator.hasNext() && proceed[0]) {
            final EntityPropertyPageWrapper pageWrapper = iterator.next();
            if (!this.fCreatedPages.contains(pageWrapper.getPage())) continue;
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    proceed[0] = pageWrapper.getPage().performOk(entitiesToSave);
                }
            });
        }
        if (!proceed[0]) {
            return;
        }
        this.fEntitiesUpdated = !entitiesToSave.isEmpty();
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                for (IEntity entity : entitiesToSave) {
                    DynamicDAO.save((IPersistable)entity);
                }
            }
        });
        for (EntityPropertyPageWrapper pageWrapper : this.fPages) {
            if (!this.fCreatedPages.contains(pageWrapper.getPage())) continue;
            pageWrapper.getPage().finish();
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (StringUtils.isSet((String)this.fTitle)) {
            shell.setText(NLS.bind((String)Messages.EntityPropertyDialog_PROPERTIES_FOR_N, (Object)this.fTitle));
        } else {
            shell.setText(Messages.EntityPropertyDialog_PROPERTIES);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 0, 3));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridLayout)composite.getLayout()).marginTop = 10;
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityPropertyDialog.this.onTabSelect(e);
            }
        });
        int i = 0;
        for (EntityPropertyPageWrapper pageWrapper : this.fPages) {
            TabItem item = new TabItem(this.fTabFolder, 0);
            IEntityPropertyPage page = pageWrapper.getPage();
            item.setData((Object)page);
            item.setText(pageWrapper.getName());
            if (page.getImage() != null) {
                item.setImage(OwlUI.getImage((ResourceManager)this.fResources, page.getImage()));
            }
            if (i == 0) {
                item.setControl(page.createContents((Composite)this.fTabFolder));
                this.fCreatedPages.add(page);
                page.setFocus();
            }
            ++i;
        }
        this.fMessageImage = new Label(composite, 0);
        this.fMessageImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ((GridData)this.fMessageImage.getLayoutData()).widthHint = 16;
        ((GridData)this.fMessageImage.getLayoutData()).heightHint = 16;
        this.fMessageText = new Label(composite, 0);
        this.fMessageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.fInitialMessage != null && this.fInitialMessageType != null) {
            this.setMessage(this.fInitialMessage, this.fInitialMessageType);
        }
        EntityPropertyDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void onTabSelect(SelectionEvent e) {
        if (e.item instanceof TabItem && e.item.getData() instanceof IEntityPropertyPage) {
            TabItem item = (TabItem)e.item;
            IEntityPropertyPage page = (IEntityPropertyPage)e.item.getData();
            if (item.getControl() == null) {
                item.setControl(page.createContents((Composite)this.fTabFolder));
                this.fCreatedPages.add(page);
                Shell shell = this.getShell();
                Point requiredSize = this.getRequiredSize(shell);
                Point currentSize = shell.getSize();
                if (requiredSize.x > currentSize.x || requiredSize.y > currentSize.y) {
                    shell.setSize(new Point(Math.max(currentSize.x, requiredSize.x), Math.max(currentSize.y, requiredSize.y)));
                }
            }
            page.setFocus();
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)super.createButtonBar(parent);
        int marginHeight = ((GridLayout)buttonBar.getLayout()).marginHeight;
        ((GridLayout)buttonBar.getLayout()).marginHeight = 0;
        ((GridLayout)buttonBar.getLayout()).marginTop = 3;
        ((GridLayout)buttonBar.getLayout()).marginBottom = marginHeight;
        return buttonBar;
    }

    protected int getShellStyle() {
        int style = 0x10860 | EntityPropertyDialog.getDefaultOrientation();
        return style;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(320);
        int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
        Point requiredSize = this.getRequiredSize(shell);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        LayoutUtils.positionShell(shell);
    }

    private Point getRequiredSize(Shell shell) {
        Point requiredSize = shell.computeSize(-1, -1);
        if (this.displaysSavedSearch()) {
            if (Application.IS_LINUX) {
                requiredSize.x += 100;
            } else if (Application.IS_MAC) {
                requiredSize.x += 50;
            }
        }
        return requiredSize;
    }

    private boolean displaysSavedSearch() {
        for (IEntity entity : this.fEntities) {
            if (!(entity instanceof ISearchMark)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getHorizontalPixels(int dlus) {
        return this.convertHorizontalDLUsToPixels(dlus);
    }

    @Override
    public void setMessage(String message, IPropertyDialogSite.MessageType type) {
        if (message == null) {
            message = "";
        }
        if (this.fMessageImage == null || this.fMessageText == null) {
            this.fInitialMessage = message;
            this.fInitialMessageType = type;
            return;
        }
        if (message.length() == 0) {
            this.fMessageImage.setImage(null);
        } else if (type.equals((Object)IPropertyDialogSite.MessageType.INFO)) {
            this.fMessageImage.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.INFO));
        } else if (type.equals((Object)IPropertyDialogSite.MessageType.WARNING)) {
            this.fMessageImage.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.WARNING));
        } else if (type.equals((Object)IPropertyDialogSite.MessageType.ERROR)) {
            this.fMessageImage.setImage(OwlUI.getImage((ResourceManager)this.fResources, OwlUI.ERROR));
        }
        this.fMessageText.setText(message);
    }

    @Override
    public void select(IEntityPropertyPage page) {
        TabItem[] items;
        Assert.isNotNull((Object)page);
        if (this.fTabFolder.isDisposed()) {
            return;
        }
        TabItem[] tabItemArray = items = this.fTabFolder.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem tabItem = tabItemArray[n2];
            if (page.equals(tabItem.getData())) {
                this.fTabFolder.setSelection(tabItem);
                break;
            }
            ++n2;
        }
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.fResources;
    }

    public boolean entitiesUpdated() {
        return this.fEntitiesUpdated;
    }

    @Override
    public void contentsChanged() {
        Shell shell = this.getShell();
        Point requiredSize = this.getRequiredSize(shell);
        Point currentSize = shell.getSize();
        if (requiredSize.x > currentSize.x || requiredSize.y > currentSize.y) {
            shell.setSize(new Point(Math.max(currentSize.x, requiredSize.x), Math.max(currentSize.y, requiredSize.y)));
        }
    }
}

