/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.preferences;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.IConnectionService;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.ICredentialsProvider;
import org.rssowl.core.connection.PlatformCredentialsProvider;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.AddCredentialsDialog;
import org.rssowl.ui.internal.dialogs.ConfirmDialog;
import org.rssowl.ui.internal.dialogs.preferences.Messages;
import org.rssowl.ui.internal.util.CColumnLayoutData;
import org.rssowl.ui.internal.util.CTable;
import org.rssowl.ui.internal.util.LayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CredentialsPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.rssowl.ui.CredentialsPreferences";
    private static final String DUMMY_LINK = "http://www.rssowl.org";
    private IConnectionService fConService = Owl.getConnectionService();
    private TableViewer fViewer;
    private Button fAddCredentials;
    private Button fRemoveAll;
    private Button fRemoveSelected;
    private Button fUseMasterPasswordCheck;
    private IPreferenceScope fGlobalScope = Owl.getPreferenceService().getGlobalScope();
    private Button fChangeMasterPassword;
    private Button fResetMasterPassword;
    private boolean fIsError = false;

    public CredentialsPreferencesPage() {
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/elcl16/passwords.gif"));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = this.createComposite(parent);
        Composite masterContainer = new Composite(container, 0);
        masterContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        masterContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
        ((GridLayout)masterContainer.getLayout()).marginBottom = 15;
        ((GridLayout)masterContainer.getLayout()).verticalSpacing = 10;
        Label infoText = new Label(masterContainer, 64);
        infoText.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        ((GridData)infoText.getLayoutData()).widthHint = 200;
        if (Application.IS_WINDOWS || Application.IS_MAC) {
            infoText.setText(Messages.CredentialsPreferencesPage_MASTER_PW_INFO);
        } else {
            infoText.setText(Messages.CredentialsPreferencesPage_MASTER_PW_MSG);
        }
        this.fUseMasterPasswordCheck = new Button(masterContainer, 32);
        this.fUseMasterPasswordCheck.setText(Messages.CredentialsPreferencesPage_USE_MASTER_PW);
        this.fUseMasterPasswordCheck.setFocus();
        this.fUseMasterPasswordCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.fUseMasterPasswordCheck.setSelection(this.fGlobalScope.getBoolean(DefaultPreferences.USE_MASTER_PASSWORD));
        this.fUseMasterPasswordCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CredentialsPreferencesPage.this.fUseMasterPasswordCheck.getSelection()) {
                    CredentialsPreferencesPage.this.fChangeMasterPassword.setEnabled(false);
                }
            }
        });
        this.fChangeMasterPassword = new Button(masterContainer, 8);
        this.fChangeMasterPassword.setEnabled(this.fUseMasterPasswordCheck.getSelection());
        this.fChangeMasterPassword.setText(Messages.CredentialsPreferencesPage_CHANGE_MASTER_PW);
        Dialog.applyDialogFont((Control)this.fChangeMasterPassword);
        this.setButtonLayoutData(this.fChangeMasterPassword);
        this.fChangeMasterPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsPreferencesPage.this.onChangeMasterPassword();
            }
        });
        this.fResetMasterPassword = new Button(masterContainer, 8);
        this.fResetMasterPassword.setEnabled(false);
        this.fResetMasterPassword.setText(Messages.CredentialsPreferencesPage_RESET);
        Dialog.applyDialogFont((Control)this.fResetMasterPassword);
        this.setButtonLayoutData(this.fResetMasterPassword);
        this.fResetMasterPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsPreferencesPage.this.onResetMasterPassword();
            }
        });
        Label infoLabel = new Label(container, 0);
        infoLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        infoLabel.setText(Messages.CredentialsPreferencesPage_SAVED_PWS);
        int style = 67586;
        CTable customTable = new CTable(container, style);
        customTable.getControl().setHeaderVisible(true);
        this.fViewer = new TableViewer(customTable.getControl());
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ((GridData)this.fViewer.getTable().getLayoutData()).heightHint = 190;
        this.fViewer.getControl().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        TableViewerColumn col = new TableViewerColumn(this.fViewer, 16384);
        customTable.manageColumn(col.getColumn(), new CColumnLayoutData(CColumnLayoutData.Size.FILL, 45), Messages.CredentialsPreferencesPage_SITE, null, null, false, true);
        col.getColumn().setMoveable(false);
        col = new TableViewerColumn(this.fViewer, 16384);
        customTable.manageColumn(col.getColumn(), new CColumnLayoutData(CColumnLayoutData.Size.FILL, 30), Messages.CredentialsPreferencesPage_REALM, null, null, false, true);
        col.getColumn().setMoveable(false);
        col = new TableViewerColumn(this.fViewer, 16384);
        customTable.manageColumn(col.getColumn(), new CColumnLayoutData(CColumnLayoutData.Size.FILL, 25), Messages.CredentialsPreferencesPage_USERNAME, null, null, false, true);
        col.getColumn().setMoveable(false);
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Set credentials = CredentialsPreferencesPage.this.loadCredentials();
                return credentials.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                CredentialsModelData data = (CredentialsModelData)cell.getElement();
                switch (cell.getColumnIndex()) {
                    case 0: {
                        String link = data.getNormalizedLink().toString();
                        if ("https://www.google.com/accounts/ClientLogin".equals(link)) {
                            cell.setText("Google Reader");
                            break;
                        }
                        cell.setText(link);
                        break;
                    }
                    case 1: {
                        cell.setText(data.getRealm());
                        break;
                    }
                    case 2: {
                        cell.setText(data.getUsername());
                    }
                }
            }
        });
        this.fViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                CredentialsModelData data1 = (CredentialsModelData)e1;
                CredentialsModelData data2 = (CredentialsModelData)e2;
                return data1.getNormalizedLink().toString().compareTo(data2.getNormalizedLink().toString());
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(3, 0, 0));
        this.fAddCredentials = new Button(buttonContainer, 8);
        this.fAddCredentials.setText(Messages.CredentialsPreferencesPage_ADD);
        this.fAddCredentials.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsPreferencesPage.this.onAdd();
            }
        });
        this.fRemoveSelected = new Button(buttonContainer, 8);
        this.fRemoveSelected.setText(Messages.CredentialsPreferencesPage_REMOVE);
        this.fRemoveSelected.setEnabled(false);
        this.fRemoveSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsPreferencesPage.this.onRemove();
            }
        });
        this.fRemoveAll = new Button(buttonContainer, 8);
        this.fRemoveAll.setText(Messages.CredentialsPreferencesPage_REMOVE_ALL);
        this.fRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CredentialsPreferencesPage.this.onRemoveAll();
            }
        });
        Dialog.applyDialogFont((Control)this.fAddCredentials);
        Dialog.applyDialogFont((Control)this.fRemoveSelected);
        Dialog.applyDialogFont((Control)this.fRemoveAll);
        this.setButtonLayoutData(this.fAddCredentials);
        this.setButtonLayoutData(this.fRemoveSelected);
        this.setButtonLayoutData(this.fRemoveAll);
        ((GridData)this.fRemoveAll.getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)this.fRemoveAll.getLayoutData()).horizontalAlignment = 1;
        this.fViewer.setInput(new Object());
        this.fRemoveAll.setEnabled(this.fViewer.getTable().getItemCount() > 0);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CredentialsPreferencesPage.this.fRemoveSelected.setEnabled(!CredentialsPreferencesPage.this.fViewer.getSelection().isEmpty());
            }
        });
        this.applyDialogFont(container);
        OwlUI.runOnSelection(new Runnable(){

            public void run() {
                CredentialsPreferencesPage.this.updateApplyEnablement(true);
            }
        }, new Control[]{container});
        return container;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.getDefaultsButton() != null && this.fIsError) {
            this.getDefaultsButton().setEnabled(false);
        }
        this.updateApplyEnablement(false);
    }

    private void onAdd() {
        AddCredentialsDialog dialog = new AddCredentialsDialog(this.getShell());
        if (dialog.open() == 0) {
            String site = dialog.getSite();
            final String username = dialog.getUsername();
            final String password = dialog.getPassword();
            try {
                URI siteUri = new URI(site);
                ICredentialsProvider credentialsProvider = Owl.getConnectionService().getCredentialsProvider(siteUri);
                if (credentialsProvider != null) {
                    credentialsProvider.setAuthCredentials(new ICredentials(){

                        public String getUsername() {
                            return username;
                        }

                        public String getPassword() {
                            return password;
                        }

                        public String getDomain() {
                            return null;
                        }
                    }, siteUri, null);
                    this.fViewer.refresh();
                    this.fRemoveSelected.setEnabled(!this.fViewer.getSelection().isEmpty());
                    this.fRemoveAll.setEnabled(this.fViewer.getTable().getItemCount() > 0);
                }
            }
            catch (URISyntaxException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CredentialsException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                this.setShowError(true);
            }
        }
    }

    private void onChangeMasterPassword() {
        this.reSetAllCredentials();
    }

    private void onResetMasterPassword() {
        ConfirmDialog dialog = new ConfirmDialog(this.getShell(), Messages.CredentialsPreferencesPage_CONFIRM_RESET, Messages.CredentialsPreferencesPage_NO_UNDO, Messages.CredentialsPreferencesPage_RESET_PASSWORDS, Messages.CredentialsPreferencesPage_RESET_TITLE, null){

            public void setTitle(String newTitle) {
                super.setTitle(Messages.CredentialsPreferencesPage_RESET_TITLE);
            }
        };
        if (dialog.open() == 0) {
            ICredentialsProvider provider = Owl.getConnectionService().getCredentialsProvider(URI.create(DUMMY_LINK));
            ((PlatformCredentialsProvider)provider).clear();
            this.reSetAllCredentials();
            this.setShowError(false);
            this.fResetMasterPassword.setEnabled(false);
        }
    }

    private void onRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        List credentialsToRemove = selection.toList();
        for (Object obj : credentialsToRemove) {
            CredentialsModelData data = (CredentialsModelData)obj;
            this.remove(data, false);
        }
        this.fViewer.refresh();
        this.fRemoveSelected.setEnabled(!this.fViewer.getSelection().isEmpty());
        this.fRemoveAll.setEnabled(this.fViewer.getTable().getItemCount() > 0);
    }

    private void onRemoveAll() {
        ConfirmDialog dialog = new ConfirmDialog(this.getShell(), Messages.CredentialsPreferencesPage_CONFIRM_REMOVE, Messages.CredentialsPreferencesPage_NO_UNDO, Messages.CredentialsPreferencesPage_REMOVE_ALL_CONFIRM, null);
        if (dialog.open() != 0) {
            return;
        }
        Set<CredentialsModelData> credentials = this.loadCredentials();
        for (CredentialsModelData data : credentials) {
            this.remove(data, true);
        }
        this.fViewer.refresh();
        this.fRemoveSelected.setEnabled(!this.fViewer.getSelection().isEmpty());
        this.fRemoveAll.setEnabled(this.fViewer.getTable().getItemCount() > 0);
    }

    private void remove(CredentialsModelData data, boolean all) {
        ICredentialsProvider provider = this.fConService.getCredentialsProvider(data.getNormalizedLink());
        if (provider != null) {
            try {
                provider.deleteAuthCredentials(data.getNormalizedLink(), data.getRealm());
            }
            catch (CredentialsException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        if (all) {
            Collection bookmarks = DynamicDAO.loadAll(IBookMark.class);
            for (IBookMark bookmark : bookmarks) {
                String realm = (String)bookmark.getProperty("org.rssowl.ui.BMRealmProperty");
                URI feedLink = bookmark.getFeedLinkReference().getLink();
                URI normalizedLink = URIUtils.normalizeUri((URI)feedLink, (boolean)true);
                if (realm != null && !realm.equals(data.getRealm()) || !normalizedLink.equals(data.getNormalizedLink()) || (provider = this.fConService.getCredentialsProvider(feedLink)) == null) continue;
                try {
                    provider.deleteAuthCredentials(feedLink, null);
                    bookmark.removeProperty("org.rssowl.ui.BMRealmProperty");
                }
                catch (CredentialsException e) {
                    Activator.getDefault().logError(e.getMessage(), e);
                }
            }
        }
    }

    private Set<CredentialsModelData> loadCredentials() {
        HashSet<CredentialsModelData> credentials = new HashSet<CredentialsModelData>();
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        Collection bookmarks = DynamicDAO.loadAll(IBookMark.class);
        for (IBookMark bookmark : bookmarks) {
            String realm = (String)bookmark.getProperty("org.rssowl.ui.BMRealmProperty");
            URI feedLink = bookmark.getFeedLinkReference().getLink();
            pairs.add(Pair.create((Object)feedLink, (Object)realm));
        }
        pairs.add(Pair.create((Object)URI.create("https://www.google.com/accounts/ClientLogin"), null));
        for (Pair pair : pairs) {
            URI feedLink = (URI)pair.getFirst();
            String realm = (String)pair.getSecond();
            URI normalizedLink = URIUtils.normalizeUri((URI)feedLink, (boolean)true);
            try {
                CredentialsModelData data = this.loadCredentials(normalizedLink, realm);
                if (data != null) {
                    credentials.add(data);
                }
                if ((data = this.loadCredentials(feedLink, realm)) != null) {
                    credentials.add(data);
                }
                if ((data = this.loadCredentials(feedLink, null)) == null) continue;
                credentials.add(data);
            }
            catch (CredentialsException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                this.setShowError(true);
                break;
            }
        }
        return credentials;
    }

    private CredentialsModelData loadCredentials(URI link, String realm) throws CredentialsException {
        ICredentials authCredentials;
        ICredentialsProvider credentialsProvider;
        if (StringUtils.isSet((String)link.getScheme()) && (credentialsProvider = this.fConService.getCredentialsProvider(link)) != null && (authCredentials = credentialsProvider.getPersistedAuthCredentials(link, realm)) != null) {
            return new CredentialsModelData(authCredentials.getUsername(), authCredentials.getPassword(), link, realm);
        }
        return null;
    }

    private void setShowError(boolean isError) {
        this.fIsError = isError;
        if (isError) {
            this.setErrorMessage(Messages.CredentialsPreferencesPage_WRONG_MASTER_PW);
        } else {
            this.setErrorMessage(null);
        }
        this.fUseMasterPasswordCheck.setEnabled(!isError);
        this.fChangeMasterPassword.setEnabled(!isError && this.fUseMasterPasswordCheck.getSelection());
        this.fResetMasterPassword.setEnabled(isError);
        this.fViewer.getTable().setEnabled(!isError);
        this.fAddCredentials.setEnabled(!isError);
        if (this.getDefaultsButton() != null) {
            this.getDefaultsButton().setEnabled(!isError);
        }
        if (this.getApplyButton() != null) {
            this.getApplyButton().setEnabled(!isError);
        }
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        return composite;
    }

    public boolean performOk() {
        boolean oldUseMasterPassword = this.fGlobalScope.getBoolean(DefaultPreferences.USE_MASTER_PASSWORD);
        boolean newUseMasterPassword = this.fUseMasterPasswordCheck.getSelection();
        this.fGlobalScope.putBoolean(DefaultPreferences.USE_MASTER_PASSWORD, this.fUseMasterPasswordCheck.getSelection());
        if (oldUseMasterPassword != newUseMasterPassword) {
            this.reSetAllCredentials();
        }
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
        this.updateApplyEnablement(false);
        this.fChangeMasterPassword.setEnabled(this.fUseMasterPasswordCheck.getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        this.fUseMasterPasswordCheck.setSelection(defaultScope.getBoolean(DefaultPreferences.USE_MASTER_PASSWORD));
        this.fChangeMasterPassword.setEnabled(this.fUseMasterPasswordCheck.getSelection());
        this.updateApplyEnablement(true);
    }

    private void reSetAllCredentials() {
        ICredentialsProvider credentialsProvider;
        boolean clearedOnce = false;
        Set<CredentialsModelData> credentials = this.loadCredentials();
        CredentialsModelData dummyCredentials = null;
        if (credentials.isEmpty()) {
            try {
                dummyCredentials = new CredentialsModelData("", "", new URI(DUMMY_LINK), "");
                credentials.add(dummyCredentials);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        for (CredentialsModelData credential : credentials) {
            ICredentialsProvider credentialsProvider2 = Owl.getConnectionService().getCredentialsProvider(credential.fNormalizedLink);
            if (credentialsProvider2 == null) continue;
            if (!clearedOnce && credentialsProvider2 instanceof PlatformCredentialsProvider) {
                ((PlatformCredentialsProvider)credentialsProvider2).clear();
                clearedOnce = true;
            }
            try {
                credentialsProvider2.setAuthCredentials(credential.toCredentials(), credential.fNormalizedLink, credential.fRealm);
            }
            catch (CredentialsException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        if (dummyCredentials != null && (credentialsProvider = Owl.getConnectionService().getCredentialsProvider(dummyCredentials.fNormalizedLink)) != null) {
            try {
                credentialsProvider.deleteAuthCredentials(dummyCredentials.fNormalizedLink, dummyCredentials.fRealm);
            }
            catch (CredentialsException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    private void updateApplyEnablement(boolean enable) {
        Button applyButton;
        if (this.fIsError) {
            enable = false;
        }
        if ((applyButton = this.getApplyButton()) != null && !applyButton.isDisposed() && applyButton.isEnabled() != enable) {
            applyButton.setEnabled(enable);
        }
    }

    private static class CredentialsModelData {
        private URI fNormalizedLink;
        private String fRealm;
        private String fUsername;
        private String fPassword;

        CredentialsModelData(String username, String password, URI normalizedLink, String realm) {
            this.fUsername = username;
            this.fPassword = password;
            this.fNormalizedLink = normalizedLink;
            this.fRealm = realm;
        }

        String getUsername() {
            return this.fUsername;
        }

        URI getNormalizedLink() {
            return this.fNormalizedLink;
        }

        String getRealm() {
            return this.fRealm;
        }

        ICredentials toCredentials() {
            return new ICredentials(){

                public String getDomain() {
                    return "";
                }

                public String getPassword() {
                    return CredentialsModelData.this.fPassword;
                }

                public String getUsername() {
                    return CredentialsModelData.this.fUsername;
                }
            };
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fNormalizedLink == null ? 0 : this.fNormalizedLink.hashCode());
            result = 31 * result + (this.fRealm == null ? 0 : this.fRealm.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CredentialsModelData other = (CredentialsModelData)obj;
            if (this.fNormalizedLink == null ? other.fNormalizedLink != null : !this.fNormalizedLink.equals(other.fNormalizedLink)) {
                return false;
            }
            return !(this.fRealm == null ? other.fRealm != null : !this.fRealm.equals(other.fRealm));
        }
    }
}

