/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.cleanup;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpGroup;
import org.rssowl.ui.internal.dialogs.cleanup.CleanUpTask;
import org.rssowl.ui.internal.dialogs.cleanup.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsTask
extends CleanUpTask {
    private final Collection<NewsReference> fNews;
    private ImageDescriptor fImage;
    private String fLabel;

    NewsTask(CleanUpGroup group, IBookMark container, Collection<NewsReference> news) {
        super(group);
        Assert.isNotNull((Object)container);
        Assert.isNotNull(news);
        Assert.isTrue((!news.isEmpty() ? 1 : 0) != 0);
        this.fNews = news;
        this.init(container);
    }

    private void init(IBookMark container) {
        this.fLabel = NLS.bind((String)Messages.NewsTask_DELETE_N_NEWS_FROM_M, (Object)this.fNews.size(), (Object)container.getName());
        this.fImage = OwlUI.getFavicon(container);
        if (this.fImage == null) {
            this.fImage = OwlUI.BOOKMARK;
        }
    }

    public Collection<NewsReference> getNews() {
        return this.fNews;
    }

    @Override
    ImageDescriptor getImage() {
        return this.fImage;
    }

    @Override
    String getLabel() {
        return this.fLabel;
    }
}

