/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class StartupProgressDialog
extends ProgressMonitorDialog {
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());

    public StartupProgressDialog() {
        super(null);
    }

    public boolean close() {
        this.fResources.dispose();
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("RSSOwl");
        shell.setCursor(shell.getDisplay().getSystemCursor(3));
        Image img_16x16 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/16x16.png");
        Image img_32x32 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/32x32.png");
        Image img_48x48 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/48x48.png");
        Image img_64x64 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/64x64.png");
        Image img_128x128 = OwlUI.getImage((ResourceManager)this.fResources, "icons/product/128x128.png");
        shell.setImages(new Image[]{img_16x16, img_32x32, img_48x48, img_64x64, img_128x128});
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 0, 0, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Composite titleArea = new Composite(parent, 0);
        titleArea.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0, 0, 0, false));
        titleArea.setBackground(JFaceColors.getBannerBackground((Display)parent.getDisplay()));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)titleArea);
        this.createTitleArea(titleArea);
        Composite contentArea = new Composite(parent, 0);
        Point defaultSpacing = LayoutConstants.getSpacing();
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).spacing(defaultSpacing.x * 2, defaultSpacing.y).numColumns(2).applyTo(contentArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)contentArea);
        this.createDialogAndButtonArea(contentArea);
        return parent;
    }

    private void createTitleArea(Composite parent) {
        Composite messageContainer = new Composite(parent, 0);
        messageContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        messageContainer.setLayout((Layout)LayoutUtils.createGridLayout(1));
        messageContainer.setBackground(parent.getBackground());
        Label titleMessage = new Label(messageContainer, 0);
        titleMessage.setFont(JFaceResources.getBannerFont());
        titleMessage.setText(Messages.StartupProgressDialog_PROGRESS_INFO);
        titleMessage.setBackground(parent.getBackground());
        Label titleFooter = new Label(messageContainer, 0);
        titleFooter.setText(Messages.StartupProgressDialog_PROGRESS_MESSAGE);
        titleFooter.setFont(JFaceResources.getDialogFont());
        titleFooter.setBackground(parent.getBackground());
        GridData data = new GridData(4, 1, true, false);
        data.horizontalIndent = 10;
        data.verticalIndent = 5;
        titleFooter.setLayoutData((Object)data);
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/wizban/welcome_wiz.gif"));
        imageLabel.setBackground(parent.getBackground());
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        separator.setBackground(parent.getBackground());
    }

    protected Image getImage() {
        return null;
    }

    protected void createCancelButton(Composite parent) {
        this.cancel = this.createButton(parent, 1, Messages.StartupProgressDialog_SKIP, true);
        this.setOperationCancelButtonEnabled(this.enableCancelButton);
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle displayBounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Point shellSize = this.getInitialSize();
        int x = displayBounds.x + (displayBounds.width - shellSize.x) >> 1;
        int y = displayBounds.y + (displayBounds.height - shellSize.y) >> 1;
        return new Point(x, y);
    }

    protected Point getInitialSize() {
        int minWidth = 380;
        int minHeight = this.getShell().computeSize((int)minWidth, (int)-1).y;
        return new Point(minWidth, minHeight);
    }
}

