/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.interpreter.ParserException;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.OpenInBrowserAction;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.editors.feed.NewsBrowserLabelProvider;
import org.rssowl.ui.internal.util.CBrowser;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;
import org.rssowl.ui.internal.util.UIBackgroundJob;

public class PreviewFeedDialog
extends Dialog {
    private static final int DIALOG_WIDTH_DLUS = 600;
    private static final int DIALOG_HEIGHT_DLUS = 400;
    private static final String DIALOG_SETTINGS_KEY = "org.rssowl.ui.internal.dialogs.PreviewFeedDialog";
    private static final int MAX_NEWS_SHOWN = 50;
    private IBookMark fBookmark;
    private FeedLinkReference fFeedReference;
    private IFeed fLoadedFeed;
    private CBrowser fBrowser;
    private boolean fFirstTimeOpen;
    private NewsBrowserLabelProvider fLabelProvider;
    private String fNewsFontFamily;
    private String fNormalFontCSS;
    private Link fStatusLabel;

    public PreviewFeedDialog(Shell parentShell, IBookMark bookmark) {
        this(parentShell, bookmark, null, null);
    }

    public PreviewFeedDialog(Shell parentShell, IBookMark bookmark, FeedLinkReference feedReference) {
        this(parentShell, bookmark, null, feedReference);
    }

    public PreviewFeedDialog(Shell parentShell, IBookMark bookmark, IFeed feed) {
        this(parentShell, bookmark, feed, null);
    }

    PreviewFeedDialog(Shell parentShell, IBookMark bookmark, IFeed feed, FeedLinkReference feedReference) {
        super(parentShell);
        this.fBookmark = bookmark;
        this.fLoadedFeed = feed;
        this.fFeedReference = feedReference;
        this.fFirstTimeOpen = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY) == null;
        this.createFonts();
    }

    private void createFonts() {
        int fontHeight = 10;
        Font newsFont = OwlUI.getThemeFont("org.rssowl.ui.NewsTextFont", 0);
        FontData[] fontData = newsFont.getFontData();
        if (fontData.length > 0) {
            this.fNewsFontFamily = fontData[0].getName();
            fontHeight = fontData[0].getHeight();
        }
        int normal = fontHeight;
        String fontUnit = "pt";
        this.fNormalFontCSS = "font-size: " + normal + fontUnit + ";";
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fBrowser = new CBrowser(composite, 0);
        this.fBrowser.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fBrowser.setScriptDisabled(true);
        this.fBrowser.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    PreviewFeedDialog.this.close();
                }
            }
        });
        this.fLabelProvider = new NewsBrowserLabelProvider(this.fBrowser);
        this.loadFeed();
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        PreviewFeedDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void loadFeed() {
        if (this.fLoadedFeed == null || this.fLoadedFeed.getVisibleNews().isEmpty()) {
            if (StringUtils.isSet((String)this.fBookmark.getName())) {
                this.showMessage(NLS.bind((String)Messages.PreviewFeedDialog_LOAD_FEED_N, (Object)this.fBookmark.getName()), false, true);
            } else {
                this.showMessage(Messages.PreviewFeedDialog_LOAD_FEED, false, true);
            }
        }
        JobRunner.runUIUpdater(new UIBackgroundJob((Control)this.fBrowser.getControl()){
            private IFeed feed;
            private Exception error;

            protected void runInBackground(IProgressMonitor monitor) {
                if (PreviewFeedDialog.this.fLoadedFeed != null && !PreviewFeedDialog.this.fLoadedFeed.getVisibleNews().isEmpty()) {
                    this.feed = PreviewFeedDialog.this.fLoadedFeed;
                    return;
                }
                try {
                    if (PreviewFeedDialog.this.fFeedReference != null) {
                        this.feed = PreviewFeedDialog.this.fFeedReference.resolve();
                    }
                    if (this.feed == null || this.feed.getVisibleNews().isEmpty()) {
                        this.feed = Owl.getModelFactory().createFeed(null, PreviewFeedDialog.this.fBookmark.getFeedLinkReference().getLink());
                        if (monitor.isCanceled() || PreviewFeedDialog.this.getShell().isDisposed() || PreviewFeedDialog.this.fBrowser.getControl().isDisposed()) {
                            return;
                        }
                        IProtocolHandler handler = Owl.getConnectionService().getHandler(this.feed.getLink());
                        InputStream inS = handler.openStream(this.feed.getLink(), monitor, null);
                        if (monitor.isCanceled() || PreviewFeedDialog.this.getShell().isDisposed() || PreviewFeedDialog.this.fBrowser.getControl().isDisposed()) {
                            return;
                        }
                        Owl.getInterpreter().interpret(inS, this.feed, null);
                    }
                }
                catch (ConnectionException e) {
                    this.error = e;
                    Activator.safeLogError(e.getMessage(), e);
                }
                catch (ParserException e) {
                    this.error = e;
                    Activator.safeLogError(e.getMessage(), e);
                }
                catch (InterpreterException e) {
                    this.error = e;
                    Activator.safeLogError(e.getMessage(), e);
                }
            }

            protected void runInUI(IProgressMonitor monitor) {
                String errorMessage;
                if (this.feed != null && this.error == null) {
                    PreviewFeedDialog.this.showFeed(this.feed);
                } else if (this.error != null && StringUtils.isSet((String)(errorMessage = CoreUtils.toMessage((Throwable)this.error)))) {
                    PreviewFeedDialog.this.showMessage(NLS.bind((String)Messages.PreviewFeedDialog_UNABLE_LOAD_FEED, (Object)errorMessage), true, false);
                }
            }
        });
    }

    private void showMessage(String msg, boolean isError, boolean showProgress) {
        if (this.fBrowser.getControl().isDisposed()) {
            return;
        }
        StringBuilder html = new StringBuilder();
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        html.append("<html>\n");
        html.append("<body style=\"overflow: auto; font-family: ").append(this.fNewsFontFamily).append(",Verdanna,sans-serif; ").append(this.fNormalFontCSS).append("\">");
        if (showProgress) {
            html.append("<img src=\"" + OwlUI.getImageUri("/icons/obj16/progress.gif", "progress.gif") + "\" />");
        }
        if (isError) {
            html.append("<span style=\"color: darkred;\">");
        } else if (showProgress) {
            html.append("<span style=\"padding-left:3px; vertical-align:top;\">");
        }
        html.append(msg);
        if (isError || showProgress) {
            html.append("</span>");
        }
        html.append("</body>\n");
        html.append("</html>\n");
        this.fBrowser.getControl().setText(html.toString());
    }

    private void showFeed(final IFeed feed) {
        if (feed != null && !this.fBrowser.getControl().isDisposed()) {
            List news = feed.getNewsByStates(INews.State.getVisible());
            Collections.sort(news, new Comparator<INews>(){

                @Override
                public int compare(INews news1, INews news2) {
                    Date date1 = DateUtils.getRecentDate((INews)news1);
                    Date date2 = DateUtils.getRecentDate((INews)news2);
                    return date2.compareTo(date1);
                }
            });
            int newsCount = news.size();
            if (news.size() > 50) {
                news = news.subList(0, 50);
            }
            String html = this.fLabelProvider.render(news.toArray(), feed.getBase() != null ? URIUtils.toHTTP((URI)feed.getBase()) : URIUtils.toHTTP((URI)feed.getLink()), true);
            this.fBrowser.getControl().setText(html);
            if (StringUtils.isSet((String)this.fBookmark.getName())) {
                StringBuilder str = new StringBuilder();
                if (feed.getHomepage() != null) {
                    str.append(NLS.bind((String)Messages.PreviewFeedDialog_FOUND_N_NEWS_HOMEPAGE, (Object)newsCount, (Object)this.fBookmark.getName()));
                    this.fStatusLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            new OpenInBrowserAction((IStructuredSelection)new StructuredSelection((Object)feed.getHomepage())).run();
                        }
                    });
                } else {
                    str.append(NLS.bind((String)Messages.PreviewFeedDialog_FOUND_N_NEWS, (Object)newsCount, (Object)this.fBookmark.getName()));
                }
                this.fStatusLabel.setText(str.toString());
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (StringUtils.isSet((String)this.fBookmark.getName())) {
            shell.setText(NLS.bind((String)Messages.PreviewFeedDialog_PREVIEW_OF, (Object)this.fBookmark.getName()));
        } else {
            shell.setText(Messages.PreviewFeedDialog_PREVIEW);
        }
    }

    protected int getShellStyle() {
        int style = 0xCF0 | PreviewFeedDialog.getDefaultOrientation();
        return style;
    }

    protected Control createButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonBar.setLayout((Layout)layout);
        this.fStatusLabel = new Link(buttonBar, 0);
        PreviewFeedDialog.applyDialogFont((Control)this.fStatusLabel);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        if (StringUtils.isSet((String)this.fBookmark.getName())) {
            this.fStatusLabel.setText(this.fBookmark.getName());
        }
        Button closeButton = this.createButton(buttonBar, 12, IDialogConstants.CLOSE_LABEL, false);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewFeedDialog.this.close();
            }
        });
        return buttonBar;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section != null) {
            return section;
        }
        return settings.addNewSection(DIALOG_SETTINGS_KEY);
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        int minWidth = this.convertHorizontalDLUsToPixels(600);
        int minHeight = this.convertHorizontalDLUsToPixels(400);
        Point requiredSize = shell.computeSize(-1, -1);
        shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
        if (this.fFirstTimeOpen) {
            LayoutUtils.positionShell(shell);
        }
    }
}

