/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Application;
import org.rssowl.ui.internal.CoolBarAdvisor;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.Messages;
import org.rssowl.ui.internal.util.CColumnLayoutData;
import org.rssowl.ui.internal.util.CTable;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.LayoutUtils;

public class CustomizeToolbarDialog
extends Dialog {
    private static final String DIALOG_SETTINGS_KEY = "org.rssowl.ui.internal.dialogs.CustomizeToolbarDialog";
    private LocalResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
    private boolean fFirstTimeOpen = Activator.getDefault().getDialogSettings().getSection("org.rssowl.ui.internal.dialogs.CustomizeToolbarDialog") == null;
    private TableViewer fItemViewer;
    private ComboViewer fModeViewer;
    private IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fMoveUpButton;
    private Button fMoveDownButton;
    private Button fRestoreDefaults;
    private boolean fOkPressed;
    private Menu fAddMenu;
    private int[] fInitialToolBarItems;
    private int fInitialToolBarMode;
    private Color fSeparatorBorderFg = OwlUI.getColor((ResourceManager)this.fResources, new RGB(210, 210, 210));
    private Color fSeparatorBg = OwlUI.getColor((ResourceManager)this.fResources, new RGB(240, 240, 240));

    public CustomizeToolbarDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void okPressed() {
        this.fOkPressed = true;
        super.okPressed();
    }

    public int open() {
        this.fInitialToolBarItems = this.fPreferences.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
        this.fInitialToolBarMode = this.fPreferences.getInteger(DefaultPreferences.TOOLBAR_MODE);
        return super.open();
    }

    public boolean close() {
        OwlUI.safeDispose(this.fAddMenu);
        this.fResources.dispose();
        if (!this.fOkPressed) {
            this.fPreferences.putIntegers(DefaultPreferences.TOOLBAR_ITEMS, this.fInitialToolBarItems);
            this.fPreferences.putInteger(DefaultPreferences.TOOLBAR_MODE, this.fInitialToolBarMode);
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.CustomizeToolbarDialog_CUSTOMIZE_TOOLBAR);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = this.createContainer(parent);
        Label infoLabel = new Label(container, 0);
        infoLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        infoLabel.setText(Messages.CustomizeToolbarDialog_DIALOG_INFO);
        Composite tableContainer = new Composite(container, 0);
        tableContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        tableContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        CTable cTable = new CTable(tableContainer, 67586);
        this.fItemViewer = new TableViewer(cTable.getControl());
        this.fItemViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fItemViewer.getTable().setHeaderVisible(false);
        ((GridData)this.fItemViewer.getTable().getLayoutData()).heightHint = this.fItemViewer.getTable().getItemHeight() * 24;
        this.fItemViewer.getTable().setFocus();
        this.fItemViewer.getTable().setData("org.rssowl.ui.internal.FocuslessScrollHook", new Object());
        if (!OwlUI.isHighContrast()) {
            this.fItemViewer.getControl().addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    ToolBarItem item = (ToolBarItem)event.item.getData();
                    if (item.item == CoolBarAdvisor.CoolBarItem.SEPARATOR) {
                        Scrollable scrollable = (Scrollable)event.widget;
                        GC gc = event.gc;
                        Rectangle area = scrollable.getClientArea();
                        Rectangle rect = event.getBounds();
                        OwlUI.codExpandRegion(event, scrollable, gc, area);
                        Color oldForeground = gc.getForeground();
                        Color oldBackground = gc.getBackground();
                        gc.setBackground(CustomizeToolbarDialog.this.fSeparatorBg);
                        gc.fillRectangle(0, rect.y, area.width, rect.height);
                        gc.setForeground(CustomizeToolbarDialog.this.fSeparatorBorderFg);
                        gc.drawLine(0, rect.y + rect.height - 1, area.width, rect.y + rect.height - 1);
                        gc.drawLine(0, rect.y, area.width, rect.y);
                        gc.setForeground(oldForeground);
                        gc.setBackground(oldBackground);
                        event.detail &= 0xFFFFFFF7;
                    }
                }
            });
        }
        TableColumn nameCol = new TableColumn(this.fItemViewer.getTable(), 0);
        CColumnLayoutData data = new CColumnLayoutData(CColumnLayoutData.Size.FILL, 100);
        cTable.manageColumn(nameCol, data, Messages.CustomizeToolbarDialog_VISIBLE_ITEMS, null, null, false, false);
        this.fItemViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                int[] itemIds = CustomizeToolbarDialog.this.fPreferences.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
                Object[] items = new ToolBarItem[itemIds.length];
                int i = 0;
                while (i < itemIds.length) {
                    items[i] = new ToolBarItem(CoolBarAdvisor.CoolBarItem.values()[itemIds[i]]);
                    ++i;
                }
                return items;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.fItemViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                CoolBarAdvisor.CoolBarItem item = ((ToolBarItem)cell.getElement()).item;
                cell.setText(item.getName());
                if (item.getImg() != null) {
                    cell.setImage(CustomizeToolbarDialog.this.fResources.createImage(item.getImg()));
                }
                if (!OwlUI.isHighContrast() && item == CoolBarAdvisor.CoolBarItem.SPACER) {
                    cell.setForeground(CustomizeToolbarDialog.this.getShell().getDisplay().getSystemColor(16));
                }
            }
        });
        this.fItemViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CustomizeToolbarDialog.this.updateButtonEnablement();
            }
        });
        this.fItemViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || Application.IS_MAC && e.keyCode == 8) {
                    CustomizeToolbarDialog.this.onRemove();
                }
            }
        });
        this.fItemViewer.addDragSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(final DragSourceEvent event) {
                SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        IStructuredSelection selection = (IStructuredSelection)CustomizeToolbarDialog.this.fItemViewer.getSelection();
                        boolean bl = event.doit = selection.size() < CustomizeToolbarDialog.this.fItemViewer.getTable().getItemCount();
                        if (event.doit) {
                            LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                            LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                        }
                    }
                });
            }

            public void dragSetData(final DragSourceEvent event) {
                SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                            event.data = LocalSelectionTransfer.getTransfer().getSelection();
                        }
                    }
                });
            }

            public void dragFinished(DragSourceEvent event) {
                SafeRunnable.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        LocalSelectionTransfer.getTransfer().setSelection(null);
                        LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
                    }
                });
            }
        });
        ViewerDropAdapter dropSupport = new ViewerDropAdapter((Viewer)this.fItemViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return true;
            }

            public boolean performDrop(Object data) {
                ToolBarItem target = (ToolBarItem)this.getCurrentTarget();
                if (target != null) {
                    CustomizeToolbarDialog.this.onMove((StructuredSelection)data, target, this.getCurrentLocation());
                    return true;
                }
                return false;
            }
        };
        dropSupport.setFeedbackEnabled(true);
        dropSupport.setScrollEnabled(true);
        dropSupport.setSelectionFeedbackEnabled(true);
        this.fItemViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)dropSupport);
        this.fItemViewer.setInput((Object)this);
        Composite buttonContainer = new Composite(container, 0);
        buttonContainer.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0));
        buttonContainer.setLayoutData((Object)new GridData(1, 4, false, false));
        this.fAddMenu = new Menu((Decorations)this.getShell(), 8);
        this.fAddMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items;
                MenuItem[] menuItemArray = items = CustomizeToolbarDialog.this.fAddMenu.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                int[] toolbarItemIds = CustomizeToolbarDialog.this.fPreferences.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
                ArrayList<CoolBarAdvisor.CoolBarItem> visibleItems = new ArrayList<CoolBarAdvisor.CoolBarItem>();
                int[] nArray = toolbarItemIds;
                int n3 = toolbarItemIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    int toolbarItemId = nArray[n4];
                    visibleItems.add(CoolBarAdvisor.CoolBarItem.values()[toolbarItemId]);
                    ++n4;
                }
                CoolBarAdvisor.CoolBarItem[] toolItems = CustomizeToolbarDialog.this.getSortedItems();
                int currentGroup = -1;
                CoolBarAdvisor.CoolBarItem[] coolBarItemArray = toolItems;
                int n5 = toolItems.length;
                int n6 = 0;
                while (n6 < n5) {
                    final CoolBarAdvisor.CoolBarItem toolItem = coolBarItemArray[n6];
                    if (!visibleItems.contains((Object)toolItem) || toolItem == CoolBarAdvisor.CoolBarItem.SEPARATOR || toolItem == CoolBarAdvisor.CoolBarItem.SPACER) {
                        if (currentGroup >= 0 && currentGroup != toolItem.getGroup()) {
                            new MenuItem(CustomizeToolbarDialog.this.fAddMenu, 2);
                        }
                        MenuItem item = new MenuItem(CustomizeToolbarDialog.this.fAddMenu, 8);
                        if (StringUtils.isSet((String)toolItem.getTooltip())) {
                            item.setText(toolItem.getTooltip());
                        } else {
                            item.setText(toolItem.getName());
                        }
                        if (toolItem.getImg() != null) {
                            item.setImage(CustomizeToolbarDialog.this.fResources.createImage(toolItem.getImg()));
                        }
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                CustomizeToolbarDialog.this.onAdd(toolItem);
                                JobRunner.runInUIThread((Widget)CustomizeToolbarDialog.this.fAddMenu, new Runnable(){

                                    public void run() {
                                        CustomizeToolbarDialog.this.fAddMenu.setVisible(true);
                                    }
                                });
                            }
                        });
                        currentGroup = toolItem.getGroup();
                    }
                    ++n6;
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.fAddButton = new Button(buttonContainer, 1024);
        this.fAddButton.setText(Messages.CustomizeToolbarDialog_ADD);
        CustomizeToolbarDialog.applyDialogFont((Control)this.fAddButton);
        this.setButtonLayoutData(this.fAddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = CustomizeToolbarDialog.this.fAddButton.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = CustomizeToolbarDialog.this.fAddButton.toDisplay(pt);
                CustomizeToolbarDialog.this.fAddMenu.setLocation(pt.x, pt.y);
                CustomizeToolbarDialog.this.fAddMenu.setVisible(true);
            }
        });
        this.fRemoveButton = new Button(buttonContainer, 8);
        this.fRemoveButton.setText(Messages.CustomizeToolbarDialog_REMOVE);
        this.fRemoveButton.setEnabled(false);
        CustomizeToolbarDialog.applyDialogFont((Control)this.fRemoveButton);
        this.setButtonLayoutData(this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeToolbarDialog.this.onRemove();
            }
        });
        this.fMoveUpButton = new Button(buttonContainer, 8);
        this.fMoveUpButton.setText(Messages.CustomizeToolbarDialog_MOVE_UP);
        this.fMoveUpButton.setEnabled(false);
        CustomizeToolbarDialog.applyDialogFont((Control)this.fMoveUpButton);
        this.setButtonLayoutData(this.fMoveUpButton);
        ((GridData)this.fMoveUpButton.getLayoutData()).verticalIndent = 10;
        this.fMoveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeToolbarDialog.this.onMove(true);
            }
        });
        this.fMoveDownButton = new Button(buttonContainer, 8);
        this.fMoveDownButton.setText(Messages.CustomizeToolbarDialog_MOVE_DOWN);
        this.fMoveDownButton.setEnabled(false);
        CustomizeToolbarDialog.applyDialogFont((Control)this.fMoveDownButton);
        this.setButtonLayoutData(this.fMoveDownButton);
        this.fMoveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeToolbarDialog.this.onMove(false);
            }
        });
        this.fRestoreDefaults = new Button(buttonContainer, 8);
        this.fRestoreDefaults.setText(Messages.CustomizeToolbarDialog_RESTORE_DEFAULTS);
        CustomizeToolbarDialog.applyDialogFont((Control)this.fRestoreDefaults);
        this.setButtonLayoutData(this.fRestoreDefaults);
        ((GridData)this.fRestoreDefaults.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.fRestoreDefaults.getLayoutData()).verticalAlignment = 0x1000008;
        this.fRestoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeToolbarDialog.this.onRestoreDefaults();
            }
        });
        Composite modeContainer = new Composite(container, 0);
        modeContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 5, 0));
        modeContainer.setLayoutData((Object)new GridData(1, 4, false, false, 2, 1));
        Label showLabel = new Label(modeContainer, 0);
        showLabel.setText(Messages.CustomizeToolbarDialog_SHOW);
        this.fModeViewer = new ComboViewer(modeContainer, 2056);
        this.fModeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fModeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CoolBarAdvisor.CoolBarMode) {
                    switch ((CoolBarAdvisor.CoolBarMode)((Object)element)) {
                        case IMAGE: {
                            return Messages.CustomizeToolbarDialog_ICONS;
                        }
                        case TEXT: {
                            return Messages.CustomizeToolbarDialog_TEXT;
                        }
                        case IMAGE_TEXT_VERTICAL: {
                            return Messages.CustomizeToolbarDialog_ICONS_AND_TEXT;
                        }
                        case IMAGE_TEXT_HORIZONTAL: {
                            return Messages.CustomizeToolbarDialog_ICONS_AND_TEXT_SMALL;
                        }
                    }
                }
                return super.getText(element);
            }
        });
        this.fModeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                CoolBarAdvisor.CoolBarMode mode = (CoolBarAdvisor.CoolBarMode)((Object)selection);
                CustomizeToolbarDialog.this.fPreferences.putInteger(DefaultPreferences.TOOLBAR_MODE, mode.ordinal());
            }
        });
        this.fModeViewer.setInput((Object)CoolBarAdvisor.CoolBarMode.values());
        this.fModeViewer.setSelection((ISelection)new StructuredSelection((Object)CoolBarAdvisor.CoolBarMode.values()[this.fPreferences.getInteger(DefaultPreferences.TOOLBAR_MODE)]));
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 1, true, false));
        CustomizeToolbarDialog.applyDialogFont((Control)container);
        return container;
    }

    private CoolBarAdvisor.CoolBarItem[] getSortedItems() {
        CoolBarAdvisor.CoolBarItem[] items = CoolBarAdvisor.CoolBarItem.values();
        ArrayList<CoolBarAdvisor.CoolBarItem> sortedItems = new ArrayList<CoolBarAdvisor.CoolBarItem>(items.length);
        sortedItems.addAll(Arrays.asList(items));
        sortedItems.remove((Object)CoolBarAdvisor.CoolBarItem.DELETE);
        sortedItems.add(sortedItems.indexOf((Object)CoolBarAdvisor.CoolBarItem.PRINT), CoolBarAdvisor.CoolBarItem.DELETE);
        sortedItems.remove((Object)CoolBarAdvisor.CoolBarItem.ATTACHMENTS);
        sortedItems.add(sortedItems.indexOf((Object)CoolBarAdvisor.CoolBarItem.PRINT) + 1, CoolBarAdvisor.CoolBarItem.ATTACHMENTS);
        sortedItems.remove((Object)CoolBarAdvisor.CoolBarItem.ARCHIVE);
        sortedItems.add(sortedItems.indexOf((Object)CoolBarAdvisor.CoolBarItem.COPY) + 1, CoolBarAdvisor.CoolBarItem.ARCHIVE);
        return sortedItems.toArray(new CoolBarAdvisor.CoolBarItem[sortedItems.size()]);
    }

    private void onAdd(CoolBarAdvisor.CoolBarItem newItem) {
        int[] toolbarItemIds = this.fPreferences.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
        ArrayList<CoolBarAdvisor.CoolBarItem> newItems = new ArrayList<CoolBarAdvisor.CoolBarItem>();
        int[] nArray = toolbarItemIds;
        int n = toolbarItemIds.length;
        int n2 = 0;
        while (n2 < n) {
            int toolbarItemId = nArray[n2];
            newItems.add(CoolBarAdvisor.CoolBarItem.values()[toolbarItemId]);
            ++n2;
        }
        int selectionIndex = this.fItemViewer.getTable().getSelectionIndex();
        if (selectionIndex >= 0) {
            newItems.add(selectionIndex + 1, newItem);
        } else {
            newItems.add(newItem);
        }
        int[] newItemsRaw = new int[newItems.size()];
        int i = 0;
        while (i < newItems.size()) {
            newItemsRaw[i] = ((CoolBarAdvisor.CoolBarItem)((Object)newItems.get(i))).ordinal();
            ++i;
        }
        this.fPreferences.putIntegers(DefaultPreferences.TOOLBAR_ITEMS, newItemsRaw);
        this.fItemViewer.refresh();
        if (selectionIndex >= 0) {
            this.fItemViewer.getTable().setSelection(selectionIndex + 1);
        } else {
            this.fItemViewer.getTable().setSelection(this.fItemViewer.getTable().getItemCount() - 1);
        }
        this.updateButtonEnablement();
    }

    private void onRemove() {
        int[] toolbarItemIds = this.fPreferences.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
        ArrayList<CoolBarAdvisor.CoolBarItem> newItems = new ArrayList<CoolBarAdvisor.CoolBarItem>();
        int[] nArray = toolbarItemIds;
        int n = toolbarItemIds.length;
        int n2 = 0;
        while (n2 < n) {
            int toolbarItemId = nArray[n2];
            newItems.add(CoolBarAdvisor.CoolBarItem.values()[toolbarItemId]);
            ++n2;
        }
        int[] selectionIndices = this.fItemViewer.getTable().getSelectionIndices();
        int i = 0;
        while (i < selectionIndices.length) {
            int index = selectionIndices[i] - i;
            newItems.remove(index);
            ++i;
        }
        int[] newItemsRaw = new int[newItems.size()];
        int i2 = 0;
        while (i2 < newItems.size()) {
            newItemsRaw[i2] = ((CoolBarAdvisor.CoolBarItem)((Object)newItems.get(i2))).ordinal();
            ++i2;
        }
        this.fPreferences.putIntegers(DefaultPreferences.TOOLBAR_ITEMS, newItemsRaw);
        this.fItemViewer.refresh();
        int tableItemCount = this.fItemViewer.getTable().getItemCount();
        if (selectionIndices.length > 0 && selectionIndices[0] < tableItemCount) {
            this.fItemViewer.getTable().setSelection(selectionIndices[0]);
        } else if (tableItemCount > 0) {
            this.fItemViewer.getTable().setSelection(tableItemCount - 1);
        }
        this.updateButtonEnablement();
    }

    private Composite createContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parent.getFont());
        return composite;
    }

    private void onRestoreDefaults() {
        IPreferenceScope defaultScope = Owl.getPreferenceService().getDefaultScope();
        int[] defaultItemsState = defaultScope.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
        int defaultMode = defaultScope.getInteger(DefaultPreferences.TOOLBAR_MODE);
        this.fPreferences.putIntegers(DefaultPreferences.TOOLBAR_ITEMS, defaultItemsState);
        this.fPreferences.putInteger(DefaultPreferences.TOOLBAR_MODE, defaultMode);
        this.fItemViewer.refresh();
        this.fModeViewer.setSelection((ISelection)new StructuredSelection((Object)CoolBarAdvisor.CoolBarMode.values()[defaultMode]));
        this.updateButtonEnablement();
    }

    private void updateButtonEnablement() {
        boolean enableMoveUp = true;
        boolean enableMoveDown = true;
        int[] selectionIndices = this.fItemViewer.getTable().getSelectionIndices();
        if (selectionIndices.length == 1) {
            enableMoveUp = selectionIndices[0] != 0;
            enableMoveDown = selectionIndices[0] != this.fItemViewer.getTable().getItemCount() - 1;
        } else {
            enableMoveUp = false;
            enableMoveDown = false;
        }
        this.fMoveUpButton.setEnabled(enableMoveUp);
        this.fMoveDownButton.setEnabled(enableMoveDown);
        this.fRemoveButton.setEnabled(!this.fItemViewer.getSelection().isEmpty());
    }

    private void onMove(StructuredSelection selection, ToolBarItem destination, int location) {
        TableItem[] items;
        Object[] selectedElements;
        ArrayList<ToolBarItem> movedItems = new ArrayList<ToolBarItem>();
        Object[] objectArray = selectedElements = selection.toArray();
        int n = selectedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            movedItems.add((ToolBarItem)element);
            ++n2;
        }
        ArrayList<ToolBarItem> visibleItems = new ArrayList<ToolBarItem>();
        TableItem[] tableItemArray = items = this.fItemViewer.getTable().getItems();
        int n3 = items.length;
        int n4 = 0;
        while (n4 < n3) {
            TableItem item = tableItemArray[n4];
            visibleItems.add((ToolBarItem)item.getData());
            ++n4;
        }
        if (movedItems.isEmpty() || visibleItems.isEmpty()) {
            return;
        }
        visibleItems.removeAll(movedItems);
        int destinationIndex = visibleItems.indexOf(destination);
        if (destinationIndex >= 0) {
            if (location == 3 || location == 2) {
                ++destinationIndex;
            }
            visibleItems.addAll(destinationIndex, movedItems);
            int[] newToolBarItems = new int[visibleItems.size()];
            int i = 0;
            while (i < visibleItems.size()) {
                newToolBarItems[i] = ((ToolBarItem)visibleItems.get((int)i)).item.ordinal();
                ++i;
            }
            this.fPreferences.putIntegers(DefaultPreferences.TOOLBAR_ITEMS, newToolBarItems);
            this.fItemViewer.refresh();
            this.fItemViewer.getTable().setSelection(destinationIndex, destinationIndex + movedItems.size() - 1);
            this.updateButtonEnablement();
        }
    }

    private void onMove(boolean up) {
        TableItem[] items = this.fItemViewer.getTable().getItems();
        int[] toolbarItemIds = this.fPreferences.getIntegers(DefaultPreferences.TOOLBAR_ITEMS);
        int selectedIndex = this.fItemViewer.getTable().getSelectionIndex();
        if (up && selectedIndex > 0) {
            int order2;
            int order1 = toolbarItemIds[selectedIndex];
            toolbarItemIds[selectedIndex] = order2 = toolbarItemIds[selectedIndex - 1];
            toolbarItemIds[selectedIndex - 1] = order1;
        } else if (!up && selectedIndex < items.length - 1) {
            int order2;
            int order1 = toolbarItemIds[selectedIndex];
            toolbarItemIds[selectedIndex] = order2 = toolbarItemIds[selectedIndex + 1];
            toolbarItemIds[selectedIndex + 1] = order1;
        }
        this.fPreferences.putIntegers(DefaultPreferences.TOOLBAR_ITEMS, toolbarItemIds);
        this.fItemViewer.refresh();
        this.fItemViewer.getTable().setSelection(up ? selectedIndex - 1 : selectedIndex + 1);
        this.updateButtonEnablement();
    }

    protected Control createButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonBar.setLayout((Layout)layout);
        Composite infoContainer = new Composite(buttonBar, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        infoContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)infoContainer.getLayout()).marginRight = 10;
        Label infoImg = new Label(infoContainer, 0);
        infoImg.setImage(OwlUI.getImage((ResourceManager)this.fResources, "icons/obj16/info.gif"));
        infoImg.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label infoText = new Label(infoContainer, 64);
        infoText.setText(Messages.CustomizeToolbarDialog_USE_MOUSE_INFO);
        infoText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        CustomizeToolbarDialog.applyDialogFont((Control)infoContainer);
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section != null) {
            return section;
        }
        return settings.addNewSection(DIALOG_SETTINGS_KEY);
    }

    protected int getDialogBoundsStrategy() {
        return 3;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        if (this.fFirstTimeOpen) {
            Shell shell = this.getShell();
            int minWidth = this.convertHorizontalDLUsToPixels(320);
            int minHeight = shell.computeSize((int)minWidth, (int)-1).y;
            Point requiredSize = shell.computeSize(-1, -1);
            shell.setSize(Math.max(minWidth, requiredSize.x), Math.max(minHeight, requiredSize.y));
            LayoutUtils.positionShell(shell);
        }
    }

    private static class ToolBarItem {
        CoolBarAdvisor.CoolBarItem item;

        ToolBarItem(CoolBarAdvisor.CoolBarItem theItem) {
            this.item = theItem;
        }
    }
}

