/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.search.UpdateSearchScope;
import org.eclipse.update.ui.UpdateJob;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.actions.ShowActivityAction;
import org.rssowl.ui.internal.dialogs.UpdateDialog;
import org.rssowl.ui.internal.util.JobRunner;
import org.rssowl.ui.internal.util.UIBackgroundJob;

public class FindUpdatesAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String UPDATE_SITE = "http://boreal.rssowl.org/update/program/";
    private Shell fShell;
    private final boolean fUserInitiated;

    public FindUpdatesAction() {
        this(true);
    }

    public FindUpdatesAction(boolean userInitiated) {
        this.fUserInitiated = userInitiated;
    }

    public void run() {
        if (Controller.getDefault().isUpdateDisabled()) {
            return;
        }
        try {
            UpdateSearchScope scope = new UpdateSearchScope();
            scope.addSearchSite("RSSOwl.org", new URL(UPDATE_SITE), null);
            scope.setFeatureProvidedSitesEnabled(false);
            final UpdateJob job = new UpdateJob(Messages.FindUpdatesAction_UPDATE_SEARCH, true, false);
            job.getSearchRequest().setScope(scope);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    JobRunner.runInUIThread((Widget)FindUpdatesAction.this.fShell, new Runnable(){

                        public void run() {
                            if (Controller.getDefault().isShuttingDown() || FindUpdatesAction.this.fShell != null && FindUpdatesAction.this.fShell.isDisposed()) {
                                return;
                            }
                            if (job.getStatus().isOK()) {
                                FindUpdatesAction.this.handleUpdates(job.getUpdates());
                            } else {
                                FindUpdatesAction.this.handleError(job.getStatus());
                            }
                        }
                    });
                }
            });
            if (this.fUserInitiated) {
                job.setUser(true);
                job.setPriority(10);
            } else {
                job.setUser(false);
                job.setSystem(true);
            }
            job.schedule();
        }
        catch (MalformedURLException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
    }

    private void handleUpdates(final IInstallFeatureOperation[] updates) {
        if (updates.length == 0) {
            if (this.fUserInitiated) {
                MessageDialog.openInformation((Shell)this.fShell, (String)Messages.FindUpdatesAction_CHECK_UPDATES, (String)Messages.FindUpdatesAction_NO_UPDATES_AVAILABLE);
            }
            return;
        }
        UpdateDialog dialog = new UpdateDialog(this.fShell, updates);
        if (dialog.open() != 0) {
            return;
        }
        ShowActivityAction action = new ShowActivityAction();
        action.init(this.fShell);
        action.run(null);
        JobRunner.runUIUpdater(new UIBackgroundJob((Control)this.fShell, Messages.FindUpdatesAction_DOWNLOADING_UPDATES){
            boolean errorUpdating;

            protected void runInBackground(IProgressMonitor monitor) {
                IInstallFeatureOperation[] iInstallFeatureOperationArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallFeatureOperation update = iInstallFeatureOperationArray[n2];
                    if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) break;
                    try {
                        IConfiguredSite configSite = UpdateUtils.getDefaultTargetSite((IInstallConfiguration)SiteManager.getLocalSite().getCurrentConfiguration(), (IInstallFeatureOperation)update);
                        if (configSite != null) {
                            update.setTargetSite(configSite);
                            Activator.safeLogInfo("Start: Application Update");
                            update.execute(monitor, null);
                            Activator.safeLogInfo("Finished: Application Update");
                        }
                    }
                    catch (CoreException e) {
                        this.errorUpdating = true;
                        Activator.safeLogError(e.getMessage(), e);
                    }
                    catch (InvocationTargetException e) {
                        this.errorUpdating = true;
                        Activator.safeLogError(e.getMessage(), e);
                    }
                    ++n2;
                }
            }

            protected void runInUI(IProgressMonitor monitor) {
                if (!Controller.getDefault().isShuttingDown()) {
                    if (!this.errorUpdating) {
                        boolean restart = MessageDialog.openQuestion((Shell)FindUpdatesAction.this.fShell, (String)Messages.FindUpdatesAction_RESTART_RSSOWL, (String)Messages.FindUpdatesAction_RESTART_AFTER_UPDATE);
                        if (restart) {
                            Controller.getDefault().restart();
                        }
                    } else {
                        MessageDialog.openWarning((Shell)FindUpdatesAction.this.fShell, (String)Messages.FindUpdatesAction_CHECK_UPDATES, (String)Messages.FindUpdatesAction_WARNING_UPDATE_FAILED);
                    }
                }
            }
        }, true);
    }

    private void handleError(IStatus status) {
        if (this.fUserInitiated) {
            String msg = Messages.FindUpdatesAction_WARNING_SEARCH_FAILED;
            if (StringUtils.isSet((String)status.getMessage())) {
                msg = String.valueOf(msg) + "\n\n" + NLS.bind((String)Messages.FindUpdatesAction_REASON, (Object)status.getMessage());
            }
            MessageDialog.openWarning((Shell)this.fShell, (String)Messages.FindUpdatesAction_CHECK_UPDATES, (String)msg);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fShell = window.getShell();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

