/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.LongArrayList;
import org.rssowl.core.internal.persist.Mark;
import org.rssowl.core.internal.persist.NewsContainer;
import org.rssowl.core.internal.persist.SearchMark;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.INewsMark;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchField;
import org.rssowl.core.persist.ISearchMark;
import org.rssowl.core.persist.SearchSpecifier;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.ModelReference;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.persist.service.IModelSearch;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.SearchHit;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.editors.feed.NewsFilter;
import org.rssowl.ui.internal.util.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderNewsMark
extends Mark
implements INewsMark {
    private final Set<Long> fNewsContainer;
    private final IFolder fFolder;
    private final INewsDAO fNewsDao;
    private final IModelFactory fFactory;
    private final IModelSearch fSearch;

    public FolderNewsMark(IFolder folder) {
        super(folder.getId(), folder, folder.getName());
        this.fFolder = folder;
        this.fNewsContainer = new HashSet<Long>();
        this.fNewsDao = (INewsDAO)DynamicDAO.getDAO(INewsDAO.class);
        this.fFactory = Owl.getModelFactory();
        this.fSearch = Owl.getPersistenceService().getModelSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Collection<INews> news) {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            for (INews item : news) {
                if (item == null || item.getId() == null) continue;
                this.fNewsContainer.add(item.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(long[] elements) {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            long[] lArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                long element = lArray[n2];
                if (element > 0L) {
                    this.fNewsContainer.add(element);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(List<SearchHit<NewsReference>> results) {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            for (SearchHit<NewsReference> result : results) {
                this.fNewsContainer.add(((NewsReference)result.getResult()).getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection<INews> news) {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            for (INews item : news) {
                if (item == null || item.getId() == null) continue;
                this.fNewsContainer.remove(item.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NewsReference> getNewsRefs() {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            ArrayList<NewsReference> news = new ArrayList<NewsReference>(this.fNewsContainer.size());
            for (Long id : this.fNewsContainer) {
                news.add(new NewsReference(id.longValue()));
            }
            return news;
        }
    }

    public List<NewsReference> getNewsRefs(Set<INews.State> states) {
        return this.getNewsRefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewsCount(Set<INews.State> states) {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            return this.fNewsContainer.size();
        }
    }

    public boolean containsNews(INews news) {
        return news.getId() != null && this.containsNews(news.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNews(long newsId) {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            return this.fNewsContainer.contains(newsId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<INews> getNews() {
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            ArrayList<INews> news = new ArrayList<INews>(this.fNewsContainer.size());
            for (Long id : this.fNewsContainer) {
                INews item = (INews)this.fNewsDao.load(id.longValue());
                if (item == null) continue;
                news.add(item);
            }
            return news;
        }
    }

    public List<INews> getNews(Set<INews.State> states) {
        return this.getNews();
    }

    public boolean isGetNewsRefsEfficient() {
        return true;
    }

    public ModelReference toReference() {
        return new FolderNewsMarkReference(this.getId());
    }

    public IFolder getFolder() {
        return this.fFolder;
    }

    public synchronized void setProperty(String key, Serializable value) {
        this.fFolder.setProperty(key, value);
    }

    public synchronized String getName() {
        return this.fFolder.getName();
    }

    public synchronized Map<String, Serializable> getProperties() {
        return this.fFolder.getProperties();
    }

    public synchronized Object getProperty(String key) {
        return this.fFolder.getProperty(key);
    }

    public synchronized IFolder getParent() {
        return this.fFolder.getParent();
    }

    public boolean contains(INewsMark mark) {
        return this.contains(this.fFolder, mark);
    }

    private boolean contains(IFolder folder, INewsMark mark) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder && this.contains((IFolder)child, mark)) {
                return true;
            }
            if (!child.equals(mark)) continue;
            return true;
        }
        return false;
    }

    public boolean isRelatedTo(ISearchMark searchMark) {
        return this.isRelatedTo(this.fFolder, searchMark);
    }

    private boolean isRelatedTo(IFolder folder, ISearchMark searchMark) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder && this.isRelatedTo((IFolder)child, searchMark)) {
                return true;
            }
            if (!child.equals(searchMark)) continue;
            return true;
        }
        return false;
    }

    public boolean isRelatedTo(INews news) {
        if (this.containsNews(news)) {
            return true;
        }
        FeedLinkReference feedRef = news.getFeedReference();
        return this.isRelatedTo(this.fFolder, news, feedRef);
    }

    private boolean isRelatedTo(IFolder folder, INews news, FeedLinkReference ref) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            INewsBin bin;
            IBookMark bookmark;
            if (child instanceof IFolder && this.isRelatedTo((IFolder)child, news, ref)) {
                return true;
            }
            if (!(news.getParentId() == 0L && child instanceof IBookMark ? (bookmark = (IBookMark)child).getFeedLinkReference().equals((Object)ref) : news.getParentId() != 0L && child instanceof INewsBin && (bin = (INewsBin)child).getId().longValue() == news.getParentId())) continue;
            return true;
        }
        return false;
    }

    public void resolve(NewsFilter.Type type, IProgressMonitor monitor) {
        this.doResolve(type, monitor, false);
    }

    public NewsContainer resolveNewsContainer(IProgressMonitor monitor) {
        return this.doResolve(NewsFilter.Type.SHOW_ALL, monitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NewsContainer doResolve(NewsFilter.Type type, IProgressMonitor monitor, boolean resolveContainer) {
        NewsContainer container = null;
        if (resolveContainer) {
            container = new NewsContainer(Collections.emptyMap());
        }
        FolderNewsMark folderNewsMark = this;
        synchronized (folderNewsMark) {
            this.fNewsContainer.clear();
        }
        if (Controller.getDefault().isShuttingDown() || monitor != null && monitor.isCanceled()) {
            return container;
        }
        ISearchCondition filterCondition = ModelUtils.getConditionForFilter(type);
        ArrayList<ISearchCondition> conditions = new ArrayList<ISearchCondition>(2);
        ISearchField field = this.fFactory.createSearchField(19, INews.class.getName());
        ISearchCondition locationCondition = this.fFactory.createSearchCondition(field, SearchSpecifier.IS, (Object)ModelUtils.toPrimitive(Collections.singleton(this.fFolder)));
        conditions.add(locationCondition);
        if (filterCondition != null) {
            conditions.add(filterCondition);
        }
        List results = this.fSearch.searchNews(conditions, conditions.size() == 2);
        this.addAll(results);
        if (resolveContainer) {
            this.addAll(container, results);
        }
        if (Controller.getDefault().isShuttingDown() || monitor != null && monitor.isCanceled()) {
            return container;
        }
        HashSet<ISearchMark> searches = new HashSet<ISearchMark>();
        this.findSearches(this.fFolder, searches);
        for (ISearchMark search : searches) {
            if (type == NewsFilter.Type.SHOW_RECENT || type == NewsFilter.Type.SHOW_LAST_5_DAYS || type == NewsFilter.Type.SHOW_STICKY || type == NewsFilter.Type.SHOW_LABELED) {
                List conditions2 = search.getSearchConditions();
                List results2 = this.fSearch.searchNews((Collection)conditions2, filterCondition, search.matchAllConditions());
                this.addAll(results2);
                if (resolveContainer) {
                    this.addAll(container, results2);
                }
            } else {
                LongArrayList[] newsIds = ((SearchMark)search).internalGetNewsContainer().internalGetNewsIds();
                int i = 0;
                while (i < newsIds.length) {
                    if (!(i == INews.State.HIDDEN.ordinal() || i == INews.State.DELETED.ordinal() || type == NewsFilter.Type.SHOW_NEW && i != INews.State.NEW.ordinal() || type == NewsFilter.Type.SHOW_UNREAD && i == INews.State.READ.ordinal())) {
                        this.addAll(newsIds[i].getElements());
                    }
                    ++i;
                }
                if (resolveContainer) {
                    this.addAll(container, newsIds);
                }
            }
            if (!Controller.getDefault().isShuttingDown() && (monitor == null || !monitor.isCanceled())) continue;
            return container;
        }
        return container;
    }

    private void addAll(NewsContainer container, LongArrayList[] newsIds) {
        int i = 0;
        while (i < newsIds.length && i < container.internalGetNewsIds().length) {
            LongArrayList list = container.internalGetNewsIds()[i];
            int j = 0;
            while (j < newsIds[i].size()) {
                list.add(newsIds[i].get(j));
                ++j;
            }
            ++i;
        }
    }

    private void addAll(NewsContainer container, List<SearchHit<NewsReference>> results) {
        LongArrayList[] newsIds = container.internalGetNewsIds();
        for (SearchHit<NewsReference> result : results) {
            INews.State state = (INews.State)result.getData((Object)14);
            if (newsIds.length <= state.ordinal()) continue;
            newsIds[state.ordinal()].add(((NewsReference)result.getResult()).getId());
        }
    }

    private void findSearches(IFolder folder, Set<ISearchMark> searches) {
        List children = folder.getChildren();
        for (IFolderChild child : children) {
            if (child instanceof IFolder) {
                this.findSearches((IFolder)child, searches);
                continue;
            }
            if (!(child instanceof ISearchMark)) continue;
            searches.add((ISearchMark)child);
        }
    }

    public static final class FolderNewsMarkReference
    extends ModelReference {
        public FolderNewsMarkReference(long id) {
            super(id, FolderNewsMark.class);
        }

        public IFolder resolve() throws PersistenceException {
            throw new UnsupportedOperationException();
        }
    }
}

