/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.MVStatusBar;
import mediathek.res.GetIcon;
import mediathek.tool.ListenerMediathekView;
import net.sf.jcarrierpigeon.Notification;
import net.sf.jcarrierpigeon.NotificationQueue;
import net.sf.jcarrierpigeon.WindowPosition;

public final class MVTray {
    private final Daten daten;
    private int trayState = 0;
    private SystemTray tray = null;
    private TrayIcon trayIcon = null;

    public MVTray(Daten daten) {
        this.daten = daten;
    }

    public void beenden() {
        if (this.tray != null && this.trayIcon != null) {
            this.tray.remove(this.trayIcon);
        }
    }

    public MVTray systemTray() {
        if (!SystemTray.isSupported()) {
            Log.systemMeldung("Tray wird nicht unterst\u00fctzt!");
            return null;
        }
        this.tray = SystemTray.getSystemTray();
        this.trayIcon = new TrayIcon(GetIcon.getIcon("mv-tray.png").getImage());
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.setToolTip(this.getInfoTextDownloads());
        this.addListener();
        PopupMenu popup = new PopupMenu();
        this.trayIcon.setPopupMenu(popup);
        MenuItem itemInfo = new MenuItem("Infos anzeigen");
        itemInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVTray.this.addNotification(MVTray.this.getTextInfos());
            }
        });
        popup.add(itemInfo);
        MenuItem itemRemoveTray = new MenuItem("Trayicon ausblenden");
        itemRemoveTray.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVTray)MVTray.this).daten.mediathekGui.setVisible(true);
                Daten.mVConfig.add("Tray-anzeigen", Boolean.toString(false));
                ((MVTray)MVTray.this).daten.mediathekGui.setTray();
                ListenerMediathekView.notify(35, MVTray.class.getSimpleName());
            }
        });
        popup.add(itemRemoveTray);
        popup.addSeparator();
        MenuItem itemBeenden = new MenuItem("Programm beenden");
        itemBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MVTray)MVTray.this).daten.mediathekGui.beenden(false, false);
            }
        });
        popup.add(itemBeenden);
        this.trayIcon.setPopupMenu(popup);
        try {
            this.tray.add(this.trayIcon);
            return this;
        }
        catch (AWTException e) {
            Log.systemMeldung("Tray konnte nicht geladen werden!");
            return null;
        }
    }

    private void addListener() {
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1) {
                    ((MVTray)MVTray.this).daten.mediathekGui.setVisible(!((MVTray)MVTray.this).daten.mediathekGui.isVisible());
                    if (((MVTray)MVTray.this).daten.mediathekGui.isVisible()) {
                        ((MVTray)MVTray.this).daten.mediathekGui.toFront();
                        ((MVTray)MVTray.this).daten.mediathekGui.requestFocus();
                    }
                }
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(30, MVStatusBar.class.getSimpleName()){
            int count;
            {
                this.count = 0;
            }

            @Override
            public void ping() {
                int[] starts;
                ++this.count;
                if (this.count > 3) {
                    MVTray.this.trayIcon.setToolTip(MVTray.this.getInfoTextDownloads());
                }
                if ((starts = Daten.downloadInfos.downloadStarts)[6] > 0) {
                    if (MVTray.this.trayState != 2) {
                        MVTray.this.trayState = 2;
                        MVTray.this.trayIcon.setImage(GetIcon.getIcon("mv-tray-fehler.png").getImage());
                    }
                } else if (starts[4] > 0) {
                    if (MVTray.this.trayState != 1) {
                        MVTray.this.trayState = 1;
                        MVTray.this.trayIcon.setImage(GetIcon.getIcon("mv-tray-download.png").getImage());
                    }
                } else if (MVTray.this.trayState != 0) {
                    MVTray.this.trayState = 0;
                    MVTray.this.trayIcon.setImage(GetIcon.getIcon("mv-tray.png").getImage());
                }
            }
        });
    }

    private String getTextInfos() {
        String strText = "<html><head></head><body><p>";
        strText = strText + "Filmliste erstellt: " + Daten.listeFilme.genDate() + " Uhr  ";
        strText = strText + "<br />";
        strText = strText + "Anz. Filme: " + Daten.listeFilme.size();
        strText = strText + "<br />";
        strText = strText + this.getInfoTextDownloads();
        strText = strText + "</p></body></html>";
        return strText;
    }

    private String getInfoTextDownloads() {
        int[] starts = Daten.downloadInfos.downloadStarts;
        String text = "Downloads: " + starts[0];
        boolean print = false;
        for (int ii = 1; ii < starts.length; ++ii) {
            if (starts[ii] <= 0) continue;
            print = true;
            break;
        }
        if (print) {
            text = text + "   [ ";
            text = starts[4] == 1 ? text + "1 l\u00e4uft" : text + starts[4] + " laufen";
            if (starts[4] > 0) {
                text = text + " (" + Daten.downloadInfos.bandwidthStr + ")";
            }
            text = starts[3] == 1 ? text + ", 1 wartet" : text + ", " + starts[3] + " warten";
            if (starts[5] > 0) {
                text = starts[5] == 1 ? text + ", 1 fertig" : text + ", " + starts[5] + " fertig";
            }
            if (starts[6] > 0) {
                text = starts[6] == 1 ? text + ", 1 fehlerhaft" : text + ", " + starts[6] + " fehlerhaft";
            }
            text = text + " ]";
        }
        return text;
    }

    private void addNotification(String meldung) {
        if (Boolean.parseBoolean(Daten.mVConfig.get("Notification-anzeigen"))) {
            JWindow messageFrame = new JWindow();
            messageFrame.setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            panel.setBackground(Color.BLACK);
            messageFrame.setContentPane(panel);
            JLabel iconLabel = new JLabel(GetIcon.getIcon("mv-notification.png", "/mediathek/res/"));
            iconLabel.setVerticalAlignment(1);
            messageFrame.getContentPane().add((Component)iconLabel, "West");
            JLabel meldungsLabel = new JLabel(meldung);
            meldungsLabel.setForeground(Color.WHITE);
            messageFrame.getContentPane().add((Component)meldungsLabel, "Center");
            messageFrame.pack();
            messageFrame.setFocusableWindowState(false);
            Notification notification = new Notification(messageFrame, WindowPosition.BOTTOMRIGHT, 20, 20, 6000);
            NotificationQueue q = new NotificationQueue();
            q.add(notification);
        }
    }
}

